/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.execution.DropFunctionTask;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.execution.TaskTestUtils;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.function.SqlFunctionId;
import com.facebook.presto.spi.security.AccessControl;
import com.facebook.presto.spi.security.AllowAllAccessControl;
import com.facebook.presto.sql.parser.ParsingOptions;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.tree.DropFunction;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.transaction.InMemoryTransactionManager;
import com.facebook.presto.transaction.TransactionManager;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

public class TestDropFunctionTask {
    private final MetadataManager metadataManager = MetadataManager.createTestMetadataManager();
    private final ExecutorService executorService = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test-%s"));

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.executorService.shutdownNow();
    }

    @Test
    public void testDropTemporaryFunction() {
        String sqlString = "DROP TEMPORARY FUNCTION foo()";
        SqlFunctionId signature = new SqlFunctionId(QualifiedObjectName.valueOf((String)"presto.session.foo"), Collections.emptyList());
        Session session = TestingSession.testSessionBuilder().addSessionFunction(signature, null).build();
        Set<SqlFunctionId> removedSessionFunctions = this.executeAndGetRemovedSessionFunctions(sqlString, session);
        Assert.assertTrue((boolean)removedSessionFunctions.contains(signature));
    }

    @Test(expectedExceptions={PrestoException.class}, expectedExceptionsMessageRegExp="Session function .* not found")
    public void testDropMissingTemporaryFunctionFails() {
        String sqlString = "DROP TEMPORARY FUNCTION foo()";
        Set<SqlFunctionId> removedSessionFunctions = this.executeAndGetRemovedSessionFunctions(sqlString, SessionTestUtils.TEST_SESSION);
        Assert.assertEquals((int)removedSessionFunctions.size(), (int)0);
    }

    @Test
    public void testDropMissingTemporaryFunctionIfExistsFailsSilently() {
        String sqlString = "DROP TEMPORARY FUNCTION IF EXISTS foo()";
        Set<SqlFunctionId> removedSessionFunctions = this.executeAndGetRemovedSessionFunctions(sqlString, SessionTestUtils.TEST_SESSION);
        Assert.assertEquals((int)removedSessionFunctions.size(), (int)0);
    }

    private Set<SqlFunctionId> executeAndGetRemovedSessionFunctions(String sqlString, Session session) {
        SqlParser parser = new SqlParser();
        DropFunction statement = (DropFunction)parser.createStatement(sqlString, ParsingOptions.builder().build());
        TransactionManager tm = InMemoryTransactionManager.createTestTransactionManager();
        QueryStateMachine stateMachine = TaskTestUtils.createQueryStateMachine(sqlString, session, false, tm, this.executorService, this.metadataManager);
        new DropFunctionTask(parser).execute(statement, tm, (Metadata)this.metadataManager, (AccessControl)new AllowAllAccessControl(), stateMachine, Collections.emptyList());
        return stateMachine.getRemovedSessionFunctions();
    }
}

