/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.airlift.configuration.testing.ConfigAssertions;
import com.facebook.presto.execution.scheduler.NodeSchedulerConfig;
import com.facebook.presto.execution.scheduler.NodeSelectionHashStrategy;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.testng.annotations.Test;

public class TestNodeSchedulerConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((NodeSchedulerConfig)ConfigAssertions.recordDefaults(NodeSchedulerConfig.class)).setNetworkTopology("legacy").setMinCandidates(10).setMaxSplitsPerNode(100).setMaxPendingSplitsPerTask(10).setMaxUnacknowledgedSplitsPerTask(500).setIncludeCoordinator(true).setNodeSelectionHashStrategy(NodeSelectionHashStrategy.MODULAR_HASHING).setMinVirtualNodeCount(1000).setResourceAwareSchedulingStrategy(NodeSchedulerConfig.ResourceAwareSchedulingStrategy.RANDOM));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"node-scheduler.network-topology", (Object)"flat").put((Object)"node-scheduler.min-candidates", (Object)"11").put((Object)"node-scheduler.include-coordinator", (Object)"false").put((Object)"node-scheduler.max-pending-splits-per-task", (Object)"11").put((Object)"node-scheduler.max-unacknowledged-splits-per-task", (Object)"501").put((Object)"node-scheduler.max-splits-per-node", (Object)"101").put((Object)"node-scheduler.node-selection-hash-strategy", (Object)"CONSISTENT_HASHING").put((Object)"node-scheduler.consistent-hashing-min-virtual-node-count", (Object)"2000").put((Object)"experimental.resource-aware-scheduling-strategy", (Object)"TTL").build();
        NodeSchedulerConfig expected = new NodeSchedulerConfig().setNetworkTopology("flat").setIncludeCoordinator(false).setMaxSplitsPerNode(101).setMaxPendingSplitsPerTask(11).setMaxUnacknowledgedSplitsPerTask(501).setMinCandidates(11).setNodeSelectionHashStrategy(NodeSelectionHashStrategy.CONSISTENT_HASHING).setMinVirtualNodeCount(2000).setResourceAwareSchedulingStrategy(NodeSchedulerConfig.ResourceAwareSchedulingStrategy.TTL);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

