/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.execution.PrepareTask;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.execution.TaskTestUtils;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.security.AccessControl;
import com.facebook.presto.spi.security.AllowAllAccessControl;
import com.facebook.presto.sql.QueryUtil;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.tree.AllColumns;
import com.facebook.presto.sql.tree.Execute;
import com.facebook.presto.sql.tree.Prepare;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.Relation;
import com.facebook.presto.sql.tree.Select;
import com.facebook.presto.sql.tree.SelectItem;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.transaction.InMemoryTransactionManager;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

public class TestPrepareTask {
    private final MetadataManager metadata = MetadataManager.createTestMetadataManager();
    private final ExecutorService executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test-%s"));

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.executor.shutdownNow();
    }

    @Test
    public void testPrepare() {
        Query query = QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"foo")));
        String sqlString = "PREPARE my_query FROM SELECT * FROM foo";
        Map<String, String> statements = this.executePrepare("my_query", (Statement)query, sqlString, SessionTestUtils.TEST_SESSION);
        Assert.assertEquals(statements, (Map)ImmutableMap.of((Object)"my_query", (Object)"SELECT *\nFROM\n  foo\n"));
    }

    @Test
    public void testPrepareNameExists() {
        Session session = TestingSession.testSessionBuilder().addPreparedStatement("my_query", "SELECT bar, baz from foo").build();
        Query query = QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"foo")));
        String sqlString = "PREPARE my_query FROM SELECT * FROM foo";
        Map<String, String> statements = this.executePrepare("my_query", (Statement)query, sqlString, session);
        Assert.assertEquals(statements, (Map)ImmutableMap.of((Object)"my_query", (Object)"SELECT *\nFROM\n  foo\n"));
    }

    @Test
    public void testPrepareInvalidStatement() {
        Execute statement = new Execute(QueryUtil.identifier((String)"foo"), Collections.emptyList());
        String sqlString = "PREPARE my_query FROM EXECUTE foo";
        try {
            this.executePrepare("my_query", (Statement)statement, sqlString, SessionTestUtils.TEST_SESSION);
            Assert.fail((String)"expected exception");
        }
        catch (PrestoException e) {
            Assert.assertEquals((Object)e.getErrorCode(), (Object)StandardErrorCode.NOT_SUPPORTED.toErrorCode());
            Assert.assertEquals((String)e.getMessage(), (String)"Invalid statement type for prepared statement: EXECUTE");
        }
    }

    private Map<String, String> executePrepare(String statementName, Statement statement, String sqlString, Session session) {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        QueryStateMachine stateMachine = TaskTestUtils.createQueryStateMachine(sqlString, session, false, transactionManager, this.executor, this.metadata);
        Prepare prepare = new Prepare(QueryUtil.identifier((String)statementName), statement);
        PrepareTask prepareTask = new PrepareTask(new SqlParser());
        prepareTask.execute(prepare, transactionManager, (Metadata)this.metadata, (AccessControl)new AllowAllAccessControl(), stateMachine, Collections.emptyList());
        return stateMachine.getAddedPreparedStatements();
    }
}

