/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.execution.QueryLimit;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.concurrent.TimeUnit;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestQueryLimit {
    private static final QueryLimit<Duration> QUERY_LIMIT_DURATION = QueryLimit.createDurationLimit((Duration)new Duration(1.0, TimeUnit.HOURS), (QueryLimit.Source)QueryLimit.Source.SYSTEM);
    private static final QueryLimit<DataSize> QUERY_LIMIT_DATA_SIZE = QueryLimit.createDataSizeLimit((DataSize)new DataSize(1.0, DataSize.Unit.MEGABYTE), (QueryLimit.Source)QueryLimit.Source.RESOURCE_GROUP);

    @Test
    public void testGetLimit() {
        com.facebook.presto.testing.assertions.Assert.assertEquals((Object)QUERY_LIMIT_DURATION.getLimit(), (Object)new Duration(1.0, TimeUnit.HOURS));
        com.facebook.presto.testing.assertions.Assert.assertEquals((Object)QUERY_LIMIT_DATA_SIZE.getLimit(), (Object)new DataSize(1.0, DataSize.Unit.MEGABYTE));
    }

    @Test
    public void testGetSource() {
        com.facebook.presto.testing.assertions.Assert.assertEquals((Object)QUERY_LIMIT_DATA_SIZE.getLimitSource(), (Object)QueryLimit.Source.RESOURCE_GROUP);
        com.facebook.presto.testing.assertions.Assert.assertEquals((Object)QUERY_LIMIT_DURATION.getLimitSource(), (Object)QueryLimit.Source.SYSTEM);
        com.facebook.presto.testing.assertions.Assert.assertEquals((Object)QueryLimit.createDurationLimit((Duration)new Duration(1.0, TimeUnit.HOURS), (QueryLimit.Source)QueryLimit.Source.QUERY).getLimitSource(), (Object)QueryLimit.Source.QUERY);
    }

    @Test
    public void testGetMinimum() {
        QueryLimit longLimit = QueryLimit.createDurationLimit((Duration)new Duration(2.0, TimeUnit.HOURS), (QueryLimit.Source)QueryLimit.Source.SYSTEM);
        QueryLimit shortLimit = QueryLimit.createDurationLimit((Duration)new Duration(1.0, TimeUnit.MINUTES), (QueryLimit.Source)QueryLimit.Source.RESOURCE_GROUP);
        com.facebook.presto.testing.assertions.Assert.assertEquals((Object)QueryLimit.getMinimum(QUERY_LIMIT_DURATION, (QueryLimit[])new QueryLimit[]{longLimit, shortLimit}), (Object)shortLimit);
        QueryLimit largeLimit = QueryLimit.createDataSizeLimit((DataSize)new DataSize(2.0, DataSize.Unit.MEGABYTE), (QueryLimit.Source)QueryLimit.Source.QUERY);
        QueryLimit smallLimit = QueryLimit.createDataSizeLimit((DataSize)new DataSize(1.0, DataSize.Unit.BYTE), (QueryLimit.Source)QueryLimit.Source.RESOURCE_GROUP);
        com.facebook.presto.testing.assertions.Assert.assertEquals((Object)QueryLimit.getMinimum((QueryLimit)smallLimit, (QueryLimit[])new QueryLimit[]{QUERY_LIMIT_DATA_SIZE, largeLimit}), (Object)smallLimit);
        com.facebook.presto.testing.assertions.Assert.assertEquals((Object)QueryLimit.getMinimum(null, (QueryLimit[])new QueryLimit[]{QUERY_LIMIT_DATA_SIZE, largeLimit}), QUERY_LIMIT_DATA_SIZE);
        com.facebook.presto.testing.assertions.Assert.assertEquals((Object)QueryLimit.getMinimum(null, (QueryLimit[])new QueryLimit[]{largeLimit, null, null, QUERY_LIMIT_DATA_SIZE}), QUERY_LIMIT_DATA_SIZE);
        com.facebook.presto.testing.assertions.Assert.assertEquals((Object)QueryLimit.getMinimum((QueryLimit)smallLimit, (QueryLimit[])new QueryLimit[]{null, null, null}), (Object)smallLimit);
        Assert.assertThrows(IllegalArgumentException.class, () -> QueryLimit.getMinimum(null, (QueryLimit[])new QueryLimit[0]));
        Assert.assertThrows(IllegalArgumentException.class, () -> QueryLimit.getMinimum(null, (QueryLimit[])new QueryLimit[]{null, null}));
    }
}

