/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.airlift.configuration.testing.ConfigAssertions;
import com.facebook.presto.execution.QueryManagerConfig;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.Test;

public class TestQueryManagerConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((QueryManagerConfig)ConfigAssertions.recordDefaults(QueryManagerConfig.class)).setMinQueryExpireAge(new Duration(15.0, TimeUnit.MINUTES)).setMaxQueryHistory(100).setMaxQueryLength(1000000).setMaxStageCount(100).setStageCountWarningThreshold(50).setMaxTotalRunningTaskCountToKillQuery(Integer.MAX_VALUE).setMaxQueryRunningTaskCount(Integer.MAX_VALUE).setMaxTotalRunningTaskCountToNotExecuteNewQuery(Integer.MAX_VALUE).setConcurrencyThresholdToEnableResourceGroupRefresh(1.0).setResourceGroupRunTimeInfoRefreshInterval(new Duration(100.0, TimeUnit.MILLISECONDS)).setClientTimeout(new Duration(5.0, TimeUnit.MINUTES)).setScheduleSplitBatchSize(1000).setMinScheduleSplitBatchSize(100).setMaxConcurrentQueries(1000).setMaxQueuedQueries(5000).setHashPartitionCount(100).setPartitioningProviderCatalog("system").setCtePartitioningProviderCatalog("system").setExchangeMaterializationStrategy(QueryManagerConfig.ExchangeMaterializationStrategy.NONE).setQueryManagerExecutorPoolSize(5).setRemoteTaskMinErrorDuration(new Duration(5.0, TimeUnit.MINUTES)).setRemoteTaskMaxErrorDuration(new Duration(5.0, TimeUnit.MINUTES)).setRemoteTaskMaxCallbackThreads(1000).setQueryExecutionPolicy("all-at-once").setQueryMaxRunTime(new Duration(100.0, TimeUnit.DAYS)).setQueryMaxExecutionTime(new Duration(100.0, TimeUnit.DAYS)).setQueryMaxCpuTime(new Duration(1.0E9, TimeUnit.DAYS)).setQueryMaxScanRawInputBytes(new DataSize(1000.0, DataSize.Unit.PETABYTE)).setQueryMaxOutputPositions(Long.MAX_VALUE).setQueryMaxOutputSize(new DataSize(1000.0, DataSize.Unit.PETABYTE)).setRequiredWorkers(1).setRequiredWorkersMaxWait(new Duration(5.0, TimeUnit.MINUTES)).setRequiredCoordinators(1).setRequiredCoordinatorsMaxWait(new Duration(5.0, TimeUnit.MINUTES)).setRequiredResourceManagers(1).setQuerySubmissionMaxThreads(Runtime.getRuntime().availableProcessors() * 2).setUseStreamingExchangeForMarkDistinct(false).setPerQueryRetryLimit(0).setPerQueryRetryMaxExecutionTime(new Duration(5.0, TimeUnit.MINUTES)).setGlobalQueryRetryFailureLimit(150).setGlobalQueryRetryFailureWindow(new Duration(5.0, TimeUnit.MINUTES)).setRateLimiterBucketMaxSize(100L).setCteHashPartitionCount(100).setRateLimiterCacheLimit(1000).setRateLimiterCacheWindowMinutes(5).setEnableWorkerIsolation(false));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"query.client.timeout", (Object)"10s").put((Object)"query.min-expire-age", (Object)"30s").put((Object)"query.max-history", (Object)"10").put((Object)"query.max-length", (Object)"10000").put((Object)"query.max-stage-count", (Object)"12345").put((Object)"query.stage-count-warning-threshold", (Object)"12300").put((Object)"max-total-running-task-count-to-kill-query", (Object)"60000").put((Object)"max-query-running-task-count", (Object)"10000").put((Object)"experimental.max-total-running-task-count-to-not-execute-new-query", (Object)"50000").put((Object)"concurrency-threshold-to-enable-resource-group-refresh", (Object)"2").put((Object)"resource-group-runtimeinfo-refresh-interval", (Object)"10ms").put((Object)"query.schedule-split-batch-size", (Object)"99").put((Object)"query.min-schedule-split-batch-size", (Object)"9").put((Object)"query.max-concurrent-queries", (Object)"10").put((Object)"query.max-queued-queries", (Object)"15").put((Object)"query.hash-partition-count", (Object)"16").put((Object)"query.partitioning-provider-catalog", (Object)"hive").put((Object)"query.exchange-materialization-strategy", (Object)"ALL").put((Object)"query.manager-executor-pool-size", (Object)"11").put((Object)"query.remote-task.min-error-duration", (Object)"30s").put((Object)"query.remote-task.max-error-duration", (Object)"60s").put((Object)"query.remote-task.max-callback-threads", (Object)"10").put((Object)"query.execution-policy", (Object)"phased").put((Object)"query.max-run-time", (Object)"2h").put((Object)"query.max-execution-time", (Object)"3h").put((Object)"query.max-cpu-time", (Object)"2d").put((Object)"query.max-scan-raw-input-bytes", (Object)"1MB").put((Object)"query.max-output-positions", (Object)"259").put((Object)"query.max-output-size", (Object)"100MB").put((Object)"query.use-streaming-exchange-for-mark-distinct", (Object)"true").put((Object)"query-manager.required-workers", (Object)"333").put((Object)"query-manager.required-workers-max-wait", (Object)"33m").put((Object)"query-manager.experimental.required-coordinators", (Object)"999").put((Object)"query-manager.experimental.required-coordinators-max-wait", (Object)"99m").put((Object)"query-manager.experimental.required-resource-managers", (Object)"9").put((Object)"query-manager.experimental.query-submission-max-threads", (Object)"5").put((Object)"per-query-retry-limit", (Object)"10").put((Object)"per-query-retry-max-execution-time", (Object)"1h").put((Object)"global-query-retry-failure-limit", (Object)"200").put((Object)"global-query-retry-failure-window", (Object)"1h").put((Object)"query-manager.rate-limiter-bucket-max-size", (Object)"200").put((Object)"query-manager.rate-limiter-cache-limit", (Object)"10000").put((Object)"query-manager.rate-limiter-cache-window-minutes", (Object)"60").put((Object)"query.cte-hash-partition-count", (Object)"128").put((Object)"query.cte-partitioning-provider-catalog", (Object)"hive").put((Object)"query-manager.enable-worker-isolation", (Object)"true").build();
        QueryManagerConfig expected = new QueryManagerConfig().setMinQueryExpireAge(new Duration(30.0, TimeUnit.SECONDS)).setMaxQueryHistory(10).setMaxQueryLength(10000).setMaxStageCount(12345).setStageCountWarningThreshold(12300).setMaxTotalRunningTaskCountToKillQuery(60000).setMaxQueryRunningTaskCount(10000).setMaxTotalRunningTaskCountToNotExecuteNewQuery(50000).setConcurrencyThresholdToEnableResourceGroupRefresh(2.0).setResourceGroupRunTimeInfoRefreshInterval(new Duration(10.0, TimeUnit.MILLISECONDS)).setClientTimeout(new Duration(10.0, TimeUnit.SECONDS)).setScheduleSplitBatchSize(99).setMinScheduleSplitBatchSize(9).setMaxConcurrentQueries(10).setMaxQueuedQueries(15).setHashPartitionCount(16).setPartitioningProviderCatalog("hive").setCtePartitioningProviderCatalog("hive").setExchangeMaterializationStrategy(QueryManagerConfig.ExchangeMaterializationStrategy.ALL).setQueryManagerExecutorPoolSize(11).setRemoteTaskMinErrorDuration(new Duration(60.0, TimeUnit.SECONDS)).setRemoteTaskMaxErrorDuration(new Duration(60.0, TimeUnit.SECONDS)).setRemoteTaskMaxCallbackThreads(10).setQueryExecutionPolicy("phased").setQueryMaxRunTime(new Duration(2.0, TimeUnit.HOURS)).setQueryMaxExecutionTime(new Duration(3.0, TimeUnit.HOURS)).setQueryMaxCpuTime(new Duration(2.0, TimeUnit.DAYS)).setQueryMaxScanRawInputBytes(new DataSize(1.0, DataSize.Unit.MEGABYTE)).setQueryMaxOutputPositions(259L).setQueryMaxOutputSize(new DataSize(100.0, DataSize.Unit.MEGABYTE)).setRequiredWorkers(333).setRequiredWorkersMaxWait(new Duration(33.0, TimeUnit.MINUTES)).setRequiredCoordinators(999).setRequiredCoordinatorsMaxWait(new Duration(99.0, TimeUnit.MINUTES)).setRequiredResourceManagers(9).setQuerySubmissionMaxThreads(5).setUseStreamingExchangeForMarkDistinct(true).setPerQueryRetryLimit(10).setPerQueryRetryMaxExecutionTime(new Duration(1.0, TimeUnit.HOURS)).setGlobalQueryRetryFailureLimit(200).setGlobalQueryRetryFailureWindow(new Duration(1.0, TimeUnit.HOURS)).setRateLimiterBucketMaxSize(200L).setRateLimiterCacheLimit(10000).setRateLimiterCacheWindowMinutes(60).setCteHashPartitionCount(128).setCtePartitioningProviderCatalog("hive").setEnableWorkerIsolation(true);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

