/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.execution.SplitConcurrencyController;
import io.airlift.units.Duration;
import java.util.concurrent.TimeUnit;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestSplitConcurrencyController {
    @Test
    public void testRampup() {
        SplitConcurrencyController controller = new SplitConcurrencyController(1, new Duration(1.0, TimeUnit.SECONDS));
        for (int i = 0; i < 10; ++i) {
            controller.update(TimeUnit.SECONDS.toNanos(2L), 0.0, i + 1);
            Assert.assertEquals((int)controller.getTargetConcurrency(), (int)(i + 2));
        }
    }

    @Test
    public void testRampdown() {
        SplitConcurrencyController controller = new SplitConcurrencyController(10, new Duration(1.0, TimeUnit.SECONDS));
        for (int i = 0; i < 9; ++i) {
            controller.update(TimeUnit.SECONDS.toNanos(2L), 1.0, 10 - i);
            controller.splitFinished(TimeUnit.SECONDS.toNanos(30L), 1.0, 10 - i);
            Assert.assertEquals((int)controller.getTargetConcurrency(), (int)(10 - i - 1));
        }
    }

    @Test
    public void testRapidAdjustForQuickSplits() {
        int i;
        SplitConcurrencyController controller = new SplitConcurrencyController(10, new Duration(1.0, TimeUnit.SECONDS));
        for (i = 0; i < 9; ++i) {
            controller.update(TimeUnit.MILLISECONDS.toNanos(200L), 1.0, 10 - i);
            controller.splitFinished(TimeUnit.MILLISECONDS.toNanos(100L), 1.0, 10 - i);
            Assert.assertEquals((int)controller.getTargetConcurrency(), (int)(10 - i - 1));
        }
        controller.update(TimeUnit.SECONDS.toNanos(30L), 0.0, 1);
        for (i = 0; i < 10; ++i) {
            controller.update(TimeUnit.SECONDS.toNanos(200L), 0.0, i + 1);
            controller.splitFinished(TimeUnit.MILLISECONDS.toNanos(100L), 0.0, i + 1);
            Assert.assertEquals((int)controller.getTargetConcurrency(), (int)(i + 2));
        }
    }
}

