/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.airlift.concurrent.MoreFutures;
import com.facebook.airlift.concurrent.Threads;
import com.facebook.presto.execution.StateMachine;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Collection;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

public class TestStateMachine {
    private final ExecutorService executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test-%s"));

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.executor.shutdownNow();
    }

    @Test
    public void testNullState() throws Exception {
        try {
            new StateMachine("test", (Executor)this.executor, null);
            Assert.fail((String)"expected a NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        StateMachine stateMachine = new StateMachine("test", (Executor)this.executor, (Object)State.BREAKFAST);
        TestStateMachine.assertNoStateChange((StateMachine<State>)stateMachine, () -> {
            try {
                stateMachine.set(null);
                Assert.fail((String)"expected a NullPointerException");
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        });
        TestStateMachine.assertNoStateChange((StateMachine<State>)stateMachine, () -> {
            try {
                stateMachine.compareAndSet((Object)State.BREAKFAST, null);
                Assert.fail((String)"expected a NullPointerException");
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        });
        TestStateMachine.assertNoStateChange((StateMachine<State>)stateMachine, () -> {
            try {
                stateMachine.compareAndSet((Object)State.LUNCH, null);
                Assert.fail((String)"expected a NullPointerException");
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        });
        TestStateMachine.assertNoStateChange((StateMachine<State>)stateMachine, () -> {
            try {
                stateMachine.setIf(null, currentState -> true);
                Assert.fail((String)"expected a NullPointerException");
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        });
        TestStateMachine.assertNoStateChange((StateMachine<State>)stateMachine, () -> {
            try {
                stateMachine.setIf(null, currentState -> false);
                Assert.fail((String)"expected a NullPointerException");
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        });
    }

    @Test
    public void testSet() throws Exception {
        StateMachine stateMachine = new StateMachine("test", (Executor)this.executor, (Object)State.BREAKFAST, (Iterable)ImmutableSet.of((Object)((Object)State.DINNER)));
        Assert.assertEquals((Object)stateMachine.get(), (Object)((Object)State.BREAKFAST));
        TestStateMachine.assertNoStateChange((StateMachine<State>)stateMachine, () -> Assert.assertEquals((Object)stateMachine.set((Object)State.BREAKFAST), (Object)((Object)State.BREAKFAST)));
        TestStateMachine.assertStateChange((StateMachine<State>)stateMachine, () -> Assert.assertEquals((Object)stateMachine.set((Object)State.LUNCH), (Object)((Object)State.BREAKFAST)), State.LUNCH);
        TestStateMachine.assertStateChange((StateMachine<State>)stateMachine, () -> Assert.assertEquals((Object)stateMachine.set((Object)State.BREAKFAST), (Object)((Object)State.LUNCH)), State.BREAKFAST);
        TestStateMachine.assertStateChange((StateMachine<State>)stateMachine, () -> Assert.assertEquals((Object)stateMachine.set((Object)State.DINNER), (Object)((Object)State.BREAKFAST)), State.DINNER);
        TestStateMachine.assertNoStateChange((StateMachine<State>)stateMachine, () -> {
            try {
                stateMachine.set((Object)State.LUNCH);
                Assert.fail((String)"expected IllegalStateException");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        });
        TestStateMachine.assertNoStateChange((StateMachine<State>)stateMachine, () -> {
            State cfr_ignored_0 = (State)((Object)((Object)stateMachine.set((Object)State.DINNER)));
        });
    }

    @Test
    public void testCompareAndSet() throws Exception {
        StateMachine stateMachine = new StateMachine("test", (Executor)this.executor, (Object)State.BREAKFAST, (Iterable)ImmutableSet.of((Object)((Object)State.DINNER)));
        Assert.assertEquals((Object)stateMachine.get(), (Object)((Object)State.BREAKFAST));
        TestStateMachine.assertNoStateChange((StateMachine<State>)stateMachine, () -> stateMachine.compareAndSet((Object)State.DINNER, (Object)State.LUNCH));
        TestStateMachine.assertStateChange((StateMachine<State>)stateMachine, () -> stateMachine.compareAndSet((Object)State.BREAKFAST, (Object)State.LUNCH), State.LUNCH);
        TestStateMachine.assertNoStateChange((StateMachine<State>)stateMachine, () -> stateMachine.compareAndSet((Object)State.BREAKFAST, (Object)State.LUNCH));
        TestStateMachine.assertNoStateChange((StateMachine<State>)stateMachine, () -> stateMachine.compareAndSet((Object)State.LUNCH, (Object)State.LUNCH));
        TestStateMachine.assertStateChange((StateMachine<State>)stateMachine, () -> stateMachine.compareAndSet((Object)State.LUNCH, (Object)State.DINNER), State.DINNER);
        TestStateMachine.assertNoStateChange((StateMachine<State>)stateMachine, () -> {
            try {
                stateMachine.compareAndSet((Object)State.DINNER, (Object)State.LUNCH);
                Assert.fail((String)"expected IllegalStateException");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        });
        TestStateMachine.assertNoStateChange((StateMachine<State>)stateMachine, () -> stateMachine.compareAndSet((Object)State.DINNER, (Object)State.DINNER));
    }

    @Test
    public void testSetIf() throws Exception {
        StateMachine stateMachine = new StateMachine("test", (Executor)this.executor, (Object)State.BREAKFAST, (Iterable)ImmutableSet.of((Object)((Object)State.DINNER)));
        Assert.assertEquals((Object)stateMachine.get(), (Object)((Object)State.BREAKFAST));
        TestStateMachine.assertNoStateChange((StateMachine<State>)stateMachine, () -> Assert.assertFalse((boolean)stateMachine.setIf((Object)State.LUNCH, currentState -> {
            Assert.assertEquals((Object)currentState, (Object)((Object)State.BREAKFAST));
            return false;
        })));
        TestStateMachine.assertStateChange((StateMachine<State>)stateMachine, () -> Assert.assertTrue((boolean)stateMachine.setIf((Object)State.LUNCH, currentState -> {
            Assert.assertEquals((Object)currentState, (Object)((Object)State.BREAKFAST));
            return true;
        })), State.LUNCH);
        TestStateMachine.assertNoStateChange((StateMachine<State>)stateMachine, () -> Assert.assertFalse((boolean)stateMachine.setIf((Object)State.LUNCH, currentState -> {
            Assert.assertEquals((Object)currentState, (Object)((Object)State.LUNCH));
            return false;
        })));
        TestStateMachine.assertNoStateChange((StateMachine<State>)stateMachine, () -> Assert.assertFalse((boolean)stateMachine.setIf((Object)State.LUNCH, currentState -> {
            Assert.assertEquals((Object)currentState, (Object)((Object)State.LUNCH));
            return true;
        })));
        TestStateMachine.assertStateChange((StateMachine<State>)stateMachine, () -> stateMachine.setIf((Object)State.DINNER, currentState -> true), State.DINNER);
        TestStateMachine.assertNoStateChange((StateMachine<State>)stateMachine, () -> {
            try {
                stateMachine.setIf((Object)State.LUNCH, currentState -> true);
                Assert.fail((String)"expected IllegalStateException");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        });
        TestStateMachine.assertNoStateChange((StateMachine<State>)stateMachine, () -> stateMachine.setIf((Object)State.LUNCH, currentState -> false));
        TestStateMachine.assertNoStateChange((StateMachine<State>)stateMachine, () -> stateMachine.setIf((Object)State.DINNER, currentState -> true));
    }

    private static void assertStateChange(StateMachine<State> stateMachine, StateChanger stateChange, State expectedState) throws Exception {
        State initialState = (State)((Object)stateMachine.get());
        ListenableFuture futureChange = stateMachine.getStateChange((Object)initialState);
        SettableFuture<State> listenerChange = TestStateMachine.addTestListener(stateMachine);
        stateChange.run();
        Assert.assertEquals((Object)stateMachine.get(), (Object)((Object)expectedState));
        Assert.assertEquals((Object)futureChange.get(10L, TimeUnit.SECONDS), (Object)((Object)expectedState));
        Assert.assertEquals((Object)listenerChange.get(10L, TimeUnit.SECONDS), (Object)((Object)expectedState));
        boolean isTerminalState = stateMachine.isTerminalState((Object)expectedState);
        if (isTerminalState) {
            Assert.assertEquals((Collection)stateMachine.getStateChangeListeners(), (Collection)ImmutableSet.of());
        }
    }

    private static void assertNoStateChange(StateMachine<State> stateMachine, StateChanger stateChange) {
        State initialState = (State)((Object)stateMachine.get());
        ListenableFuture futureChange = stateMachine.getStateChange((Object)initialState);
        SettableFuture<State> listenerChange = TestStateMachine.addTestListener(stateMachine);
        boolean isTerminalState = stateMachine.isTerminalState((Object)initialState);
        if (isTerminalState) {
            Assert.assertEquals((Collection)stateMachine.getStateChangeListeners(), (Collection)ImmutableSet.of());
        }
        stateChange.run();
        Assert.assertEquals((Object)stateMachine.get(), (Object)((Object)initialState));
        Assert.assertEquals((boolean)futureChange.isDone(), (boolean)isTerminalState);
        futureChange.cancel(true);
        Assert.assertFalse((boolean)listenerChange.isDone());
        listenerChange.cancel(true);
    }

    private static SettableFuture<State> addTestListener(StateMachine<State> stateMachine) {
        State initialState = (State)((Object)stateMachine.get());
        SettableFuture initialStateNotified = SettableFuture.create();
        SettableFuture stateChanged = SettableFuture.create();
        Thread addingThread = Thread.currentThread();
        stateMachine.addStateChangeListener(newState -> {
            Thread callbackThread = Thread.currentThread();
            if (callbackThread == addingThread) {
                stateChanged.setException((Throwable)((Object)new AssertionError((Object)"Listener was not called back on a different thread")));
                return;
            }
            if (newState == initialState) {
                initialStateNotified.set((Object)true);
            } else {
                stateChanged.set((Object)newState);
            }
        });
        Assert.assertTrue((boolean)MoreFutures.tryGetFutureValue((Future)initialStateNotified, (int)10, (TimeUnit)TimeUnit.SECONDS).isPresent(), (String)"Initial state notification not fired");
        return stateChanged;
    }

    private static interface StateChanger {
        public void run();
    }

    private static enum State {
        BREAKFAST,
        LUNCH,
        DINNER;

    }
}

