/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.drift.codec.ThriftCodec;
import com.facebook.drift.codec.ThriftCodecManager;
import com.facebook.drift.codec.internal.ThriftCodecFactory;
import com.facebook.drift.codec.internal.compiler.CompilerThriftCodecFactory;
import com.facebook.drift.codec.internal.reflection.ReflectionThriftCodecFactory;
import com.facebook.drift.protocol.TBinaryProtocol;
import com.facebook.drift.protocol.TMemoryBuffer;
import com.facebook.drift.protocol.TProtocol;
import com.facebook.drift.protocol.TProtocolReader;
import com.facebook.drift.protocol.TProtocolWriter;
import com.facebook.drift.protocol.TTransport;
import com.facebook.drift.transport.netty.codec.Protocol;
import com.facebook.presto.execution.TaskWithConnectorType;
import com.facebook.presto.execution.TestingMetadataUpdateHandleSerde;
import com.facebook.presto.metadata.HandleResolver;
import com.facebook.presto.server.ConnectorMetadataUpdateHandleJsonSerde;
import com.facebook.presto.server.thrift.Any;
import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.ConnectorMetadataUpdateHandle;
import com.facebook.presto.spi.ConnectorTypeSerde;
import com.facebook.presto.testing.TestingHandleResolver;
import com.facebook.presto.testing.TestingMetadataUpdateHandle;
import java.util.function.Function;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestTaskWithConnectorTypeSerde {
    private static final ThriftCodecManager COMPILER_CODEC_MANAGER = new ThriftCodecManager((ThriftCodecFactory)new CompilerThriftCodecFactory(false), new ThriftCodec[0]);
    private static final ThriftCodecManager REFLECTION_CODEC_MANAGER = new ThriftCodecManager((ThriftCodecFactory)new ReflectionThriftCodecFactory(), new ThriftCodec[0]);
    private static final TMemoryBuffer transport = new TMemoryBuffer(102400);
    private static HandleResolver handleResolver;
    private ConnectorMetadataUpdateHandleJsonSerde connectorMetadataUpdateHandleJsonSerde;

    @BeforeMethod
    public void setUp() {
        handleResolver = this.getHandleResolver();
        this.connectorMetadataUpdateHandleJsonSerde = new ConnectorMetadataUpdateHandleJsonSerde();
    }

    @DataProvider
    public Object[][] codecCombinations() {
        return new Object[][]{{COMPILER_CODEC_MANAGER, COMPILER_CODEC_MANAGER}, {COMPILER_CODEC_MANAGER, REFLECTION_CODEC_MANAGER}, {REFLECTION_CODEC_MANAGER, COMPILER_CODEC_MANAGER}, {REFLECTION_CODEC_MANAGER, REFLECTION_CODEC_MANAGER}};
    }

    @Test(dataProvider="codecCombinations")
    public void testRoundTripSerializeBinaryProtocol(ThriftCodecManager readCodecManager, ThriftCodecManager writeCodecManager) throws Exception {
        TaskWithConnectorType taskDummy = this.getRoundTripSerialize(readCodecManager, writeCodecManager, TBinaryProtocol::new);
        this.assertSerde(taskDummy, readCodecManager);
    }

    @Test(dataProvider="codecCombinations")
    public void testRoundTripSerializeTCompactProtocol(ThriftCodecManager readCodecManager, ThriftCodecManager writeCodecManager) throws Exception {
        TaskWithConnectorType taskDummy = this.getRoundTripSerialize(readCodecManager, writeCodecManager, TBinaryProtocol::new);
        this.assertSerde(taskDummy, readCodecManager);
    }

    @Test(dataProvider="codecCombinations")
    public void testRoundTripSerializeTFacebookCompactProtocol(ThriftCodecManager readCodecManager, ThriftCodecManager writeCodecManager) throws Exception {
        TaskWithConnectorType taskDummy = this.getRoundTripSerialize(readCodecManager, writeCodecManager, TBinaryProtocol::new);
        this.assertSerde(taskDummy, readCodecManager);
    }

    @Test
    public void testJsonSerdeRoundTrip() {
        TestingMetadataUpdateHandle metadataUpdateHandle = new TestingMetadataUpdateHandle(200);
        byte[] serialized = this.connectorMetadataUpdateHandleJsonSerde.serialize((ConnectorMetadataUpdateHandle)metadataUpdateHandle);
        TestingMetadataUpdateHandle roundTripMetadataUpdateHandle = (TestingMetadataUpdateHandle)this.connectorMetadataUpdateHandleJsonSerde.deserialize(TestingMetadataUpdateHandle.class, serialized);
        Assert.assertEquals((int)roundTripMetadataUpdateHandle.getValue(), (int)metadataUpdateHandle.getValue());
    }

    private void assertSerde(TaskWithConnectorType taskWithConnectorType, ThriftCodecManager readCodecManager) {
        Assert.assertEquals((int)100, (int)taskWithConnectorType.getValue());
        Any connectorMetadataUpdateHandleAny = taskWithConnectorType.getConnectorMetadataUpdateHandleAny();
        TestingMetadataUpdateHandle connectorMetadataUpdateHandle = (TestingMetadataUpdateHandle)TestTaskWithConnectorTypeSerde.getConnectorSerde(readCodecManager).deserialize(handleResolver.getMetadataUpdateHandleClass(connectorMetadataUpdateHandleAny.getId()), connectorMetadataUpdateHandleAny.getBytes());
        Assert.assertEquals((int)200, (int)connectorMetadataUpdateHandle.getValue());
    }

    private TaskWithConnectorType getRoundTripSerialize(ThriftCodecManager readCodecManager, ThriftCodecManager writeCodecManager, Function<TTransport, TProtocol> protocolFactory) throws Exception {
        TProtocol protocol = protocolFactory.apply((TTransport)transport);
        ThriftCodec writeCodec = writeCodecManager.getCodec(TaskWithConnectorType.class);
        writeCodec.write((Object)this.getTaskDummy(writeCodecManager), (TProtocolWriter)protocol);
        ThriftCodec readCodec = readCodecManager.getCodec(TaskWithConnectorType.class);
        return (TaskWithConnectorType)readCodec.read((TProtocolReader)protocol);
    }

    private TaskWithConnectorType getTaskDummy(ThriftCodecManager thriftCodecManager) {
        TestingMetadataUpdateHandle metadataUpdateHandle = new TestingMetadataUpdateHandle(200);
        byte[] serialized = TestTaskWithConnectorTypeSerde.getConnectorSerde(thriftCodecManager).serialize((Object)metadataUpdateHandle);
        String id = handleResolver.getId((ConnectorMetadataUpdateHandle)metadataUpdateHandle);
        Any any = new Any(id, serialized);
        return new TaskWithConnectorType(100, any);
    }

    private static ConnectorTypeSerde<ConnectorMetadataUpdateHandle> getConnectorSerde(ThriftCodecManager thriftCodecManager) {
        return new TestingMetadataUpdateHandleSerde(thriftCodecManager, Protocol.BINARY, 128);
    }

    private HandleResolver getHandleResolver() {
        HandleResolver handleResolver = new HandleResolver();
        handleResolver.addConnectorName("test", (ConnectorHandleResolver)new TestingHandleResolver());
        return handleResolver;
    }
}

