/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.resourceGroups;

import com.facebook.presto.execution.ManagedQueryExecution;
import com.facebook.presto.execution.MockManagedQueryExecution;
import com.facebook.presto.execution.resourceGroups.InternalResourceGroup;
import com.facebook.presto.metadata.InMemoryNodeManager;
import com.facebook.presto.metadata.InternalNodeManager;
import io.airlift.units.DataSize;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
@Fork(value=1)
@Warmup(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkResourceGroup {
    @Benchmark
    public Object benchmark(BenchmarkData data) {
        data.getRoot().processQueuedQueries();
        return data.getRoot();
    }

    public static void main(String[] args) throws Throwable {
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + BenchmarkResourceGroup.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        @Param(value={"1000", "10000", "100000"})
        private int children = 1000;
        @Param(value={"100", "1000", "10000"})
        private int queries = 100;
        private final ExecutorService executor = Executors.newSingleThreadExecutor();
        private InternalResourceGroup.RootInternalResourceGroup root;

        @Setup
        public void setup() {
            int i;
            this.root = new InternalResourceGroup.RootInternalResourceGroup("root", (group, export) -> {}, (Executor)this.executor, ignored -> Optional.empty(), rg -> false, (InternalNodeManager)new InMemoryNodeManager());
            this.root.setSoftMemoryLimit(new DataSize(1.0, DataSize.Unit.MEGABYTE));
            this.root.setMaxQueuedQueries(this.queries);
            this.root.setHardConcurrencyLimit(this.queries);
            InternalResourceGroup.RootInternalResourceGroup group2 = this.root;
            for (i = 0; i < this.children; ++i) {
                group2 = this.root.getOrCreateSubGroup(String.valueOf(i), true);
                group2.setSoftMemoryLimit(new DataSize(1.0, DataSize.Unit.MEGABYTE));
                group2.setMaxQueuedQueries(this.queries);
                group2.setHardConcurrencyLimit(this.queries);
            }
            for (i = 0; i < this.queries; ++i) {
                group2.run((ManagedQueryExecution)new MockManagedQueryExecution(10L));
            }
        }

        @TearDown
        public void tearDown() {
            this.executor.shutdownNow();
        }

        public InternalResourceGroup.RootInternalResourceGroup getRoot() {
            return this.root;
        }
    }
}

