/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.resourceGroups;

import com.facebook.presto.execution.resourceGroups.FifoQueue;
import com.facebook.presto.execution.resourceGroups.IndexedPriorityQueue;
import com.facebook.presto.execution.resourceGroups.StochasticPriorityQueue;
import com.facebook.presto.execution.resourceGroups.TieredQueue;
import com.facebook.presto.execution.resourceGroups.UpdateablePriorityQueue;
import com.facebook.presto.testing.assertions.Assert;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.testng.annotations.Test;

public class TestUpdateablePriorityQueue {
    @Test
    public void testFifoQueue() {
        Assert.assertEquals(TestUpdateablePriorityQueue.populateAndExtract((UpdateablePriorityQueue<Integer>)new FifoQueue()), (Collection)ImmutableList.of((Object)1, (Object)2, (Object)3));
    }

    @Test
    public void testIndexedPriorityQueue() {
        Assert.assertEquals(TestUpdateablePriorityQueue.populateAndExtract((UpdateablePriorityQueue<Integer>)new IndexedPriorityQueue()), (Collection)ImmutableList.of((Object)3, (Object)2, (Object)1));
    }

    @Test
    public void testStochasticPriorityQueue() {
        org.testng.Assert.assertTrue((TestUpdateablePriorityQueue.populateAndExtract((UpdateablePriorityQueue<Integer>)new StochasticPriorityQueue()).size() == 3 ? 1 : 0) != 0);
    }

    @Test
    public void testTieredQueue() {
        TieredQueue queue = new TieredQueue(FifoQueue::new);
        Assert.assertEquals(TestUpdateablePriorityQueue.populateAndExtract((UpdateablePriorityQueue<Integer>)queue), (Collection)ImmutableList.of((Object)1, (Object)2, (Object)3));
        queue.prioritize((Object)4, 0L);
        queue.prioritize((Object)5, 0L);
        Assert.assertEquals(TestUpdateablePriorityQueue.populateAndExtract((UpdateablePriorityQueue<Integer>)queue), (Collection)ImmutableList.of((Object)4, (Object)5, (Object)1, (Object)2, (Object)3));
    }

    private static List<Integer> populateAndExtract(UpdateablePriorityQueue<Integer> queue) {
        queue.addOrUpdate((Object)1, 1L);
        queue.addOrUpdate((Object)2, 2L);
        queue.addOrUpdate((Object)3, 3L);
        return ImmutableList.copyOf(queue);
    }

    @Test
    public void testIndexedPriorityQueueIterator() {
        IndexedPriorityQueue queue = new IndexedPriorityQueue();
        queue.addOrUpdate((Object)1, 1L);
        queue.addOrUpdate((Object)2, 2L);
        queue.addOrUpdate((Object)3, 3L);
        Iterator iterator = queue.iterator();
        org.testng.Assert.assertTrue((boolean)iterator.hasNext());
        org.testng.Assert.assertThrows(IllegalStateException.class, iterator::remove);
        Assert.assertEquals((Collection)ImmutableList.of((Object)3, (Object)2, (Object)1), (Collection)ImmutableList.copyOf((Iterable)queue));
        org.testng.Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((Object)queue.peek(), (Object)3);
        Assert.assertEquals(iterator.next(), (Object)3);
        org.testng.Assert.assertTrue((boolean)queue.contains((Object)3));
        iterator.remove();
        org.testng.Assert.assertFalse((boolean)queue.remove((Object)3));
        org.testng.Assert.assertFalse((boolean)queue.contains((Object)3));
        org.testng.Assert.assertThrows(IllegalStateException.class, iterator::remove);
        Assert.assertEquals((Collection)ImmutableList.of((Object)2, (Object)1), (Collection)ImmutableList.copyOf((Iterable)queue));
        org.testng.Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((Object)queue.peek(), (Object)2);
        Assert.assertEquals(iterator.next(), (Object)2);
        org.testng.Assert.assertTrue((boolean)queue.contains((Object)2));
        iterator.remove();
        org.testng.Assert.assertFalse((boolean)queue.remove((Object)2));
        org.testng.Assert.assertFalse((boolean)queue.contains((Object)2));
        org.testng.Assert.assertThrows(IllegalStateException.class, iterator::remove);
        Assert.assertEquals((Collection)ImmutableList.of((Object)1), (Collection)ImmutableList.copyOf((Iterable)queue));
        org.testng.Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((Object)queue.peek(), (Object)1);
        Assert.assertEquals(iterator.next(), (Object)1);
        org.testng.Assert.assertTrue((boolean)queue.contains((Object)1));
        iterator.remove();
        org.testng.Assert.assertFalse((boolean)queue.remove((Object)1));
        org.testng.Assert.assertFalse((boolean)queue.contains((Object)1));
        org.testng.Assert.assertThrows(IllegalStateException.class, iterator::remove);
        Assert.assertEquals((Collection)ImmutableList.of(), (Collection)ImmutableList.copyOf((Iterable)queue));
        org.testng.Assert.assertFalse((boolean)iterator.hasNext());
        org.testng.Assert.assertThrows(IllegalStateException.class, iterator::remove);
        org.testng.Assert.assertThrows(NoSuchElementException.class, iterator::next);
    }

    @Test
    public void testConcurrentModificationOnIterator() {
        IndexedPriorityQueue queue = new IndexedPriorityQueue();
        queue.addOrUpdate((Object)1, 1L);
        queue.addOrUpdate((Object)2, 2L);
        queue.addOrUpdate((Object)3, 3L);
        Iterator iterator = queue.iterator();
        org.testng.Assert.assertTrue((boolean)iterator.hasNext());
        org.testng.Assert.assertThrows(IllegalStateException.class, iterator::remove);
        org.testng.Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals(iterator.next(), (Object)3);
        org.testng.Assert.assertTrue((boolean)queue.remove((Object)3));
        org.testng.Assert.assertThrows(ConcurrentModificationException.class, iterator::remove);
        org.testng.Assert.assertFalse((boolean)queue.remove((Object)3));
        org.testng.Assert.assertThrows(ConcurrentModificationException.class, iterator::hasNext);
        Assert.assertEquals((Collection)ImmutableList.of((Object)2, (Object)1), (Collection)ImmutableList.copyOf((Iterable)queue));
        iterator = queue.iterator();
        Assert.assertEquals((Object)queue.poll(), (Object)2);
        org.testng.Assert.assertThrows(ConcurrentModificationException.class, iterator::next);
        iterator = queue.iterator();
        Assert.assertEquals(iterator.next(), (Object)1);
        iterator.remove();
        org.testng.Assert.assertNull((Object)queue.poll());
    }
}

