/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.scheduler;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.presto.client.NodeVersion;
import com.facebook.presto.common.WarningHandlingLevel;
import com.facebook.presto.execution.MockRemoteTaskFactory;
import com.facebook.presto.execution.NodeTaskMap;
import com.facebook.presto.execution.PartialResultQueryManager;
import com.facebook.presto.execution.RemoteTask;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.scheduler.PartialResultQueryTaskTracker;
import com.facebook.presto.execution.warnings.DefaultWarningCollector;
import com.facebook.presto.execution.warnings.WarningCollectorConfig;
import com.facebook.presto.metadata.InternalNode;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.spi.PrestoWarning;
import com.facebook.presto.spi.StandardWarningCode;
import com.facebook.presto.spi.WarningCollector;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

public class TestPartialResultQueryTaskTracker {
    private final ExecutorService executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"stageExecutor-%s"));
    private final ScheduledExecutorService scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)"stageScheduledExecutor-%s"));
    private final PartialResultQueryManager partialResultQueryManager = new PartialResultQueryManager();
    private final WarningCollector warningCollector = new DefaultWarningCollector(new WarningCollectorConfig(), WarningHandlingLevel.NORMAL);
    private final MockRemoteTaskFactory taskFactory = new MockRemoteTaskFactory(this.executor, this.scheduledExecutor);

    @AfterClass(alwaysRun=true)
    public void destroyExecutor() {
        this.executor.shutdownNow();
        this.scheduledExecutor.shutdown();
        this.partialResultQueryManager.stop();
    }

    @Test
    public void testPartialResultQueryTaskTracker() throws Exception {
        PartialResultQueryTaskTracker tracker = new PartialResultQueryTaskTracker(this.partialResultQueryManager, 0.5, 2.0, this.warningCollector);
        InternalNode node1 = new InternalNode(UUID.randomUUID().toString(), URI.create("https://192.0.2.8"), new NodeVersion("1"), false, false, false);
        InternalNode node2 = new InternalNode(UUID.randomUUID().toString(), URI.create("https://192.0.2.9"), new NodeVersion("1"), false, false, false);
        TaskId taskId1 = new TaskId("test1", 1, 0, 1, 0);
        TaskId taskId2 = new TaskId("test2", 2, 0, 1, 0);
        MockRemoteTaskFactory.MockRemoteTask task1 = this.taskFactory.createTableScanTask(taskId1, node1, (List<Split>)ImmutableList.of(), new NodeTaskMap.NodeStatsTracker(delta -> {}, delta -> {}, (age, delta) -> {}));
        MockRemoteTaskFactory.MockRemoteTask task2 = this.taskFactory.createTableScanTask(taskId2, node2, (List<Split>)ImmutableList.of(), new NodeTaskMap.NodeStatsTracker(delta -> {}, delta -> {}, (age, delta) -> {}));
        tracker.trackTask((RemoteTask)task1);
        tracker.trackTask((RemoteTask)task2);
        Assert.assertEquals((double)0.0, (double)tracker.getTaskCompletionRatio());
        tracker.completeTaskScheduling();
        tracker.recordTaskFinish(task1.getTaskInfo());
        Assert.assertEquals((double)0.5, (double)tracker.getTaskCompletionRatio());
        Assert.assertEquals((int)1, (int)this.partialResultQueryManager.getQueueSize());
        Thread.sleep(6000L);
        Assert.assertEquals((int)0, (int)this.partialResultQueryManager.getQueueSize());
        Assert.assertEquals((int)1, (int)this.warningCollector.getWarnings().size());
        PrestoWarning prestoWarning = (PrestoWarning)this.warningCollector.getWarnings().get(0);
        Assert.assertEquals((Object)StandardWarningCode.PARTIAL_RESULT_WARNING.toWarningCode(), (Object)prestoWarning.getWarningCode());
        Assert.assertEquals((String)"Partial results are returned. Only 50.00 percent of the data is read.", (String)prestoWarning.getMessage());
    }
}

