/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.geospatial;

import com.facebook.presto.geospatial.GeoFunctions;
import com.facebook.presto.geospatial.serde.EsriGeometrySerde;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;
import org.testng.Assert;
import org.testng.annotations.Test;

@State(value=Scope.Thread)
@Fork(value=2)
@Warmup(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkEnvelopeIntersection {
    @Benchmark
    public Slice envelopes(BenchmarkData data) {
        return GeoFunctions.stIntersection((Slice)data.envelope, (Slice)data.otherEnvelope);
    }

    @Benchmark
    public Slice geometries(BenchmarkData data) {
        return GeoFunctions.stIntersection((Slice)data.geometry, (Slice)data.otherGeometry);
    }

    @Test
    public void validate() {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        BenchmarkEnvelopeIntersection benchmark = new BenchmarkEnvelopeIntersection();
        Assert.assertEquals((Object)EsriGeometrySerde.deserialize((Slice)benchmark.envelopes(data)), (Object)EsriGeometrySerde.deserialize((Slice)benchmark.geometries(data)));
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + BenchmarkEnvelopeIntersection.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        private Slice envelope;
        private Slice otherEnvelope;
        private Slice geometry;
        private Slice otherGeometry;

        @Setup
        public void setup() {
            this.geometry = GeoFunctions.stGeometryFromText((Slice)Slices.utf8Slice((String)"POLYGON ((0 0, 0 1, 1 1, 1 0, 0 0))"));
            this.otherGeometry = GeoFunctions.stGeometryFromText((Slice)Slices.utf8Slice((String)"POLYGON ((0.5 0.5, 0.5 1.5, 1.5 1.5, 1.5 0.5, 0.5 0.5))"));
            this.envelope = GeoFunctions.stEnvelope((Slice)this.geometry);
            this.otherEnvelope = GeoFunctions.stEnvelope((Slice)this.otherGeometry);
        }
    }
}

