/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.geospatial;

import com.facebook.presto.geospatial.GeoFunctions;
import com.facebook.presto.geospatial.GeometryBenchmarkUtils;
import com.facebook.presto.geospatial.SphericalGeoFunctions;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;
import org.testng.Assert;
import org.testng.annotations.Test;

@State(value=Scope.Thread)
@Fork(value=2)
@Warmup(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkSTArea {
    @Benchmark
    public Object stSphericalArea(BenchmarkData data) {
        return SphericalGeoFunctions.stSphericalArea((Slice)data.geography);
    }

    @Benchmark
    public Object stSphericalArea500k(BenchmarkData data) {
        return SphericalGeoFunctions.stSphericalArea((Slice)data.geography500k);
    }

    @Benchmark
    public Object stArea(BenchmarkData data) {
        return GeoFunctions.stArea((Slice)data.geometry);
    }

    @Benchmark
    public Object stArea500k(BenchmarkData data) {
        return GeoFunctions.stArea((Slice)data.geometry500k);
    }

    public static void main(String[] args) throws IOException, RunnerException {
        BenchmarkSTArea.verify();
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + BenchmarkSTArea.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }

    @Test
    public static void verify() throws IOException {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        BenchmarkSTArea benchmark = new BenchmarkSTArea();
        Assert.assertEquals((double)((Double)benchmark.stSphericalArea(data) / 3.659E8), (double)1.0, (double)0.001);
        Assert.assertEquals((double)((Double)benchmark.stSphericalArea500k(data) / 3.8842273735E10), (double)1.0, (double)0.001);
        Assert.assertEquals((double)((Double)benchmark.stArea(data) / 0.0503309959277), (double)1.0, (double)0.001);
        Assert.assertEquals((double)((Double)benchmark.stArea500k(data) / Math.PI), (double)1.0, (double)0.001);
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        private Slice geometry;
        private Slice geometry500k;
        private Slice geography;
        private Slice geography500k;

        @Setup
        public void setup() throws IOException {
            this.geometry = GeoFunctions.stGeometryFromText((Slice)Slices.utf8Slice((String)GeometryBenchmarkUtils.loadPolygon("large_polygon.txt")));
            this.geometry500k = GeoFunctions.stGeometryFromText((Slice)Slices.utf8Slice((String)GeometryBenchmarkUtils.createCirclePolygon(500000)));
            this.geography = SphericalGeoFunctions.toSphericalGeography((Slice)this.geometry);
            this.geography500k = SphericalGeoFunctions.toSphericalGeography((Slice)this.geometry500k);
        }
    }
}

