/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.geospatial;

import com.facebook.presto.geospatial.GeoFunctions;
import com.facebook.presto.geospatial.GeometryBenchmarkUtils;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;

@State(value=Scope.Thread)
@Fork(value=2)
@Warmup(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkSTBuffer {
    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + BenchmarkSTBuffer.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }

    @Benchmark
    public Object stBufferPoint(BenchmarkData data) {
        return GeoFunctions.stBuffer((Slice)data.point, (double)0.1);
    }

    @Benchmark
    public Object stBufferMultiPointSparse(BenchmarkData data) {
        return GeoFunctions.stBuffer((Slice)data.multiPointSparse, (double)0.1);
    }

    @Benchmark
    public Object stBufferMultiPointDense(BenchmarkData data) {
        return GeoFunctions.stBuffer((Slice)data.multiPointDense, (double)0.1);
    }

    @Benchmark
    public Object stBufferMultiPointReallyDense(BenchmarkData data) {
        return GeoFunctions.stBuffer((Slice)data.multiPointReallyDense, (double)0.1);
    }

    @Benchmark
    public Object stBufferLineStringCircle(BenchmarkData data) {
        return GeoFunctions.stBuffer((Slice)data.lineStringCircle, (double)0.1);
    }

    @Benchmark
    public Object stBufferLineStringDense(BenchmarkData data) {
        return GeoFunctions.stBuffer((Slice)data.lineStringDense, (double)0.1);
    }

    @Benchmark
    public Object stBufferPolygonSimple(BenchmarkData data) {
        return GeoFunctions.stBuffer((Slice)data.polygonSimple, (double)0.1);
    }

    @Benchmark
    public Object stBufferPolygonNormal(BenchmarkData data) {
        return GeoFunctions.stBuffer((Slice)data.polygonNormal, (double)0.1);
    }

    @Benchmark
    public Object stBufferPolygonDense(BenchmarkData data) {
        return GeoFunctions.stBuffer((Slice)data.polygonComplex, (double)0.1);
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        private Slice point;
        private Slice multiPointSparse;
        private Slice multiPointDense;
        private Slice multiPointReallyDense;
        private Slice lineStringCircle;
        private Slice lineStringDense;
        private Slice polygonSimple;
        private Slice polygonNormal;
        private Slice polygonComplex;

        @Setup
        public void setup() throws IOException {
            this.point = GeoFunctions.stPoint((double)0.0, (double)0.0);
            this.multiPointSparse = GeoFunctions.stGeometryFromText((Slice)Slices.utf8Slice((String)("MULTIPOINT " + GeometryBenchmarkUtils.createCoordinateString(GeometryBenchmarkUtils.createRandomCoordinates(50)))));
            this.multiPointDense = GeoFunctions.stGeometryFromText((Slice)Slices.utf8Slice((String)("MULTIPOINT " + GeometryBenchmarkUtils.createCoordinateString(GeometryBenchmarkUtils.createRandomCoordinates(500)))));
            this.multiPointReallyDense = GeoFunctions.stGeometryFromText((Slice)Slices.utf8Slice((String)("MULTIPOINT " + GeometryBenchmarkUtils.createCoordinateString(GeometryBenchmarkUtils.createRandomCoordinates(5000)))));
            this.lineStringCircle = GeoFunctions.stGeometryFromText((Slice)Slices.utf8Slice((String)("LINESTRING " + GeometryBenchmarkUtils.createCoordinateString(GeometryBenchmarkUtils.createCircleCoordinates(1000)))));
            this.lineStringDense = GeoFunctions.stGeometryFromText((Slice)Slices.utf8Slice((String)("LINESTRING " + GeometryBenchmarkUtils.createCoordinateString(GeometryBenchmarkUtils.createAccordionCoordinates(1000)))));
            this.polygonSimple = GeoFunctions.stGeometryFromText((Slice)Slices.utf8Slice((String)GeometryBenchmarkUtils.createCirclePolygon(8)));
            this.polygonNormal = GeoFunctions.stGeometryFromText((Slice)Slices.utf8Slice((String)GeometryBenchmarkUtils.loadPolygon("large_polygon.txt")));
            this.polygonComplex = GeoFunctions.stGeometryFromText((Slice)Slices.utf8Slice((String)GeometryBenchmarkUtils.createCirclePolygon(500000)));
        }
    }
}

