/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.geospatial;

import com.esri.core.geometry.Envelope;
import com.facebook.presto.geospatial.GeoFunctions;
import com.facebook.presto.geospatial.GeometryBenchmarkUtils;
import com.facebook.presto.geospatial.serde.EsriGeometrySerde;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;

@State(value=Scope.Thread)
@Fork(value=3)
@Warmup(iterations=5, time=2)
@Measurement(iterations=5, time=5)
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkSTIntersection {
    @Benchmark
    public Object stIntersectionSimplePolygons(BenchmarkData data) {
        return GeoFunctions.stIntersection((Slice)data.simplePolygon, (Slice)data.simplePolygon);
    }

    @Benchmark
    public Object stIntersectionComplexPolygons(BenchmarkData data) {
        return GeoFunctions.stIntersection((Slice)data.complexPolygon, (Slice)data.complexPolygon);
    }

    @Benchmark
    public Object stIntersectionSimpleComplexPolygons(BenchmarkData data) {
        return GeoFunctions.stIntersection((Slice)data.simplePolygon, (Slice)data.complexPolygon);
    }

    @Benchmark
    public Object stIntersectionSimplePolygonSmallEnvelope(BenchmarkData data) {
        return GeoFunctions.stIntersection((Slice)data.simplePolygon, (Slice)data.smallEnvelope);
    }

    @Benchmark
    public Object stIntersectionSimplePolygonLargeEnvelope(BenchmarkData data) {
        return GeoFunctions.stIntersection((Slice)data.simplePolygon, (Slice)data.largeEnvelope);
    }

    @Benchmark
    public Object stIntersectionComplexPolygonSmallEnvelope(BenchmarkData data) {
        return GeoFunctions.stIntersection((Slice)data.complexPolygon, (Slice)data.smallEnvelope);
    }

    @Benchmark
    public Object stIntersectionComplexPolygonLargeEnvelope(BenchmarkData data) {
        return GeoFunctions.stIntersection((Slice)data.complexPolygon, (Slice)data.largeEnvelope);
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + BenchmarkSTIntersection.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        private Slice simplePolygon;
        private Slice complexPolygon;
        private Slice largeEnvelope;
        private Slice smallEnvelope;

        @Setup
        public void setup() throws IOException {
            this.simplePolygon = GeoFunctions.stGeometryFromText((Slice)Slices.utf8Slice((String)"POLYGON ((16.5 54, 16.5 54.1, 16.51 54.1, 16.8 54, 16.5 54))"));
            this.complexPolygon = GeoFunctions.stGeometryFromText((Slice)Slices.utf8Slice((String)GeometryBenchmarkUtils.loadPolygon("large_polygon.txt")));
            this.largeEnvelope = GeoFunctions.expandEnvelope((Slice)this.complexPolygon, (double)1.0);
            Envelope envelope = EsriGeometrySerde.deserializeEnvelope((Slice)this.complexPolygon);
            double deltaX = envelope.getXMax() - envelope.getXMin();
            double deltaY = envelope.getYMax() - envelope.getYMin();
            this.smallEnvelope = EsriGeometrySerde.serialize((Envelope)new Envelope(envelope.getXMin() + deltaX / 4.0, envelope.getYMin() + deltaY / 4.0, envelope.getXMax() - deltaX / 4.0, envelope.getYMax() - deltaY / 4.0));
        }
    }
}

