/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.geospatial;

import com.facebook.presto.geospatial.GeoFunctions;
import com.facebook.presto.geospatial.GeometryBenchmarkUtils;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;

@State(value=Scope.Thread)
@Fork(value=2)
@Warmup(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkSTXMin {
    @Benchmark
    public double simpleGeometry(BenchmarkData data) {
        return GeoFunctions.stXMin((Slice)data.simpleGeometry);
    }

    @Benchmark
    public double complexGeometry(BenchmarkData data) {
        return GeoFunctions.stXMin((Slice)data.complexGeometry);
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + BenchmarkSTXMin.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        private Slice complexGeometry;
        private Slice simpleGeometry;

        @Setup
        public void setup() throws IOException {
            this.complexGeometry = GeoFunctions.stGeometryFromText((Slice)Slices.utf8Slice((String)GeometryBenchmarkUtils.loadPolygon("large_polygon.txt")));
            this.simpleGeometry = GeoFunctions.stGeometryFromText((Slice)Slices.utf8Slice((String)"POLYGON ((1 1, 4 1, 1 4))"));
        }
    }
}

