/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.geospatial;

import com.esri.core.geometry.ogc.OGCGeometry;
import com.facebook.presto.geospatial.BingTile;
import com.facebook.presto.geospatial.BingTileUtils;
import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestBingTile
extends AbstractTestFunctions {
    @Test
    public void testSerialization() throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        BingTile tile = BingTile.fromCoordinates((int)1, (int)2, (int)3);
        String json = objectMapper.writeValueAsString((Object)tile);
        Assert.assertEquals((String)"{\"x\":1,\"y\":2,\"zoom\":3}", (String)json);
        Assert.assertEquals((Object)tile, (Object)objectMapper.readerFor(BingTile.class).readValue(json));
    }

    @Test
    public void testBingTileEncoding() {
        for (int zoom = 0; zoom <= 23; ++zoom) {
            int maxValue = (1 << zoom) - 1;
            this.testEncodingRoundTrip(0, 0, zoom);
            this.testEncodingRoundTrip(0, maxValue, zoom);
            this.testEncodingRoundTrip(maxValue, 0, zoom);
            this.testEncodingRoundTrip(maxValue, maxValue, zoom);
        }
    }

    private void testEncodingRoundTrip(int x, int y, int zoom) {
        BingTile expected = BingTile.fromCoordinates((int)x, (int)y, (int)zoom);
        BingTile actual = BingTile.decode((long)expected.encode());
        Assert.assertEquals((Object)actual, (Object)expected);
    }

    @Test
    public void testTileXToLongitude() {
        Assert.assertEquals((double)BingTileUtils.tileXToLongitude((int)0, (int)0), (double)-180.0);
        Assert.assertEquals((double)BingTileUtils.tileXToLongitude((int)1, (int)0), (double)180.0);
        Assert.assertEquals((double)BingTileUtils.tileXToLongitude((int)0, (int)1), (double)-180.0);
        Assert.assertEquals((double)BingTileUtils.tileXToLongitude((int)1, (int)1), (double)0.0);
        Assert.assertEquals((double)BingTileUtils.tileXToLongitude((int)2, (int)1), (double)180.0);
        for (int zoom = 2; zoom <= 23; ++zoom) {
            Assert.assertEquals((double)BingTileUtils.tileXToLongitude((int)0, (int)zoom), (double)-180.0);
            Assert.assertEquals((double)BingTileUtils.tileXToLongitude((int)(1 << zoom - 1), (int)zoom), (double)0.0);
            Assert.assertEquals((double)BingTileUtils.tileXToLongitude((int)(1 << zoom), (int)zoom), (double)180.0);
        }
    }

    @Test
    public void testTileYToLatitude() {
        double delta = 1.0E-8;
        Assert.assertEquals((double)BingTileUtils.tileYToLatitude((int)0, (int)0), (double)85.05112878, (double)delta);
        Assert.assertEquals((double)BingTileUtils.tileYToLatitude((int)1, (int)0), (double)-85.05112878, (double)delta);
        Assert.assertEquals((double)BingTileUtils.tileYToLatitude((int)0, (int)1), (double)85.05112878, (double)delta);
        Assert.assertEquals((double)BingTileUtils.tileYToLatitude((int)1, (int)1), (double)0.0);
        Assert.assertEquals((double)BingTileUtils.tileYToLatitude((int)2, (int)1), (double)-85.05112878, (double)delta);
        for (int zoom = 2; zoom <= 23; ++zoom) {
            Assert.assertEquals((double)BingTileUtils.tileYToLatitude((int)0, (int)zoom), (double)85.05112878, (double)delta);
            Assert.assertEquals((double)BingTileUtils.tileYToLatitude((int)(1 << zoom - 1), (int)zoom), (double)0.0);
            Assert.assertEquals((double)BingTileUtils.tileYToLatitude((int)(1 << zoom), (int)zoom), (double)-85.05112878, (double)delta);
        }
    }

    @Test
    public void testFindChildren() {
        Assert.assertEquals(this.toSortedQuadkeys(BingTile.fromQuadKey((String)"").findChildren()), (Collection)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3"));
        Assert.assertEquals(this.toSortedQuadkeys(BingTile.fromQuadKey((String)"0123").findChildren()), (Collection)ImmutableList.of((Object)"01230", (Object)"01231", (Object)"01232", (Object)"01233"));
        Assert.assertEquals(this.toSortedQuadkeys(BingTile.fromQuadKey((String)"").findChildren(2)), (Collection)ImmutableList.of((Object)"00", (Object)"01", (Object)"02", (Object)"03", (Object)"10", (Object)"11", (Object)"12", (Object)"13", (Object)"20", (Object)"21", (Object)"22", (Object)"23", (Object[])new String[]{"30", "31", "32", "33"}));
        Assertions.assertThatThrownBy(() -> BingTile.fromCoordinates((int)0, (int)0, (int)23).findChildren()).hasMessage(String.format("newZoom must be less than or equal to %s: %s", 23, 24));
        Assertions.assertThatThrownBy(() -> BingTile.fromCoordinates((int)0, (int)0, (int)13).findChildren(24)).hasMessage(String.format("newZoom must be less than or equal to %s: %s", 23, 24));
        Assertions.assertThatThrownBy(() -> BingTile.fromCoordinates((int)0, (int)0, (int)13).findChildren(12)).hasMessage(String.format("newZoom must be greater than or equal to current zoom %s: %s", 13, 12));
    }

    private List<String> toSortedQuadkeys(List<BingTile> tiles) {
        return (List)tiles.stream().map(BingTile::toQuadKey).sorted().collect(ImmutableList.toImmutableList());
    }

    @Test
    public void testFindParent() {
        Assert.assertEquals((String)BingTile.fromQuadKey((String)"0123").findParent().toQuadKey(), (String)"012");
        Assert.assertEquals((String)BingTile.fromQuadKey((String)"1").findParent().toQuadKey(), (String)"");
        Assert.assertEquals((String)BingTile.fromQuadKey((String)"0123").findParent(1).toQuadKey(), (String)"0");
        Assert.assertEquals((String)BingTile.fromQuadKey((String)"0123").findParent(4).toQuadKey(), (String)"0123");
        Assertions.assertThatThrownBy(() -> BingTile.fromQuadKey((String)"0123").findParent(5)).hasMessage(String.format("newZoom must be less than or equal to current zoom %s: %s", 4, 5));
        Assertions.assertThatThrownBy(() -> BingTile.fromQuadKey((String)"").findParent()).hasMessage(String.format("newZoom must be greater than or equal to 0: %s", -1));
        Assertions.assertThatThrownBy(() -> BingTile.fromQuadKey((String)"12").findParent(-1)).hasMessage(String.format("newZoom must be greater than or equal to 0: %s", -1));
    }

    @Test
    public void testFindDissolvedTileCovering() {
        this.assertTileCovering("POINT EMPTY", 0, (List<String>)ImmutableList.of());
        this.assertTileCovering("POINT EMPTY", 10, (List<String>)ImmutableList.of());
        this.assertTileCovering("POINT EMPTY", 20, (List<String>)ImmutableList.of());
        this.assertSmallSquareCovering(2);
        this.assertSmallSquareCovering(5);
        this.assertSmallSquareCovering(11);
        this.assertSmallSquareCovering(23);
        this.assertTileCovering("POINT (0 0)", 0, (List<String>)ImmutableList.of((Object)""));
        this.assertTileCovering(String.format("POINT (%s 0)", -180.0), 0, (List<String>)ImmutableList.of((Object)""));
        this.assertTileCovering(String.format("POINT (%s 0)", 180.0), 0, (List<String>)ImmutableList.of((Object)""));
        this.assertTileCovering(String.format("POINT (0 %s)", -85.05112878), 0, (List<String>)ImmutableList.of((Object)""));
        this.assertTileCovering(String.format("POINT (0 %s)", 85.05112878), 0, (List<String>)ImmutableList.of((Object)""));
        this.assertTileCovering(String.format("POINT (%s %s)", -180.0, -85.05112878), 0, (List<String>)ImmutableList.of((Object)""));
        this.assertTileCovering(String.format("POINT (%s %s)", -180.0, 85.05112878), 0, (List<String>)ImmutableList.of((Object)""));
        this.assertTileCovering(String.format("POINT (%s %s)", 180.0, 85.05112878), 0, (List<String>)ImmutableList.of((Object)""));
        this.assertTileCovering(String.format("POINT (%s %s)", 180.0, -85.05112878), 0, (List<String>)ImmutableList.of((Object)""));
        this.assertTileCovering("POINT (0 0)", 1, (List<String>)ImmutableList.of((Object)"3"));
        this.assertTileCovering(String.format("POINT (%s 0)", -180.0), 1, (List<String>)ImmutableList.of((Object)"2"));
        this.assertTileCovering(String.format("POINT (%s 0)", 180.0), 1, (List<String>)ImmutableList.of((Object)"3"));
        this.assertTileCovering(String.format("POINT (0 %s)", -85.05112878), 1, (List<String>)ImmutableList.of((Object)"3"));
        this.assertTileCovering(String.format("POINT (0 %s)", 85.05112878), 1, (List<String>)ImmutableList.of((Object)"1"));
        this.assertTileCovering(String.format("POINT (%s %s)", -180.0, -85.05112878), 1, (List<String>)ImmutableList.of((Object)"2"));
        this.assertTileCovering(String.format("POINT (%s %s)", -180.0, 85.05112878), 1, (List<String>)ImmutableList.of((Object)"0"));
        this.assertTileCovering(String.format("POINT (%s %s)", 180.0, 85.05112878), 1, (List<String>)ImmutableList.of((Object)"1"));
        this.assertTileCovering(String.format("POINT (%s %s)", 180.0, -85.05112878), 1, (List<String>)ImmutableList.of((Object)"3"));
        this.assertTileCovering("LINESTRING (-1 0, -2 0)", 1, (List<String>)ImmutableList.of((Object)"2"));
        this.assertTileCovering("LINESTRING (1 0, 2 0)", 1, (List<String>)ImmutableList.of((Object)"3"));
        this.assertTileCovering("LINESTRING (0 -1, 0 -2)", 1, (List<String>)ImmutableList.of((Object)"3"));
        this.assertTileCovering("LINESTRING (0 1, 0 2)", 1, (List<String>)ImmutableList.of((Object)"1"));
        this.assertTileCovering(String.format("LINESTRING (%s 1, %s 2)", -180.0, -180.0), 1, (List<String>)ImmutableList.of((Object)"0"));
        this.assertTileCovering(String.format("LINESTRING (%s -1, %s -2)", -180.0, -180.0), 1, (List<String>)ImmutableList.of((Object)"2"));
        this.assertTileCovering(String.format("LINESTRING (%s 1, %s 2)", 180.0, 180.0), 1, (List<String>)ImmutableList.of((Object)"1"));
        this.assertTileCovering(String.format("LINESTRING (%s -1, %s -2)", 180.0, 180.0), 1, (List<String>)ImmutableList.of((Object)"3"));
        this.assertTileCovering("POLYGON ((0 0, 0 10, 10 10, 10 0, 0 0))", 6, (List<String>)ImmutableList.of((Object)"12222", (Object)"300000", (Object)"300001"));
        this.assertTileCovering("POLYGON ((0 0, 0 10, 10 10, 0 0))", 6, (List<String>)ImmutableList.of((Object)"122220", (Object)"122222", (Object)"122221", (Object)"300000"));
        this.assertTileCovering("POLYGON ((10 10, -10 10, -20 -15, 10 10))", 3, (List<String>)ImmutableList.of((Object)"033", (Object)"211", (Object)"122"));
        this.assertTileCovering("POLYGON ((10 10, -10 10, -20 -15, 10 10))", 6, (List<String>)ImmutableList.of((Object)"211102", (Object)"211120", (Object)"033321", (Object)"033323", (Object)"211101", (Object)"211103", (Object)"211121", (Object)"03333", (Object)"211110", (Object)"211112", (Object)"211111", (Object)"122220", (Object[])new String[]{"122222", "122221"}));
        this.assertTileCovering("GEOMETRYCOLLECTION (POINT (60 30.12))", 10, (List<String>)ImmutableList.of((Object)"1230301230"));
        this.assertTileCovering("GEOMETRYCOLLECTION (POINT (60 30.12))", 15, (List<String>)ImmutableList.of((Object)"123030123010121"));
        this.assertTileCovering("GEOMETRYCOLLECTION (POLYGON ((10 10, -10 10, -20 -15, 10 10)))", 3, (List<String>)ImmutableList.of((Object)"033", (Object)"211", (Object)"122"));
        this.assertTileCovering("GEOMETRYCOLLECTION (POINT (60 30.12), POLYGON ((10 10, -10 10, -20 -15, 10 10)))", 3, (List<String>)ImmutableList.of((Object)"033", (Object)"211", (Object)"122", (Object)"123"));
        this.assertTileCovering("GEOMETRYCOLLECTION (POINT (60 30.12), LINESTRING (61 31, 61.01 31.01), POLYGON EMPTY)", 15, (List<String>)ImmutableList.of((Object)"123030123010121", (Object)"123030112310200", (Object)"123030112310202", (Object)"123030112310201"));
        this.assertTileCovering("GEOMETRYCOLLECTION (POINT (0.1 0.1), POINT(0.1 -0.1), POINT(-0.1 -0.1), POINT(-0.1 0.1))", 3, (List<String>)ImmutableList.of((Object)"033", (Object)"122", (Object)"211", (Object)"300"));
    }

    private void assertTileCovering(String wkt, int zoom, List<String> quadkeys) {
        OGCGeometry geometry = OGCGeometry.fromText((String)wkt);
        List actual = (List)BingTileUtils.findDissolvedTileCovering((OGCGeometry)geometry, (int)zoom).stream().map(BingTile::toQuadKey).sorted().collect(ImmutableList.toImmutableList());
        ImmutableList expected = ImmutableList.sortedCopyOf(quadkeys);
        Assert.assertEquals((Collection)actual, (Collection)expected, (String)String.format("Actual:%n%s%nExpected:%n%s", actual, expected));
    }

    private void assertSmallSquareCovering(int zoom) {
        int halfway = 1 << zoom - 1;
        this.assertTileCovering("POLYGON ((0.00001 0.00001, 0.00001 -0.00001, -0.00001 -0.00001, -0.00001 0.00001, 0.00001 0.00001))", zoom, Stream.of(BingTile.fromCoordinates((int)halfway, (int)halfway, (int)zoom), BingTile.fromCoordinates((int)halfway, (int)(halfway - 1), (int)zoom), BingTile.fromCoordinates((int)(halfway - 1), (int)halfway, (int)zoom), BingTile.fromCoordinates((int)(halfway - 1), (int)(halfway - 1), (int)zoom)).map(BingTile::toQuadKey).collect(Collectors.toList()));
    }
}

