/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.geospatial;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.geospatial.SphericalGeographyType;
import com.facebook.presto.geospatial.type.GeometryType;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.plan.EquiJoinClause;
import com.facebook.presto.spi.plan.JoinType;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.sql.TestingRowExpressionTranslator;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.assertions.ExpressionMatcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.ExtractSpatialJoins;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.planner.iterative.rule.test.RuleAssert;
import com.facebook.presto.sql.planner.iterative.rule.test.RuleTester;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Map;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestExtractSpatialInnerJoin
extends BaseRuleTest {
    private TestingRowExpressionTranslator sqlToRowExpressionTranslator;

    public TestExtractSpatialInnerJoin() {
        super(new Plugin[0]);
    }

    @BeforeClass
    public void setupTranslator() {
        this.sqlToRowExpressionTranslator = new TestingRowExpressionTranslator(this.tester().getMetadata());
    }

    @Test
    public void testDoesNotFire() {
        this.assertRuleApplication().on(p -> p.filter(this.sqlToRowExpression("ST_Contains(ST_GeometryFromText('POLYGON ((0 0, 0 0, 0 0, 0 0))'), b)", (Map<String, Type>)ImmutableMap.of((Object)"b", (Object)GeometryType.GEOMETRY)), (PlanNode)p.join(JoinType.INNER, (PlanNode)p.values(), (PlanNode)p.values(p.variable("b", (Type)GeometryType.GEOMETRY)), new EquiJoinClause[0]))).doesNotFire();
        this.assertRuleApplication().on(p -> p.filter(this.sqlToRowExpression("ST_Contains(ST_GeometryFromText(wkt), point) OR name_1 != name_2", (Map<String, Type>)ImmutableMap.of((Object)"wkt", (Object)VarcharType.VARCHAR, (Object)"point", (Object)GeometryType.GEOMETRY, (Object)"name_1", (Object)BigintType.BIGINT, (Object)"name_2", (Object)BigintType.BIGINT)), (PlanNode)p.join(JoinType.INNER, (PlanNode)p.values(p.variable("wkt", (Type)VarcharType.VARCHAR), p.variable("name_1")), (PlanNode)p.values(p.variable("point", (Type)GeometryType.GEOMETRY), p.variable("name_2")), new EquiJoinClause[0]))).doesNotFire();
        this.assertRuleApplication().on(p -> p.filter(this.sqlToRowExpression("NOT ST_Contains(ST_GeometryFromText(wkt), point)", (Map<String, Type>)ImmutableMap.of((Object)"wkt", (Object)VarcharType.VARCHAR, (Object)"point", (Object)GeometryType.GEOMETRY, (Object)"name_1", (Object)BigintType.BIGINT, (Object)"name_2", (Object)BigintType.BIGINT)), (PlanNode)p.join(JoinType.INNER, (PlanNode)p.values(p.variable("wkt", (Type)VarcharType.VARCHAR), p.variable("name_1")), (PlanNode)p.values(p.variable("point", (Type)GeometryType.GEOMETRY), p.variable("name_2")), new EquiJoinClause[0]))).doesNotFire();
        this.assertRuleApplication().on(p -> p.filter(this.sqlToRowExpression("ST_Distance(a, b) > 5", (Map<String, Type>)ImmutableMap.of((Object)"a", (Object)GeometryType.GEOMETRY, (Object)"b", (Object)GeometryType.GEOMETRY)), (PlanNode)p.join(JoinType.INNER, (PlanNode)p.values(p.variable("a", (Type)GeometryType.GEOMETRY)), (PlanNode)p.values(p.variable("b", (Type)GeometryType.GEOMETRY)), new EquiJoinClause[0]))).doesNotFire();
    }

    @Test(enabled=false)
    public void testSphericalGeographiesDoesNotFire() {
        this.assertRuleApplication().on(p -> p.filter(this.sqlToRowExpression("ST_Contains(polygon, point)", (Map<String, Type>)ImmutableMap.of((Object)"polygon", (Object)SphericalGeographyType.SPHERICAL_GEOGRAPHY, (Object)"point", (Object)SphericalGeographyType.SPHERICAL_GEOGRAPHY)), (PlanNode)p.join(JoinType.INNER, (PlanNode)p.values(p.variable("polygon", (Type)SphericalGeographyType.SPHERICAL_GEOGRAPHY)), (PlanNode)p.values(p.variable("point", (Type)SphericalGeographyType.SPHERICAL_GEOGRAPHY)), new EquiJoinClause[0]))).doesNotFire();
    }

    @Test
    public void testDistanceQueries() {
        this.testSimpleDistanceQuery("ST_Distance(a, b) <= r", "ST_Distance(a, b) <= r");
        this.testSimpleDistanceQuery("ST_Distance(b, a) <= r", "ST_Distance(b, a) <= r");
        this.testSimpleDistanceQuery("r >= ST_Distance(a, b)", "ST_Distance(a, b) <= r");
        this.testSimpleDistanceQuery("r >= ST_Distance(b, a)", "ST_Distance(b, a) <= r");
        this.testSimpleDistanceQuery("ST_Distance(a, b) < r", "ST_Distance(a, b) < r");
        this.testSimpleDistanceQuery("ST_Distance(b, a) < r", "ST_Distance(b, a) < r");
        this.testSimpleDistanceQuery("r > ST_Distance(a, b)", "ST_Distance(a, b) < r");
        this.testSimpleDistanceQuery("r > ST_Distance(b, a)", "ST_Distance(b, a) < r");
        this.testSimpleDistanceQuery("ST_Distance(a, b) <= r AND name_a != name_b", "ST_Distance(a, b) <= r AND name_a != name_b");
        this.testSimpleDistanceQuery("r > ST_Distance(a, b) AND name_a != name_b", "ST_Distance(a, b) < r AND name_a != name_b");
        this.testRadiusExpressionInDistanceQuery("ST_Distance(a, b) <= decimal '1.2'", "ST_Distance(a, b) <= radius", "decimal '1.2'");
        this.testRadiusExpressionInDistanceQuery("ST_Distance(b, a) <= decimal '1.2'", "ST_Distance(b, a) <= radius", "decimal '1.2'");
        this.testRadiusExpressionInDistanceQuery("decimal '1.2' >= ST_Distance(a, b)", "ST_Distance(a, b) <= radius", "decimal '1.2'");
        this.testRadiusExpressionInDistanceQuery("decimal '1.2' >= ST_Distance(b, a)", "ST_Distance(b, a) <= radius", "decimal '1.2'");
        this.testRadiusExpressionInDistanceQuery("ST_Distance(a, b) < decimal '1.2'", "ST_Distance(a, b) < radius", "decimal '1.2'");
        this.testRadiusExpressionInDistanceQuery("ST_Distance(b, a) < decimal '1.2'", "ST_Distance(b, a) < radius", "decimal '1.2'");
        this.testRadiusExpressionInDistanceQuery("decimal '1.2' > ST_Distance(a, b)", "ST_Distance(a, b) < radius", "decimal '1.2'");
        this.testRadiusExpressionInDistanceQuery("decimal '1.2' > ST_Distance(b, a)", "ST_Distance(b, a) < radius", "decimal '1.2'");
        this.testRadiusExpressionInDistanceQuery("ST_Distance(a, b) <= decimal '1.2' AND name_a != name_b", "ST_Distance(a, b) <= radius AND name_a != name_b", "decimal '1.2'");
        this.testRadiusExpressionInDistanceQuery("decimal '1.2' > ST_Distance(a, b) AND name_a != name_b", "ST_Distance(a, b) < radius AND name_a != name_b", "decimal '1.2'");
        this.testRadiusExpressionInDistanceQuery("ST_Distance(a, b) <= 2 * r", "ST_Distance(a, b) <= radius", "2 * r");
        this.testRadiusExpressionInDistanceQuery("ST_Distance(b, a) <= 2 * r", "ST_Distance(b, a) <= radius", "2 * r");
        this.testRadiusExpressionInDistanceQuery("2 * r >= ST_Distance(a, b)", "ST_Distance(a, b) <= radius", "2 * r");
        this.testRadiusExpressionInDistanceQuery("2 * r >= ST_Distance(b, a)", "ST_Distance(b, a) <= radius", "2 * r");
        this.testRadiusExpressionInDistanceQuery("ST_Distance(a, b) < 2 * r", "ST_Distance(a, b) < radius", "2 * r");
        this.testRadiusExpressionInDistanceQuery("ST_Distance(b, a) < 2 * r", "ST_Distance(b, a) < radius", "2 * r");
        this.testRadiusExpressionInDistanceQuery("2 * r > ST_Distance(a, b)", "ST_Distance(a, b) < radius", "2 * r");
        this.testRadiusExpressionInDistanceQuery("2 * r > ST_Distance(b, a)", "ST_Distance(b, a) < radius", "2 * r");
        this.testRadiusExpressionInDistanceQuery("ST_Distance(a, b) <= 2 * r AND name_a != name_b", "ST_Distance(a, b) <= radius AND name_a != name_b", "2 * r");
        this.testRadiusExpressionInDistanceQuery("2 * r > ST_Distance(a, b) AND name_a != name_b", "ST_Distance(a, b) < radius AND name_a != name_b", "2 * r");
        this.testPointExpressionsInDistanceQuery("ST_Distance(ST_Point(lng_a, lat_a), ST_Point(lng_b, lat_b)) <= 5", "ST_Distance(point_a, point_b) <= radius", "5");
        this.testPointExpressionsInDistanceQuery("ST_Distance(ST_Point(lng_b, lat_b), ST_Point(lng_a, lat_a)) <= 5", "ST_Distance(point_b, point_a) <= radius", "5");
        this.testPointExpressionsInDistanceQuery("5 >= ST_Distance(ST_Point(lng_a, lat_a), ST_Point(lng_b, lat_b))", "ST_Distance(point_a, point_b) <= radius", "5");
        this.testPointExpressionsInDistanceQuery("5 >= ST_Distance(ST_Point(lng_b, lat_b), ST_Point(lng_a, lat_a))", "ST_Distance(point_b, point_a) <= radius", "5");
        this.testPointExpressionsInDistanceQuery("ST_Distance(ST_Point(lng_a, lat_a), ST_Point(lng_b, lat_b)) < 5", "ST_Distance(point_a, point_b) < radius", "5");
        this.testPointExpressionsInDistanceQuery("ST_Distance(ST_Point(lng_b, lat_b), ST_Point(lng_a, lat_a)) < 5", "ST_Distance(point_b, point_a) < radius", "5");
        this.testPointExpressionsInDistanceQuery("5 > ST_Distance(ST_Point(lng_a, lat_a), ST_Point(lng_b, lat_b))", "ST_Distance(point_a, point_b) < radius", "5");
        this.testPointExpressionsInDistanceQuery("5 > ST_Distance(ST_Point(lng_b, lat_b), ST_Point(lng_a, lat_a))", "ST_Distance(point_b, point_a) < radius", "5");
        this.testPointExpressionsInDistanceQuery("ST_Distance(ST_Point(lng_a, lat_a), ST_Point(lng_b, lat_b)) <= 5 AND name_a != name_b", "ST_Distance(point_a, point_b) <= radius AND name_a != name_b", "5");
        this.testPointExpressionsInDistanceQuery("5 > ST_Distance(ST_Point(lng_a, lat_a), ST_Point(lng_b, lat_b)) AND name_a != name_b", "ST_Distance(point_a, point_b) < radius AND name_a != name_b", "5");
        this.testPointAndRadiusExpressionsInDistanceQuery("ST_Distance(ST_Point(lng_a, lat_a), ST_Point(lng_b, lat_b)) <= 500 / (111000 * cos(lat_b))", "ST_Distance(point_a, point_b) <= radius", "500 / (111000 * cos(lat_b))");
        this.testPointAndRadiusExpressionsInDistanceQuery("ST_Distance(ST_Point(lng_b, lat_b), ST_Point(lng_a, lat_a)) <= 500 / (111000 * cos(lat_b))", "ST_Distance(point_b, point_a) <= radius", "500 / (111000 * cos(lat_b))");
        this.testPointAndRadiusExpressionsInDistanceQuery("500 / (111000 * cos(lat_b)) >= ST_Distance(ST_Point(lng_a, lat_a), ST_Point(lng_b, lat_b))", "ST_Distance(point_a, point_b) <= radius", "500 / (111000 * cos(lat_b))");
        this.testPointAndRadiusExpressionsInDistanceQuery("500 / (111000 * cos(lat_b)) >= ST_Distance(ST_Point(lng_b, lat_b), ST_Point(lng_a, lat_a))", "ST_Distance(point_b, point_a) <= radius", "500 / (111000 * cos(lat_b))");
        this.testPointAndRadiusExpressionsInDistanceQuery("ST_Distance(ST_Point(lng_a, lat_a), ST_Point(lng_b, lat_b)) < 500 / (111000 * cos(lat_b))", "ST_Distance(point_a, point_b) < radius", "500 / (111000 * cos(lat_b))");
        this.testPointAndRadiusExpressionsInDistanceQuery("ST_Distance(ST_Point(lng_b, lat_b), ST_Point(lng_a, lat_a)) < 500 / (111000 * cos(lat_b))", "ST_Distance(point_b, point_a) < radius", "500 / (111000 * cos(lat_b))");
        this.testPointAndRadiusExpressionsInDistanceQuery("500 / (111000 * cos(lat_b)) > ST_Distance(ST_Point(lng_a, lat_a), ST_Point(lng_b, lat_b))", "ST_Distance(point_a, point_b) < radius", "500 / (111000 * cos(lat_b))");
        this.testPointAndRadiusExpressionsInDistanceQuery("500 / (111000 * cos(lat_b)) > ST_Distance(ST_Point(lng_b, lat_b), ST_Point(lng_a, lat_a))", "ST_Distance(point_b, point_a) < radius", "500 / (111000 * cos(lat_b))");
        this.testPointAndRadiusExpressionsInDistanceQuery("ST_Distance(ST_Point(lng_a, lat_a), ST_Point(lng_b, lat_b)) <= 500 / (111000 * cos(lat_b)) AND name_a != name_b", "ST_Distance(point_a, point_b) <= radius AND name_a != name_b", "500 / (111000 * cos(lat_b))");
        this.testPointAndRadiusExpressionsInDistanceQuery("500 / (111000 * cos(lat_b)) > ST_Distance(ST_Point(lng_a, lat_a), ST_Point(lng_b, lat_b)) AND name_a != name_b", "ST_Distance(point_a, point_b) < radius AND name_a != name_b", "500 / (111000 * cos(lat_b))");
    }

    private void testSimpleDistanceQuery(String filter, String newFilter) {
        this.assertRuleApplication().on(p -> p.filter(this.sqlToRowExpression(filter, (Map<String, Type>)ImmutableMap.of((Object)"a", (Object)GeometryType.GEOMETRY, (Object)"b", (Object)GeometryType.GEOMETRY, (Object)"name_a", (Object)BigintType.BIGINT, (Object)"name_b", (Object)BigintType.BIGINT, (Object)"r", (Object)BigintType.BIGINT)), (PlanNode)p.join(JoinType.INNER, (PlanNode)p.values(p.variable("a", (Type)GeometryType.GEOMETRY), p.variable("name_a")), (PlanNode)p.values(p.variable("b", (Type)GeometryType.GEOMETRY), p.variable("name_b"), p.variable("r")), new EquiJoinClause[0]))).matches(PlanMatchPattern.spatialJoin(newFilter, PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"a", (Object)0, (Object)"name_a", (Object)1)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"b", (Object)0, (Object)"name_b", (Object)1, (Object)"r", (Object)2))));
    }

    private void testRadiusExpressionInDistanceQuery(String filter, String newFilter, String radiusExpression) {
        this.assertRuleApplication().on(p -> p.filter(this.sqlToRowExpression(filter, (Map<String, Type>)ImmutableMap.of((Object)"a", (Object)GeometryType.GEOMETRY, (Object)"b", (Object)GeometryType.GEOMETRY, (Object)"name_a", (Object)BigintType.BIGINT, (Object)"name_b", (Object)BigintType.BIGINT, (Object)"r", (Object)BigintType.BIGINT)), (PlanNode)p.join(JoinType.INNER, (PlanNode)p.values(p.variable("a", (Type)GeometryType.GEOMETRY), p.variable("name_a")), (PlanNode)p.values(p.variable("b", (Type)GeometryType.GEOMETRY), p.variable("name_b"), p.variable("r")), new EquiJoinClause[0]))).matches(PlanMatchPattern.spatialJoin(newFilter, PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"a", (Object)0, (Object)"name_a", (Object)1)), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"radius", (Object)PlanMatchPattern.expression(radiusExpression)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"b", (Object)0, (Object)"name_b", (Object)1, (Object)"r", (Object)2)))));
    }

    private void testPointExpressionsInDistanceQuery(String filter, String newFilter, String radiusExpression) {
        this.assertRuleApplication().on(p -> p.filter(this.sqlToRowExpression(filter, TestExtractSpatialInnerJoin.buildBigIntTypeProviderMap("lat_a", "lng_a", "lat_b", "lng_b", "name_a", "name_b")), (PlanNode)p.join(JoinType.INNER, (PlanNode)p.values(p.variable("lat_a"), p.variable("lng_a"), p.variable("name_a")), (PlanNode)p.values(p.variable("lat_b"), p.variable("lng_b"), p.variable("name_b")), new EquiJoinClause[0]))).matches(PlanMatchPattern.spatialJoin(newFilter, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"point_a", (Object)PlanMatchPattern.expression("ST_Point(lng_a, lat_a)")), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"lat_a", (Object)0, (Object)"lng_a", (Object)1, (Object)"name_a", (Object)2))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"point_b", (Object)PlanMatchPattern.expression("ST_Point(lng_b, lat_b)")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"radius", (Object)PlanMatchPattern.expression(radiusExpression)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"lat_b", (Object)0, (Object)"lng_b", (Object)1, (Object)"name_b", (Object)2))))));
    }

    private void testPointAndRadiusExpressionsInDistanceQuery(String filter, String newFilter, String radiusExpression) {
        this.assertRuleApplication().on(p -> p.filter(this.sqlToRowExpression(filter, TestExtractSpatialInnerJoin.buildBigIntTypeProviderMap("lat_a", "lng_a", "lat_b", "lng_b", "name_a", "name_b")), (PlanNode)p.join(JoinType.INNER, (PlanNode)p.values(p.variable("lat_a"), p.variable("lng_a"), p.variable("name_a")), (PlanNode)p.values(p.variable("lat_b"), p.variable("lng_b"), p.variable("name_b")), new EquiJoinClause[0]))).matches(PlanMatchPattern.spatialJoin(newFilter, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"point_a", (Object)PlanMatchPattern.expression("ST_Point(lng_a, lat_a)")), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"lat_a", (Object)0, (Object)"lng_a", (Object)1, (Object)"name_a", (Object)2))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"point_b", (Object)PlanMatchPattern.expression("ST_Point(lng_b, lat_b)")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"radius", (Object)PlanMatchPattern.expression(radiusExpression)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"lat_b", (Object)0, (Object)"lng_b", (Object)1, (Object)"name_b", (Object)2))))));
    }

    @Test
    public void testSphericalGeographiesDoesFire() {
        this.assertRuleApplication().on(p -> p.filter(this.sqlToRowExpression("ST_Distance(a, b) < 5000", (Map<String, Type>)ImmutableMap.of((Object)"a", (Object)SphericalGeographyType.SPHERICAL_GEOGRAPHY, (Object)"b", (Object)SphericalGeographyType.SPHERICAL_GEOGRAPHY)), (PlanNode)p.join(JoinType.INNER, (PlanNode)p.values(p.variable("a", (Type)SphericalGeographyType.SPHERICAL_GEOGRAPHY)), (PlanNode)p.values(p.variable("b", (Type)SphericalGeographyType.SPHERICAL_GEOGRAPHY)), new EquiJoinClause[0]))).matches(PlanMatchPattern.spatialJoin("ST_Distance(a, b) < radius", PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"a", (Object)0)), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b", (Object)PlanMatchPattern.expression("b"), (Object)"radius", (Object)PlanMatchPattern.expression("BIGINT '5000'")), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"b", (Object)0)))));
        this.assertRuleApplication().on(p -> p.filter(this.sqlToRowExpression("ST_Distance(to_spherical_geography(ST_GeometryFromText(wkt)), point) < 5", (Map<String, Type>)ImmutableMap.of((Object)"wkt", (Object)VarcharType.VARCHAR, (Object)"point", (Object)SphericalGeographyType.SPHERICAL_GEOGRAPHY)), (PlanNode)p.join(JoinType.INNER, (PlanNode)p.values(p.variable("wkt", (Type)VarcharType.VARCHAR)), (PlanNode)p.values(p.variable("point", (Type)SphericalGeographyType.SPHERICAL_GEOGRAPHY)), new EquiJoinClause[0]))).matches(PlanMatchPattern.spatialJoin("ST_Distance(to_spherical_geography, point) < radius", PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"to_spherical_geography", (Object)PlanMatchPattern.expression("to_spherical_geography(ST_GeometryFromText(wkt))")), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"wkt", (Object)0))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"point", (Object)PlanMatchPattern.expression("point"), (Object)"radius", (Object)PlanMatchPattern.expression("INTEGER '5'")), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"point", (Object)0)))));
    }

    @Test
    public void testConvertToSpatialJoin() {
        this.assertRuleApplication().on(p -> p.filter(this.sqlToRowExpression("ST_Contains(a, b)", (Map<String, Type>)ImmutableMap.of((Object)"a", (Object)GeometryType.GEOMETRY, (Object)"b", (Object)GeometryType.GEOMETRY)), (PlanNode)p.join(JoinType.INNER, (PlanNode)p.values(p.variable("a", (Type)GeometryType.GEOMETRY)), (PlanNode)p.values(p.variable("b", (Type)GeometryType.GEOMETRY)), new EquiJoinClause[0]))).matches(PlanMatchPattern.spatialJoin("ST_Contains(a, b)", PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"a", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"b", (Object)0))));
        this.assertRuleApplication().on(p -> p.filter(this.sqlToRowExpression("name_1 != name_2 AND ST_Contains(a, b)", (Map<String, Type>)ImmutableMap.of((Object)"a", (Object)GeometryType.GEOMETRY, (Object)"b", (Object)GeometryType.GEOMETRY, (Object)"name_1", (Object)BigintType.BIGINT, (Object)"name_2", (Object)BigintType.BIGINT)), (PlanNode)p.join(JoinType.INNER, (PlanNode)p.values(p.variable("a", (Type)GeometryType.GEOMETRY), p.variable("name_1")), (PlanNode)p.values(p.variable("b", (Type)GeometryType.GEOMETRY), p.variable("name_2")), new EquiJoinClause[0]))).matches(PlanMatchPattern.spatialJoin("name_1 != name_2 AND ST_Contains(a, b)", PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"a", (Object)0, (Object)"name_1", (Object)1)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"b", (Object)0, (Object)"name_2", (Object)1))));
        this.assertRuleApplication().on(p -> p.filter(this.sqlToRowExpression("ST_Contains(a1, b1) AND ST_Contains(a2, b2)", (Map<String, Type>)ImmutableMap.of((Object)"a1", (Object)GeometryType.GEOMETRY, (Object)"a2", (Object)GeometryType.GEOMETRY, (Object)"b1", (Object)GeometryType.GEOMETRY, (Object)"b2", (Object)GeometryType.GEOMETRY)), (PlanNode)p.join(JoinType.INNER, (PlanNode)p.values(p.variable("a1", (Type)GeometryType.GEOMETRY), p.variable("a2", (Type)GeometryType.GEOMETRY)), (PlanNode)p.values(p.variable("b1", (Type)GeometryType.GEOMETRY), p.variable("b2", (Type)GeometryType.GEOMETRY)), new EquiJoinClause[0]))).matches(PlanMatchPattern.spatialJoin("ST_Contains(a1, b1) AND ST_Contains(a2, b2)", PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"a1", (Object)0, (Object)"a2", (Object)1)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"b1", (Object)0, (Object)"b2", (Object)1))));
    }

    @Test
    public void testPushDownFirstArgument() {
        this.assertRuleApplication().on(p -> p.filter(this.sqlToRowExpression("ST_Contains(ST_GeometryFromText(wkt), point)", (Map<String, Type>)ImmutableMap.of((Object)"wkt", (Object)VarcharType.VARCHAR, (Object)"point", (Object)GeometryType.GEOMETRY)), (PlanNode)p.join(JoinType.INNER, (PlanNode)p.values(p.variable("wkt", (Type)VarcharType.VARCHAR)), (PlanNode)p.values(p.variable("point", (Type)GeometryType.GEOMETRY)), new EquiJoinClause[0]))).matches(PlanMatchPattern.spatialJoin("ST_Contains(st_geometryfromtext, point)", PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"st_geometryfromtext", (Object)PlanMatchPattern.expression("ST_GeometryFromText(wkt)")), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"wkt", (Object)0))), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"point", (Object)0))));
        this.assertRuleApplication().on(p -> p.filter(this.sqlToRowExpression("ST_Contains(ST_GeometryFromText(wkt), ST_Point(0, 0))", (Map<String, Type>)ImmutableMap.of((Object)"wkt", (Object)VarcharType.VARCHAR)), (PlanNode)p.join(JoinType.INNER, (PlanNode)p.values(p.variable("wkt", (Type)VarcharType.VARCHAR)), (PlanNode)p.values(), new EquiJoinClause[0]))).doesNotFire();
    }

    @Test
    public void testPushDownSecondArgument() {
        this.assertRuleApplication().on(p -> p.filter(this.sqlToRowExpression("ST_Contains(polygon, ST_Point(lng, lat))", (Map<String, Type>)ImmutableMap.of((Object)"polygon", (Object)GeometryType.GEOMETRY, (Object)"lat", (Object)BigintType.BIGINT, (Object)"lng", (Object)BigintType.BIGINT)), (PlanNode)p.join(JoinType.INNER, (PlanNode)p.values(p.variable("polygon", (Type)GeometryType.GEOMETRY)), (PlanNode)p.values(p.variable("lat"), p.variable("lng")), new EquiJoinClause[0]))).matches(PlanMatchPattern.spatialJoin("ST_Contains(polygon, st_point)", PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"polygon", (Object)0)), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"st_point", (Object)PlanMatchPattern.expression("ST_Point(lng, lat)")), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"lat", (Object)0, (Object)"lng", (Object)1)))));
        this.assertRuleApplication().on(p -> p.filter(this.sqlToRowExpression("ST_Contains(ST_GeometryFromText('POLYGON ((0 0, 0 0, 0 0, 0 0))'), ST_Point(lng, lat))", (Map<String, Type>)ImmutableMap.of((Object)"lat", (Object)BigintType.BIGINT, (Object)"lng", (Object)BigintType.BIGINT)), (PlanNode)p.join(JoinType.INNER, (PlanNode)p.values(), (PlanNode)p.values(p.variable("lat"), p.variable("lng")), new EquiJoinClause[0]))).doesNotFire();
    }

    @Test
    public void testPushDownBothArguments() {
        this.assertRuleApplication().on(p -> p.filter(this.sqlToRowExpression("ST_Contains(ST_GeometryFromText(wkt), ST_Point(lng, lat))", (Map<String, Type>)ImmutableMap.of((Object)"wkt", (Object)VarcharType.VARCHAR, (Object)"lat", (Object)BigintType.BIGINT, (Object)"lng", (Object)BigintType.BIGINT)), (PlanNode)p.join(JoinType.INNER, (PlanNode)p.values(p.variable("wkt", (Type)VarcharType.VARCHAR)), (PlanNode)p.values(p.variable("lat"), p.variable("lng")), new EquiJoinClause[0]))).matches(PlanMatchPattern.spatialJoin("ST_Contains(st_geometryfromtext, st_point)", PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"st_geometryfromtext", (Object)PlanMatchPattern.expression("ST_GeometryFromText(wkt)")), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"wkt", (Object)0))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"st_point", (Object)PlanMatchPattern.expression("ST_Point(lng, lat)")), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"lat", (Object)0, (Object)"lng", (Object)1)))));
    }

    @Test
    public void testPushDownOppositeOrder() {
        this.assertRuleApplication().on(p -> p.filter(this.sqlToRowExpression("ST_Contains(ST_GeometryFromText(wkt), ST_Point(lng, lat))", (Map<String, Type>)ImmutableMap.of((Object)"wkt", (Object)VarcharType.VARCHAR, (Object)"lat", (Object)BigintType.BIGINT, (Object)"lng", (Object)BigintType.BIGINT)), (PlanNode)p.join(JoinType.INNER, (PlanNode)p.values(p.variable("lat"), p.variable("lng")), (PlanNode)p.values(p.variable("wkt", (Type)VarcharType.VARCHAR)), new EquiJoinClause[0]))).matches(PlanMatchPattern.spatialJoin("ST_Contains(st_geometryfromtext, st_point)", PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"st_point", (Object)PlanMatchPattern.expression("ST_Point(lng, lat)")), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"lat", (Object)0, (Object)"lng", (Object)1))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"st_geometryfromtext", (Object)PlanMatchPattern.expression("ST_GeometryFromText(wkt)")), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"wkt", (Object)0)))));
    }

    @Test
    public void testPushDownAnd() {
        this.assertRuleApplication().on(p -> p.filter(this.sqlToRowExpression("name_1 != name_2 AND ST_Contains(ST_GeometryFromText(wkt), ST_Point(lng, lat))", (Map<String, Type>)ImmutableMap.of((Object)"wkt", (Object)VarcharType.VARCHAR, (Object)"lat", (Object)BigintType.BIGINT, (Object)"lng", (Object)BigintType.BIGINT, (Object)"name_1", (Object)BigintType.BIGINT, (Object)"name_2", (Object)BigintType.BIGINT)), (PlanNode)p.join(JoinType.INNER, (PlanNode)p.values(p.variable("wkt", (Type)VarcharType.VARCHAR), p.variable("name_1")), (PlanNode)p.values(p.variable("lat"), p.variable("lng"), p.variable("name_2")), new EquiJoinClause[0]))).matches(PlanMatchPattern.spatialJoin("name_1 != name_2 AND ST_Contains(st_geometryfromtext, st_point)", PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"st_geometryfromtext", (Object)PlanMatchPattern.expression("ST_GeometryFromText(wkt)")), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"wkt", (Object)0, (Object)"name_1", (Object)1))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"st_point", (Object)PlanMatchPattern.expression("ST_Point(lng, lat)")), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"lat", (Object)0, (Object)"lng", (Object)1, (Object)"name_2", (Object)2)))));
        this.assertRuleApplication().on(p -> p.filter(this.sqlToRowExpression("ST_Contains(ST_GeometryFromText(wkt1), geometry1) AND ST_Contains(ST_GeometryFromText(wkt2), geometry2)", (Map<String, Type>)ImmutableMap.of((Object)"wkt1", (Object)VarcharType.VARCHAR, (Object)"wkt2", (Object)VarcharType.VARCHAR, (Object)"geometry1", (Object)GeometryType.GEOMETRY, (Object)"geometry2", (Object)GeometryType.GEOMETRY)), (PlanNode)p.join(JoinType.INNER, (PlanNode)p.values(p.variable("wkt1", (Type)VarcharType.VARCHAR), p.variable("wkt2", (Type)VarcharType.VARCHAR)), (PlanNode)p.values(p.variable("geometry1", (Type)GeometryType.GEOMETRY), p.variable("geometry2", (Type)GeometryType.GEOMETRY)), new EquiJoinClause[0]))).matches(PlanMatchPattern.spatialJoin("ST_Contains(st_geometryfromtext, geometry1) AND ST_Contains(ST_GeometryFromText(wkt2), geometry2)", PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"st_geometryfromtext", (Object)PlanMatchPattern.expression("ST_GeometryFromText(wkt1)")), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"wkt1", (Object)0, (Object)"wkt2", (Object)1))), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"geometry1", (Object)0, (Object)"geometry2", (Object)1))));
    }

    private RuleAssert assertRuleApplication() {
        RuleTester tester = this.tester();
        return tester.assertThat((Rule)new ExtractSpatialJoins.ExtractSpatialInnerJoin(tester.getMetadata(), tester.getSplitManager(), tester.getPageSourceManager()));
    }

    private RowExpression sqlToRowExpression(String sql, Map<String, Type> typeMap) {
        return this.sqlToRowExpressionTranslator.translateAndOptimize(PlanBuilder.expression(sql), TypeProvider.copyOf(typeMap));
    }

    private static Map<String, Type> buildBigIntTypeProviderMap(String ... variables) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Arrays.stream(variables).forEach(variable -> builder.put(variable, (Object)BigintType.BIGINT));
        return builder.build();
    }
}

