/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.geospatial;

import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.testng.annotations.Test;
import org.testng.internal.collections.Pair;

public class TestGeoRelations
extends AbstractTestFunctions {
    public static final List<String> RELATION_GEOMETRIES_WKT = ImmutableList.of((Object)"'POLYGON ((0 0, 0 1, 1 1, 1 0, 0 0))'", (Object)"'POLYGON ((0 0, 0 2, 2 2, 2 0, 0 0))'", (Object)"'POLYGON ((1 0, 1 1, 3 1, 3 0, 1 0))'", (Object)"'LINESTRING (1 0.5, 2.5 0.5)'", (Object)"'LINESTRING (2 0, 2 2)'", (Object)"'LINESTRING (2 0.5, 2 2)'", (Object)"'POINT (1.5 0.5)'", (Object)"'POINT (2 0.5)'");
    public static final List<Pair<Integer, Integer>> EQUALS_PAIRS = ImmutableList.of((Object)Pair.of((Object)0, (Object)0), (Object)Pair.of((Object)1, (Object)1), (Object)Pair.of((Object)2, (Object)2), (Object)Pair.of((Object)3, (Object)3), (Object)Pair.of((Object)4, (Object)4), (Object)Pair.of((Object)5, (Object)5), (Object)Pair.of((Object)6, (Object)6), (Object)Pair.of((Object)7, (Object)7));
    public static final List<Pair<Integer, Integer>> CONTAINS_PAIRS = ImmutableList.of((Object)Pair.of((Object)1, (Object)0), (Object)Pair.of((Object)2, (Object)3), (Object)Pair.of((Object)4, (Object)5), (Object)Pair.of((Object)1, (Object)6), (Object)Pair.of((Object)2, (Object)6), (Object)Pair.of((Object)2, (Object)7), (Object)Pair.of((Object)3, (Object)6), (Object)Pair.of((Object)3, (Object)7), (Object)Pair.of((Object)4, (Object)7));
    public static final List<Pair<Integer, Integer>> TOUCHES_PAIRS = ImmutableList.of((Object)Pair.of((Object)0, (Object)2), (Object)Pair.of((Object)0, (Object)3), (Object)Pair.of((Object)1, (Object)4), (Object)Pair.of((Object)1, (Object)5), (Object)Pair.of((Object)3, (Object)5), (Object)Pair.of((Object)1, (Object)7), (Object)Pair.of((Object)5, (Object)7));
    public static final List<Pair<Integer, Integer>> OVERLAPS_PAIRS = ImmutableList.of((Object)Pair.of((Object)1, (Object)2));
    public static final List<Pair<Integer, Integer>> CROSSES_PAIRS = ImmutableList.of((Object)Pair.of((Object)1, (Object)3), (Object)Pair.of((Object)2, (Object)4), (Object)Pair.of((Object)2, (Object)5), (Object)Pair.of((Object)3, (Object)4));

    @Test
    public void testStContains() {
        this.assertRelation("ST_Contains", "null", "'POINT (25 25)'", null);
        this.assertRelation("ST_Contains", "'POINT (20 20)'", "'POINT (25 25)'", false);
        this.assertRelation("ST_Contains", "'MULTIPOINT (20 20, 25 25)'", "'POINT (25 25)'", true);
        this.assertRelation("ST_Contains", "'LINESTRING (20 20, 30 30)'", "'POINT (25 25)'", true);
        this.assertRelation("ST_Contains", "'LINESTRING (20 20, 30 30)'", "'MULTIPOINT (25 25, 31 31)'", false);
        this.assertRelation("ST_Contains", "'LINESTRING (20 20, 30 30)'", "'LINESTRING (25 25, 27 27)'", true);
        this.assertRelation("ST_Contains", "'MULTILINESTRING ((1 1, 5 1), (2 4, 4 4))'", "'MULTILINESTRING ((3 4, 4 4), (2 1, 6 1))'", false);
        this.assertRelation("ST_Contains", "'POLYGON ((0 0, 0 4, 4 4, 4 0, 0 0))'", "'POLYGON ((1 1, 1 2, 2 2, 2 1, 1 1))'", true);
        this.assertRelation("ST_Contains", "'POLYGON ((0 0, 0 4, 4 4, 4 0, 0 0))'", "'POLYGON ((-1 -1, -1 2, 2 2, 2 -1, -1 -1))'", false);
        this.assertRelation("ST_Contains", "'MULTIPOLYGON (((0 0, 0 2, 2 2, 2 0, 0 0)), ((2 2, 2 4, 4 4, 4 2, 2 2)))'", "'POLYGON ((2 2, 2 3, 3 3, 3 2, 2 2))'", true);
        this.assertRelation("ST_Contains", "'LINESTRING (20 20, 30 30)'", "'POLYGON ((0 0, 0 4, 4 4, 4 0, 0 0))'", false);
        this.assertRelation("ST_Contains", "'LINESTRING EMPTY'", "'POLYGON ((0 0, 0 4, 4 4, 4 0, 0 0))'", false);
        this.assertRelation("ST_Contains", "'LINESTRING (20 20, 30 30)'", "'POLYGON EMPTY'", false);
    }

    @Test
    public void testSTCrosses() {
        this.assertRelation("ST_Crosses", "'POINT (20 20)'", "'POINT (25 25)'", false);
        this.assertRelation("ST_Crosses", "'LINESTRING (20 20, 30 30)'", "'POINT (25 25)'", false);
        this.assertRelation("ST_Crosses", "'LINESTRING (20 20, 30 30)'", "'MULTIPOINT (25 25, 31 31)'", true);
        this.assertRelation("ST_Crosses", "'LINESTRING(0 0, 1 1)'", "'LINESTRING (1 0, 0 1)'", true);
        this.assertRelation("ST_Crosses", "'POLYGON ((1 1, 1 4, 4 4, 4 1, 1 1))'", "'POLYGON ((2 2, 2 5, 5 5, 5 2, 2 2))'", false);
        this.assertRelation("ST_Crosses", "'MULTIPOLYGON (((0 0, 0 2, 2 2, 2 0, 0 0)), ((2 2, 2 4, 4 4, 4 2, 2 2)))'", "'POLYGON ((2 2, 2 3, 3 3, 3 2, 2 2))'", false);
        this.assertRelation("ST_Crosses", "'LINESTRING (-2 -2, 6 6)'", "'POLYGON ((0 0, 0 4, 4 4, 4 0, 0 0))'", true);
        this.assertRelation("ST_Crosses", "'POINT (20 20)'", "'POINT (20 20)'", false);
        this.assertRelation("ST_Crosses", "'POLYGON ((0 0, 0 4, 4 4, 4 0, 0 0))'", "'POLYGON ((0 0, 0 4, 4 4, 4 0, 0 0))'", false);
        this.assertRelation("ST_Crosses", "'POLYGON ((0 0, 0 4, 4 4, 4 0, 0 0))'", "'LINESTRING (0 0, 0 4, 4 4, 4 0)'", false);
    }

    @Test
    public void testSTDisjoint() {
        this.assertRelation("ST_Disjoint", "'POINT (50 100)'", "'POINT (150 150)'", true);
        this.assertRelation("ST_Disjoint", "'MULTIPOINT (50 100, 50 200)'", "'POINT (50 100)'", false);
        this.assertRelation("ST_Disjoint", "'LINESTRING (0 0, 0 1)'", "'LINESTRING (1 1, 1 0)'", true);
        this.assertRelation("ST_Disjoint", "'LINESTRING (2 1, 1 2)'", "'LINESTRING (3 1, 1 3)'", true);
        this.assertRelation("ST_Disjoint", "'LINESTRING (1 1, 3 3)'", "'LINESTRING (3 1, 1 3)'", false);
        this.assertRelation("ST_Disjoint", "'LINESTRING (50 100, 50 200)'", "'LINESTRING (20 150, 100 150)'", false);
        this.assertRelation("ST_Disjoint", "'MULTILINESTRING ((1 1, 5 1), (2 4, 4 4))'", "'MULTILINESTRING ((3 4, 6 4), (5 0, 5 4))'", false);
        this.assertRelation("ST_Disjoint", "'POLYGON ((1 1, 1 3, 3 3, 3 1, 1 1))'", "'POLYGON ((4 4, 4 5, 5 5, 5 4, 4 4))'", true);
        this.assertRelation("ST_Disjoint", "'MULTIPOLYGON (((1 1, 1 3, 3 3, 3 1, 1 1)), ((0 0, 0 2, 2 2, 2 0, 0 0)))'", "'POLYGON ((0 1, 3 1, 3 3, 0 3, 0 1))'", false);
    }

    @Test
    public void testSTEquals() {
        this.assertRelation("ST_Equals", "'POINT (50 100)'", "'POINT (150 150)'", false);
        this.assertRelation("ST_Equals", "'MULTIPOINT (50 100, 50 200)'", "'POINT (50 100)'", false);
        this.assertRelation("ST_Equals", "'LINESTRING (0 0, 0 1)'", "'LINESTRING (1 1, 1 0)'", false);
        this.assertRelation("ST_Equals", "'LINESTRING (0 0, 2 2)'", "'LINESTRING (0 0, 2 2)'", true);
        this.assertRelation("ST_Equals", "'MULTILINESTRING ((1 1, 5 1), (2 4, 4 4))'", "'MULTILINESTRING ((3 4, 6 4), (5 0, 5 4))'", false);
        this.assertRelation("ST_Equals", "'POLYGON ((1 1, 1 3, 3 3, 3 1, 1 1))'", "'POLYGON ((3 3, 3 1, 1 1, 1 3, 3 3))'", true);
        this.assertRelation("ST_Equals", "'MULTIPOLYGON (((1 1, 1 3, 3 3, 3 1, 1 1)), ((0 0, 0 2, 2 2, 2 0, 0 0)))'", "'POLYGON ((0 1, 3 1, 3 3, 0 3, 0 1))'", false);
    }

    @Test
    public void testSTIntersects() {
        this.assertRelation("ST_Intersects", "'POINT (50 100)'", "'POINT (150 150)'", false);
        this.assertRelation("ST_Intersects", "'MULTIPOINT (50 100, 50 200)'", "'POINT (50 100)'", true);
        this.assertRelation("ST_Intersects", "'LINESTRING (0 0, 0 1)'", "'LINESTRING (1 1, 1 0)'", false);
        this.assertRelation("ST_Intersects", "'LINESTRING (50 100, 50 200)'", "'LINESTRING (20 150, 100 150)'", true);
        this.assertRelation("ST_Intersects", "'MULTILINESTRING ((1 1, 5 1), (2 4, 4 4))'", "'MULTILINESTRING ((3 4, 6 4), (5 0, 5 4))'", true);
        this.assertRelation("ST_Intersects", "'POLYGON ((1 1, 1 3, 3 3, 3 1, 1 1))'", "'POLYGON ((4 4, 4 5, 5 5, 5 4, 4 4))'", false);
        this.assertRelation("ST_Intersects", "'MULTIPOLYGON (((1 1, 1 3, 3 3, 3 1, 1 1)), ((0 0, 0 2, 2 2, 2 0, 0 0)))'", "'POLYGON ((0 1, 3 1, 3 3, 0 3, 0 1))'", true);
        this.assertRelation("ST_Intersects", "'POLYGON ((16.5 54, 16.5 54.1, 16.51 54.1, 16.8 54, 16.5 54))'", "'LINESTRING (16.6 53, 16.6 56)'", true);
        this.assertRelation("ST_Intersects", "'POLYGON ((16.5 54, 16.5 54.1, 16.51 54.1, 16.8 54, 16.5 54))'", "'LINESTRING (16.6667 54.05, 16.8667 54.05)'", false);
        this.assertRelation("ST_Intersects", "'POLYGON ((16.5 54, 16.5 54.1, 16.51 54.1, 16.8 54, 16.5 54))'", "'LINESTRING (16.6667 54.25, 16.8667 54.25)'", false);
    }

    @Test
    public void testSTOverlaps() {
        this.assertRelation("ST_Overlaps", "'POINT (50 100)'", "'POINT (150 150)'", false);
        this.assertRelation("ST_Overlaps", "'POINT (50 100)'", "'POINT (50 100)'", false);
        this.assertRelation("ST_Overlaps", "'MULTIPOINT (50 100, 50 200)'", "'POINT (50 100)'", false);
        this.assertRelation("ST_Overlaps", "'LINESTRING (0 0, 0 1)'", "'LINESTRING (1 1, 1 0)'", false);
        this.assertRelation("ST_Overlaps", "'MULTILINESTRING ((1 1, 5 1), (2 4, 4 4))'", "'MULTILINESTRING ((3 4, 6 4), (5 0, 5 4))'", true);
        this.assertRelation("ST_Overlaps", "'POLYGON ((1 1, 1 4, 4 4, 4 1, 1 1))'", "'POLYGON ((3 3, 3 5, 5 5, 5 3, 3 3))'", true);
        this.assertRelation("ST_Overlaps", "'POLYGON ((1 1, 1 4, 4 4, 4 1, 1 1))'", "'POLYGON ((1 1, 1 4, 4 4, 4 1, 1 1))'", false);
        this.assertRelation("ST_Overlaps", "'POLYGON ((1 1, 1 4, 4 4, 4 1, 1 1))'", "'LINESTRING (1 1, 4 4)'", false);
        this.assertRelation("ST_Overlaps", "'POLYGON ((1 1, 1 3, 3 3, 3 1, 1 1))'", "'POLYGON ((4 4, 4 5, 5 5, 5 4, 4 4))'", false);
        this.assertRelation("ST_Overlaps", "'MULTIPOLYGON (((1 1, 1 3, 3 3, 3 1, 1 1)), ((0 0, 0 2, 2 2, 2 0, 0 0)))'", "'POLYGON ((0 1, 3 1, 3 3, 0 3, 0 1))'", true);
    }

    @Test
    public void testSTRelate() {
        this.assertFunction("ST_Relate(ST_GeometryFromText('LINESTRING (0 0, 3 3)'), ST_GeometryFromText('LINESTRING (1 1, 4 1)'), '****T****')", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ST_Relate(ST_GeometryFromText('POLYGON ((2 0, 2 1, 3 1, 2 0))'), ST_GeometryFromText('POLYGON ((1 1, 1 4, 4 4, 4 1, 1 1))'), '****T****')", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ST_Relate(ST_GeometryFromText('POLYGON ((2 0, 2 1, 3 1, 2 0))'), ST_GeometryFromText('POLYGON ((1 1, 1 4, 4 4, 4 1, 1 1))'), 'T********')", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testSTTouches() {
        this.assertRelation("ST_Touches", "'POINT (50 100)'", "'POINT (150 150)'", false);
        this.assertRelation("ST_Touches", "'MULTIPOINT (50 100, 50 200)'", "'POINT (50 100)'", false);
        this.assertRelation("ST_Touches", "'LINESTRING (50 100, 50 200)'", "'LINESTRING (20 150, 100 150)'", false);
        this.assertRelation("ST_Touches", "'MULTILINESTRING ((1 1, 5 1), (2 4, 4 4))'", "'MULTILINESTRING ((3 4, 6 4), (5 0, 5 4))'", false);
        this.assertRelation("ST_Touches", "'POINT (1 2)'", "'POLYGON ((1 1, 1 4, 4 4, 4 1, 1 1))'", true);
        this.assertRelation("ST_Touches", "'POLYGON ((1 1, 1 3, 3 3, 3 1, 1 1))'", "'POLYGON ((4 4, 4 5, 5 5, 5 4, 4 4))'", false);
        this.assertRelation("ST_Touches", "'POLYGON ((1 1, 1 3, 3 3, 3 1, 1 1))'", "'LINESTRING (0 0, 1 1)'", true);
        this.assertRelation("ST_Touches", "'POLYGON ((1 1, 1 3, 3 3, 3 1, 1 1))'", "'POLYGON ((3 3, 3 5, 5 5, 5 3, 3 3))'", true);
        this.assertRelation("ST_Touches", "'MULTIPOLYGON (((1 1, 1 3, 3 3, 3 1, 1 1)), ((0 0, 0 2, 2 2, 2 0, 0 0)))'", "'POLYGON ((0 1, 3 1, 3 3, 0 3, 0 1))'", false);
    }

    @Test
    public void testSTWithin() {
        this.assertRelation("ST_Within", "'POINT (50 100)'", "'POINT (150 150)'", false);
        this.assertRelation("ST_Within", "'POINT (50 100)'", "'MULTIPOINT (50 100, 50 200)'", true);
        this.assertRelation("ST_Within", "'LINESTRING (50 100, 50 200)'", "'LINESTRING (50 50, 50 250)'", true);
        this.assertRelation("ST_Within", "'MULTILINESTRING ((1 1, 5 1), (2 4, 4 4))'", "'MULTILINESTRING ((3 4, 6 4), (5 0, 5 4))'", false);
        this.assertRelation("ST_Within", "'POINT (3 2)'", "'POLYGON ((1 1, 1 4, 4 4, 4 1, 1 1))'", true);
        this.assertRelation("ST_Within", "'POLYGON ((1 1, 1 3, 3 3, 3 1, 1 1))'", "'POLYGON ((0 0, 0 4, 4 4, 4 0, 0 0))'", true);
        this.assertRelation("ST_Within", "'LINESTRING (1 1, 3 3)'", "'POLYGON ((0 0, 0 4, 4 4, 4 0, 0 0))'", true);
        this.assertRelation("ST_Within", "'MULTIPOLYGON (((1 1, 1 3, 3 3, 3 1, 1 1)), ((0 0, 0 2, 2 2, 2 0, 0 0)))'", "'POLYGON ((0 1, 3 1, 3 3, 0 3, 0 1))'", false);
        this.assertRelation("ST_Within", "'POLYGON ((1 1, 1 5, 5 5, 5 1, 1 1))'", "'POLYGON ((0 0, 0 4, 4 4, 4 0, 0 0))'", false);
    }

    @Test
    public void testContainsWithin() {
        for (int i = 0; i < RELATION_GEOMETRIES_WKT.size(); ++i) {
            for (int j = 0; j < RELATION_GEOMETRIES_WKT.size(); ++j) {
                boolean ok = i == j || CONTAINS_PAIRS.contains(Pair.of((Object)i, (Object)j));
                this.assertRelation("ST_Contains", RELATION_GEOMETRIES_WKT.get(i), RELATION_GEOMETRIES_WKT.get(j), ok);
                this.assertRelation("ST_Within", RELATION_GEOMETRIES_WKT.get(j), RELATION_GEOMETRIES_WKT.get(i), ok);
            }
        }
    }

    @Test
    public void testEquals() {
        this.testSymmetricRelations("ST_Equals", EQUALS_PAIRS);
    }

    @Test
    public void testTouches() {
        this.testSymmetricRelations("ST_Touches", TOUCHES_PAIRS);
    }

    @Test
    public void testOverlaps() {
        this.testSymmetricRelations("ST_Overlaps", OVERLAPS_PAIRS);
    }

    @Test
    public void testCrosses() {
        this.testSymmetricRelations("ST_Crosses", CROSSES_PAIRS);
    }

    private void testSymmetricRelations(String relation, List<Pair<Integer, Integer>> pairs) {
        for (int i = 0; i < RELATION_GEOMETRIES_WKT.size(); ++i) {
            for (int j = 0; j < RELATION_GEOMETRIES_WKT.size(); ++j) {
                boolean ok = pairs.contains(Pair.of((Object)i, (Object)j)) || pairs.contains(Pair.of((Object)j, (Object)i));
                this.assertRelation(relation, RELATION_GEOMETRIES_WKT.get(i), RELATION_GEOMETRIES_WKT.get(j), ok);
            }
        }
    }

    private void assertRelation(String relation, String leftWkt, String rightWkt, Boolean expected) {
        this.assertFunction(String.format("%s(ST_GeometryFromText(%s), ST_GeometryFromText(%s))", relation, leftWkt, rightWkt), (Type)BooleanType.BOOLEAN, expected);
    }
}

