/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.geospatial;

import com.facebook.presto.common.type.Type;
import com.facebook.presto.geospatial.type.GeometryType;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.ExpressionMatcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.RewriteSpatialPartitioningAggregation;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.planner.iterative.rule.test.RuleAssert;
import com.facebook.presto.sql.tree.FunctionCall;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.testng.annotations.Test;

public class TestRewriteSpatialPartitioningAggregation
extends BaseRuleTest {
    public TestRewriteSpatialPartitioningAggregation() {
        super(new Plugin[0]);
    }

    @Test
    public void testDoesNotFire() {
        this.assertRuleApplication().on(p -> p.aggregation(a -> a.globalGrouping().step(AggregationNode.Step.FINAL).source((PlanNode)p.values(p.variable("geometry", (Type)GeometryType.GEOMETRY))).addAggregation(p.variable("sp"), p.rowExpression("spatial_partitioning(geometry, 10)")))).doesNotFire();
    }

    @Test
    public void test() {
        this.assertRuleApplication().on(p -> p.aggregation(a -> a.globalGrouping().step(AggregationNode.Step.FINAL).source((PlanNode)p.values(p.variable("geometry", (Type)GeometryType.GEOMETRY))).addAggregation(p.variable("sp"), p.rowExpression("spatial_partitioning(geometry)")))).matches(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"sp", PlanMatchPattern.functionCall("spatial_partitioning", (List<String>)ImmutableList.of((Object)"envelope", (Object)"partition_count"))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"partition_count", (Object)PlanMatchPattern.expression("100"), (Object)"envelope", (Object)PlanMatchPattern.expression("ST_Envelope(geometry)")), PlanMatchPattern.values("geometry"))));
        this.assertRuleApplication().on(p -> p.aggregation(a -> a.globalGrouping().step(AggregationNode.Step.FINAL).source((PlanNode)p.values(p.variable("geometry", (Type)GeometryType.GEOMETRY))).addAggregation(p.variable("sp"), p.rowExpression("spatial_partitioning(ST_Envelope(geometry))")))).matches(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"sp", PlanMatchPattern.functionCall("spatial_partitioning", (List<String>)ImmutableList.of((Object)"envelope", (Object)"partition_count"))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"partition_count", (Object)PlanMatchPattern.expression("100"), (Object)"envelope", (Object)PlanMatchPattern.expression("ST_Envelope(geometry)")), PlanMatchPattern.values("geometry"))));
    }

    private RuleAssert assertRuleApplication() {
        return this.tester().assertThat((Rule)new RewriteSpatialPartitioningAggregation(this.tester().getMetadata()));
    }
}

