/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.geospatial;

import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.ogc.OGCGeometry;
import com.esri.core.geometry.ogc.OGCPoint;
import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.RunLengthEncodedBlock;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.geospatial.KdbTree;
import com.facebook.presto.geospatial.KdbTreeUtils;
import com.facebook.presto.geospatial.Rectangle;
import com.facebook.presto.geospatial.serde.EsriGeometrySerde;
import com.facebook.presto.geospatial.type.GeometryType;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.operator.UpdateMemory;
import com.facebook.presto.operator.aggregation.AccumulatorFactory;
import com.facebook.presto.operator.aggregation.AggregationTestUtils;
import com.facebook.presto.operator.aggregation.GenericAccumulatorFactory;
import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.JavaAggregationFunctionImplementation;
import com.facebook.presto.spi.function.aggregation.Accumulator;
import com.facebook.presto.spi.function.aggregation.GroupedAccumulator;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.google.common.collect.ImmutableList;
import com.google.common.math.DoubleMath;
import com.google.common.primitives.Ints;
import java.math.RoundingMode;
import java.util.List;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestSpatialPartitioningInternalAggregation
extends AbstractTestFunctions {
    @DataProvider(name="partitionCount")
    public static Object[][] partitionCountProvider() {
        return new Object[][]{{100}, {10}};
    }

    @Test(dataProvider="partitionCount")
    public void test(int partitionCount) {
        JavaAggregationFunctionImplementation function = this.getFunction();
        List<OGCGeometry> geometries = this.makeGeometries();
        Block geometryBlock = this.makeGeometryBlock(geometries);
        RunLengthEncodedBlock partitionCountBlock = BlockAssertions.createRLEBlock(partitionCount, geometries.size());
        String expectedValue = this.getSpatialPartitioning(geometries, partitionCount);
        AccumulatorFactory accumulatorFactory = GenericAccumulatorFactory.generateAccumulatorFactory((JavaAggregationFunctionImplementation)function, (List)Ints.asList((int[])new int[]{0, 1}), Optional.empty());
        Page page = new Page(new Block[]{geometryBlock, partitionCountBlock});
        Accumulator accumulator = accumulatorFactory.createAccumulator(UpdateMemory.NOOP);
        accumulator.addInput(page);
        String aggregation = (String)BlockAssertions.getOnlyValue(accumulator.getFinalType(), AggregationTestUtils.getFinalBlock(accumulator));
        Assert.assertEquals((String)aggregation, (String)expectedValue);
        GroupedAccumulator groupedAggregation = accumulatorFactory.createGroupedAccumulator(UpdateMemory.NOOP);
        groupedAggregation.addInput(AggregationTestUtils.createGroupByIdBlock(0, page.getPositionCount()), page);
        String groupValue = (String)AggregationTestUtils.getGroupValue(groupedAggregation, 0);
        Assert.assertEquals((String)groupValue, (String)expectedValue);
    }

    @Test
    public void testEmptyPartitionException() {
        JavaAggregationFunctionImplementation function = this.getFunction();
        Block geometryBlock = GeometryType.GEOMETRY.createBlockBuilder(null, 0).build();
        RunLengthEncodedBlock partitionCountBlock = BlockAssertions.createRLEBlock(10L, 0);
        Page page = new Page(new Block[]{geometryBlock, partitionCountBlock});
        AccumulatorFactory accumulatorFactory = GenericAccumulatorFactory.generateAccumulatorFactory((JavaAggregationFunctionImplementation)function, (List)Ints.asList((int[])new int[]{0, 1}), Optional.empty());
        Accumulator accumulator = accumulatorFactory.createAccumulator(UpdateMemory.NOOP);
        accumulator.addInput(page);
        try {
            AggregationTestUtils.getFinalBlock(accumulator);
            Assert.fail((String)"Should fail creating spatial partition with no rows.");
        }
        catch (PrestoException e) {
            Assert.assertEquals((Object)e.getErrorCode(), (Object)StandardErrorCode.INVALID_FUNCTION_ARGUMENT.toErrorCode());
            Assert.assertEquals((String)e.getMessage(), (String)"No rows supplied to spatial partition.");
        }
    }

    private JavaAggregationFunctionImplementation getFunction() {
        FunctionAndTypeManager functionAndTypeManager = this.functionAssertions.getMetadata().getFunctionAndTypeManager();
        return functionAndTypeManager.getJavaAggregateFunctionImplementation(functionAndTypeManager.lookupFunction("spatial_partitioning", TypeSignatureProvider.fromTypes((Type[])new Type[]{GeometryType.GEOMETRY, IntegerType.INTEGER})));
    }

    private List<OGCGeometry> makeGeometries() {
        int j;
        int i;
        ImmutableList.Builder geometries = ImmutableList.builder();
        for (i = 0; i < 10; ++i) {
            for (j = 0; j < 10; ++j) {
                geometries.add((Object)new OGCPoint(new Point((double)(-10 + i), (double)(-10 + j)), null));
            }
        }
        for (i = 0; i < 5; ++i) {
            for (j = 0; j < 5; ++j) {
                geometries.add((Object)new OGCPoint(new Point((double)(-10 + 2 * i), (double)(2 * j)), null));
            }
        }
        for (i = 0; i < 4; ++i) {
            for (j = 0; j < 4; ++j) {
                geometries.add((Object)new OGCPoint(new Point(2.5 * (double)i, -10.0 + 2.5 * (double)j), null));
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                geometries.add((Object)new OGCPoint(new Point((double)(5 * i), (double)(5 * j)), null));
            }
        }
        return geometries.build();
    }

    private Block makeGeometryBlock(List<OGCGeometry> geometries) {
        BlockBuilder builder = GeometryType.GEOMETRY.createBlockBuilder(null, geometries.size());
        for (OGCGeometry geometry : geometries) {
            GeometryType.GEOMETRY.writeSlice(builder, EsriGeometrySerde.serialize((OGCGeometry)geometry));
        }
        return builder.build();
    }

    private String getSpatialPartitioning(List<OGCGeometry> geometries, int partitionCount) {
        ImmutableList.Builder rectangles = ImmutableList.builder();
        for (OGCGeometry geometry : geometries) {
            Envelope envelope = new Envelope();
            geometry.getEsriGeometry().queryEnvelope(envelope);
            rectangles.add((Object)new Rectangle(envelope.getXMin(), envelope.getYMin(), envelope.getXMax(), envelope.getYMax()));
        }
        return KdbTreeUtils.toJson((KdbTree)KdbTree.buildKdbTree((int)DoubleMath.roundToInt((double)((double)geometries.size() * 1.0 / (double)partitionCount), (RoundingMode)RoundingMode.CEILING), (List)rectangles.build()));
    }
}

