/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.geospatial.aggregation;

import com.esri.core.geometry.ogc.OGCGeometry;
import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.geospatial.serde.EsriGeometrySerde;
import com.facebook.presto.geospatial.type.GeometryType;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.operator.aggregation.AggregationTestUtils;
import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import com.facebook.presto.spi.function.JavaAggregationFunctionImplementation;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import io.airlift.slice.Slice;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.testng.annotations.BeforeClass;

public abstract class AbstractTestGeoAggregationFunctions
extends AbstractTestFunctions {
    private JavaAggregationFunctionImplementation function;

    @BeforeClass
    public void registerFunctions() {
        FunctionAndTypeManager functionAndTypeManager = this.functionAssertions.getMetadata().getFunctionAndTypeManager();
        this.function = functionAndTypeManager.getJavaAggregateFunctionImplementation(functionAndTypeManager.lookupFunction(this.getFunctionName(), TypeSignatureProvider.fromTypes((Type[])new Type[]{GeometryType.GEOMETRY})));
    }

    protected void assertAggregatedGeometries(String testDescription, String expectedWkt, String ... wkts) {
        List<Slice> geometrySlices = Arrays.stream(wkts).map(text -> text == null ? null : OGCGeometry.fromText((String)text)).map(input -> input == null ? null : EsriGeometrySerde.serialize((OGCGeometry)input)).collect(Collectors.toList());
        BiFunction<Object, Object, Boolean> equalityFunction = (left, right) -> {
            OGCGeometry rightGeometry;
            if (left == null && right == null) {
                return true;
            }
            if (left == null || right == null) {
                return false;
            }
            OGCGeometry leftGeometry = OGCGeometry.fromText((String)left.toString());
            return leftGeometry.difference(rightGeometry = OGCGeometry.fromText((String)right.toString())).isEmpty() && rightGeometry.difference(leftGeometry).isEmpty();
        };
        AggregationTestUtils.assertAggregation(this.function, equalityFunction, testDescription, new Page(new Block[]{BlockAssertions.createSlicesBlock(geometrySlices)}), expectedWkt);
        Collections.reverse(geometrySlices);
        AggregationTestUtils.assertAggregation(this.function, equalityFunction, testDescription, new Page(new Block[]{BlockAssertions.createSlicesBlock(geometrySlices)}), expectedWkt);
    }

    protected abstract String getFunctionName();
}

