/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.geospatial.aggregation;

import com.esri.core.geometry.ogc.OGCGeometry;
import com.facebook.presto.geospatial.aggregation.GeometryState;
import com.facebook.presto.geospatial.aggregation.GeometryStateFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestGeometryStateFactory {
    private GeometryStateFactory factory = new GeometryStateFactory();

    @Test
    public void testCreateSingleStateEmpty() {
        GeometryState state = this.factory.createSingleState();
        Assert.assertNull((Object)state.getGeometry());
        Assert.assertEquals((long)0L, (long)state.getEstimatedSize());
    }

    @Test
    public void testCreateSingleStatePresent() {
        GeometryState state = this.factory.createSingleState();
        state.setGeometry(OGCGeometry.fromText((String)"POINT (1 2)"), 0L);
        Assert.assertEquals((Object)OGCGeometry.fromText((String)"POINT (1 2)"), (Object)state.getGeometry());
        Assert.assertTrue((state.getEstimatedSize() > 0L ? 1 : 0) != 0, (String)String.format("Estimated memory size was %d", state.getEstimatedSize()));
    }

    @Test
    public void testCreateGroupedStateEmpty() {
        GeometryState state = this.factory.createGroupedState();
        Assert.assertNull((Object)state.getGeometry());
        Assert.assertTrue((state.getEstimatedSize() > 0L ? 1 : 0) != 0, (String)String.format("Estimated memory size was %d", state.getEstimatedSize()));
    }

    @Test
    public void testCreateGroupedStatePresent() {
        GeometryState state = this.factory.createGroupedState();
        Assert.assertNull((Object)state.getGeometry());
        Assert.assertTrue((boolean)(state instanceof GeometryStateFactory.GroupedGeometryState));
        GeometryStateFactory.GroupedGeometryState groupedState = (GeometryStateFactory.GroupedGeometryState)state;
        groupedState.setGroupId(1L);
        Assert.assertNull((Object)state.getGeometry());
        groupedState.setGeometry(OGCGeometry.fromText((String)"POINT (1 2)"), 0L);
        Assert.assertEquals((Object)state.getGeometry(), (Object)OGCGeometry.fromText((String)"POINT (1 2)"));
        groupedState.setGroupId(2L);
        Assert.assertNull((Object)state.getGeometry());
        groupedState.setGeometry(OGCGeometry.fromText((String)"POINT (3 4)"), 0L);
        Assert.assertEquals((Object)state.getGeometry(), (Object)OGCGeometry.fromText((String)"POINT (3 4)"));
        groupedState.setGroupId(1L);
        Assert.assertNotNull((Object)state.getGeometry());
    }

    @Test
    public void testMemoryAccounting() {
        GeometryState state = this.factory.createGroupedState();
        long oldSize = state.getEstimatedSize();
        OGCGeometry geometry = OGCGeometry.fromText((String)"POLYGON ((2 2, 1 1, 3 1, 2 2))");
        long previousGeometryMemorySize = 0L;
        state.setGeometry(geometry, previousGeometryMemorySize);
        Assert.assertTrue((oldSize < state.getEstimatedSize() ? 1 : 0) != 0, (String)String.format("Expected old size %s to be less than new estimate %s", oldSize, state.getEstimatedSize()));
        oldSize = state.getEstimatedSize();
        previousGeometryMemorySize = state.getGeometry().estimateMemorySize();
        state.setGeometry(state.getGeometry().union(geometry), previousGeometryMemorySize);
        Assert.assertTrue((oldSize <= state.getEstimatedSize() ? 1 : 0) != 0, (String)String.format("Expected old size %s to be less than or equal to new estimate %s", oldSize, state.getEstimatedSize()));
    }
}

