/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.geospatial.aggregation;

import com.esri.core.geometry.ogc.OGCGeometry;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.geospatial.aggregation.GeometryState;
import com.facebook.presto.geospatial.aggregation.GeometryStateFactory;
import com.facebook.presto.geospatial.type.GeometryType;
import com.facebook.presto.operator.aggregation.state.StateCompiler;
import com.facebook.presto.spi.function.AccumulatorStateFactory;
import com.facebook.presto.spi.function.AccumulatorStateSerializer;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestGeometryStateSerializer {
    @Test
    public void testSerializeDeserialize() {
        AccumulatorStateFactory factory = StateCompiler.generateStateFactory(GeometryState.class);
        AccumulatorStateSerializer serializer = StateCompiler.generateStateSerializer(GeometryState.class);
        GeometryState state = (GeometryState)factory.createSingleState();
        state.setGeometry(OGCGeometry.fromText((String)"POINT (1 2)"), 0L);
        BlockBuilder builder = GeometryType.GEOMETRY.createBlockBuilder(null, 1);
        serializer.serialize((Object)state, builder);
        Block block = builder.build();
        Assert.assertEquals((Object)GeometryType.GEOMETRY.getObjectValue(null, block, 0), (Object)"POINT (1 2)");
        long previousMemorySize = state.getGeometry().estimateMemorySize();
        state.setGeometry(null, previousMemorySize);
        serializer.deserialize(block, 0, (Object)state);
        Assert.assertEquals((String)state.getGeometry().asText(), (String)"POINT (1 2)");
    }

    @Test
    public void testSerializeDeserializeGrouped() {
        AccumulatorStateFactory factory = StateCompiler.generateStateFactory(GeometryState.class);
        AccumulatorStateSerializer serializer = StateCompiler.generateStateSerializer(GeometryState.class);
        GeometryStateFactory.GroupedGeometryState state = (GeometryStateFactory.GroupedGeometryState)factory.createGroupedState();
        state.setGroupId(1L);
        state.setGeometry(OGCGeometry.fromText((String)"POINT (1 2)"), 0L);
        state.setGroupId(2L);
        state.setGeometry(OGCGeometry.fromText((String)"POINT (2 3)"), 0L);
        state.setGroupId(1L);
        BlockBuilder builder = GeometryType.GEOMETRY.createBlockBuilder(null, 1);
        serializer.serialize((Object)state, builder);
        Block block = builder.build();
        Assert.assertEquals((Object)GeometryType.GEOMETRY.getObjectValue(null, block, 0), (Object)"POINT (1 2)");
        long previousMemorySize = state.getGeometry().estimateMemorySize();
        state.setGeometry(null, previousMemorySize);
        serializer.deserialize(block, 0, (Object)state);
        Assert.assertEquals((String)state.getGeometry().asText(), (String)"POINT (1 2)");
        state.setGroupId(2L);
        Assert.assertEquals((String)state.getGeometry().asText(), (String)"POINT (2 3)");
        state.setGroupId(3L);
        Assert.assertNull((Object)state.getGeometry());
    }
}

