/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.memory;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.stats.CounterStat;
import com.facebook.airlift.stats.GcMonitor;
import com.facebook.airlift.stats.TestingGcMonitor;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.common.block.BlockEncodingManager;
import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.execution.SqlTask;
import com.facebook.presto.execution.SqlTaskExecutionFactory;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.execution.TaskManagerConfig;
import com.facebook.presto.execution.TaskState;
import com.facebook.presto.execution.TaskStateMachine;
import com.facebook.presto.execution.TaskTestUtils;
import com.facebook.presto.execution.TestSqlTaskManager;
import com.facebook.presto.execution.buffer.OutputBuffers;
import com.facebook.presto.execution.buffer.SpoolingOutputBufferFactory;
import com.facebook.presto.execution.executor.TaskExecutor;
import com.facebook.presto.execution.scheduler.TableWriteInfo;
import com.facebook.presto.memory.HighMemoryTaskKiller;
import com.facebook.presto.memory.MemoryPool;
import com.facebook.presto.memory.QueryContext;
import com.facebook.presto.operator.ExchangeClientSupplier;
import com.facebook.presto.operator.PipelineContext;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.operator.TaskMemoryReservationSummary;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.memory.MemoryPoolId;
import com.facebook.presto.spiller.SpillSpaceTracker;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.gen.OrderingCompiler;
import com.facebook.presto.sql.planner.LocalExecutionPlanner;
import com.facebook.presto.testing.TestingSession;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import io.airlift.units.DataSize;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHighMemoryTaskKiller {
    private final AtomicInteger nextTaskId = new AtomicInteger();
    private final TaskExecutor taskExecutor = new TaskExecutor(8, 16, 3, 4, TaskManagerConfig.TaskPriorityTracking.TASK_FAIR, Ticker.systemTicker());
    private final ScheduledExecutorService taskNotificationExecutor;
    private final ScheduledExecutorService driverYieldExecutor;
    private final SqlTaskExecutionFactory sqlTaskExecutionFactory;

    public TestHighMemoryTaskKiller() {
        this.taskExecutor.start();
        this.taskNotificationExecutor = Executors.newScheduledThreadPool(10, Threads.threadsNamed((String)"task-notification-%s"));
        this.driverYieldExecutor = Executors.newScheduledThreadPool(2, Threads.threadsNamed((String)"driver-yield-%s"));
        LocalExecutionPlanner planner = TaskTestUtils.createTestingPlanner();
        this.sqlTaskExecutionFactory = new SqlTaskExecutionFactory((Executor)this.taskNotificationExecutor, this.taskExecutor, planner, (BlockEncodingSerde)new BlockEncodingManager(), new OrderingCompiler(), TaskTestUtils.createTestSplitMonitor(), new TaskManagerConfig());
    }

    @Test
    public void testMaxMemoryConsumingQuery() throws Exception {
        QueryId highMemoryQueryId = new QueryId("query1");
        SqlTask highMemoryTask = this.createInitialTask(highMemoryQueryId);
        this.updateTaskMemory(highMemoryTask, 200L);
        QueryId lowMemoryQueryId = new QueryId("query2");
        SqlTask lowMemoryTask = this.createInitialTask(lowMemoryQueryId);
        this.updateTaskMemory(lowMemoryTask, 100L);
        ImmutableList activeTasks = ImmutableList.of((Object)highMemoryTask, (Object)lowMemoryTask);
        ListMultimap activeQueriesToTasksMap = (ListMultimap)activeTasks.stream().collect(ImmutableListMultimap.toImmutableListMultimap(task -> task.getQueryContext().getQueryId(), java.util.function.Function.identity()));
        Optional optionalQueryId = HighMemoryTaskKiller.getMaxMemoryConsumingQuery((ListMultimap)activeQueriesToTasksMap);
        Assert.assertTrue((boolean)optionalQueryId.isPresent());
        Assert.assertEquals(optionalQueryId.get(), (Object)highMemoryQueryId);
    }

    public void updateTaskMemory(SqlTask sqlTask, long systemMemory) {
        TaskInfo taskInfo = sqlTask.updateTask(SessionTestUtils.TEST_SESSION, Optional.of(TaskTestUtils.PLAN_FRAGMENT), (List)ImmutableList.of(), OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.PARTITIONED).withNoMoreBufferIds(), Optional.of(new TableWriteInfo(Optional.empty(), Optional.empty(), Optional.empty())));
        Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.RUNNING);
        TaskContext taskContext = (TaskContext)sqlTask.getTaskContext().get();
        PipelineContext pipelineContext = taskContext.addPipelineContext(0, true, true, false);
        pipelineContext.localSystemMemoryContext().setBytes(systemMemory);
    }

    public SqlTask createInitialTask(QueryId queryId) {
        TaskId taskId = new TaskId(queryId.getId(), 0, 0, this.nextTaskId.incrementAndGet(), 0);
        URI location = URI.create("fake://task/" + taskId);
        QueryContext queryContext = new QueryContext(queryId, new DataSize(1.0, DataSize.Unit.MEGABYTE), new DataSize(2.0, DataSize.Unit.MEGABYTE), new DataSize(1.0, DataSize.Unit.MEGABYTE), new DataSize(1.0, DataSize.Unit.GIGABYTE), new MemoryPool(new MemoryPoolId("test"), new DataSize(1.0, DataSize.Unit.GIGABYTE)), (GcMonitor)new TestingGcMonitor(), (Executor)this.taskNotificationExecutor, this.driverYieldExecutor, new DataSize(1.0, DataSize.Unit.MEGABYTE), new SpillSpaceTracker(new DataSize(1.0, DataSize.Unit.GIGABYTE)), JsonCodec.listJsonCodec(TaskMemoryReservationSummary.class));
        TaskContext taskContext = queryContext.addTaskContext(new TaskStateMachine(taskId, (Executor)this.taskNotificationExecutor), TestingSession.testSessionBuilder().build(), Optional.of(TaskTestUtils.PLAN_FRAGMENT.getRoot()), false, false, false, false, false);
        return SqlTask.createSqlTask((TaskId)taskId, (URI)location, (String)"fake", (QueryContext)queryContext, (SqlTaskExecutionFactory)this.sqlTaskExecutionFactory, (ExchangeClientSupplier)new TestSqlTaskManager.MockExchangeClientSupplier(), (ExecutorService)this.taskNotificationExecutor, (Function)Functions.identity(), (DataSize)new DataSize(32.0, DataSize.Unit.MEGABYTE), (CounterStat)new CounterStat(), (SpoolingOutputBufferFactory)new SpoolingOutputBufferFactory(new FeaturesConfig()));
    }
}

