/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.memory;

import com.facebook.presto.memory.context.LocalMemoryContext;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;

public class TestingMemoryContext
implements LocalMemoryContext {
    private long usedBytes;
    private final long maxBytes;

    public TestingMemoryContext(long maxBytes) {
        this.maxBytes = maxBytes;
        this.usedBytes = 0L;
    }

    public long getBytes() {
        return this.usedBytes;
    }

    public ListenableFuture<?> setBytes(long bytes) {
        this.usedBytes = bytes;
        return Futures.immediateFuture(null);
    }

    public ListenableFuture<?> setBytes(long bytes, boolean enforceBroadcastMemoryLimit) {
        return this.setBytes(bytes);
    }

    public boolean trySetBytes(long bytes) {
        if (this.usedBytes + bytes > this.maxBytes) {
            return false;
        }
        this.usedBytes += bytes;
        return true;
    }

    public boolean trySetBytes(long bytes, boolean enforceBroadcastMemoryLimit) {
        return this.trySetBytes(bytes);
    }

    public void close() {
    }
}

