/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.LongArrayBlock;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.SignatureBuilder;
import com.facebook.presto.metadata.SqlScalarFunction;
import com.facebook.presto.operator.scalar.BuiltInScalarFunctionImplementation;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementationChoice;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.TypeVariableConstraint;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestPolymorphicScalarFunction {
    private static final FunctionAndTypeManager FUNCTION_AND_TYPE_MANAGER = FunctionAndTypeManager.createTestFunctionAndTypeManager();
    private static final Signature SIGNATURE = SignatureBuilder.builder().name("foo").kind(FunctionKind.SCALAR).returnType(TypeSignature.parseTypeSignature((String)"bigint")).argumentTypes(new TypeSignature[]{TypeSignature.parseTypeSignature((String)"varchar(x)", (Set)ImmutableSet.of((Object)"x"))}).build();
    private static final long INPUT_VARCHAR_LENGTH = 10L;
    private static final String INPUT_VARCHAR_SIGNATURE = "varchar(10)";
    private static final TypeSignature INPUT_VARCHAR_TYPE = TypeSignature.parseTypeSignature((String)"varchar(10)");
    private static final Slice INPUT_SLICE = Slices.allocate((int)Math.toIntExact(10L));
    private static final BoundVariables BOUND_VARIABLES = new BoundVariables((Map)ImmutableMap.of((Object)"V", (Object)FUNCTION_AND_TYPE_MANAGER.getType(INPUT_VARCHAR_TYPE)), (Map)ImmutableMap.of((Object)"x", (Object)10L));
    private static final TypeSignature DECIMAL_SIGNATURE = TypeSignature.parseTypeSignature((String)"decimal(a_precision, a_scale)", (Set)ImmutableSet.of((Object)"a_precision", (Object)"a_scale"));
    private static final BoundVariables LONG_DECIMAL_BOUND_VARIABLES = new BoundVariables((Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"a_precision", (Object)19L, (Object)"a_scale", (Object)2L));
    private static final BoundVariables SHORT_DECIMAL_BOUND_VARIABLES = new BoundVariables((Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"a_precision", (Object)18L, (Object)"a_scale", (Object)2L));

    @Test
    public void testSelectsMultipleChoiceWithBlockPosition() throws Throwable {
        Signature signature = SignatureBuilder.builder().kind(FunctionKind.SCALAR).operatorType(OperatorType.IS_DISTINCT_FROM).argumentTypes(new TypeSignature[]{DECIMAL_SIGNATURE, DECIMAL_SIGNATURE}).returnType(TypeSignature.parseTypeSignature((String)"boolean")).build();
        SqlScalarFunction function = SqlScalarFunction.builder(TestMethods.class, (OperatorType)OperatorType.IS_DISTINCT_FROM).signature(signature).deterministic(true).choice(choice -> choice.argumentProperties(new ScalarFunctionImplementationChoice.ArgumentProperty[]{ScalarFunctionImplementationChoice.ArgumentProperty.valueTypeArgumentProperty((ScalarFunctionImplementationChoice.NullConvention)ScalarFunctionImplementationChoice.NullConvention.USE_NULL_FLAG), ScalarFunctionImplementationChoice.ArgumentProperty.valueTypeArgumentProperty((ScalarFunctionImplementationChoice.NullConvention)ScalarFunctionImplementationChoice.NullConvention.USE_NULL_FLAG)}).implementation(methodsGroup -> methodsGroup.methods(new String[]{"shortShort", "longLong"}))).choice(choice -> choice.argumentProperties(new ScalarFunctionImplementationChoice.ArgumentProperty[]{ScalarFunctionImplementationChoice.ArgumentProperty.valueTypeArgumentProperty((ScalarFunctionImplementationChoice.NullConvention)ScalarFunctionImplementationChoice.NullConvention.BLOCK_AND_POSITION), ScalarFunctionImplementationChoice.ArgumentProperty.valueTypeArgumentProperty((ScalarFunctionImplementationChoice.NullConvention)ScalarFunctionImplementationChoice.NullConvention.BLOCK_AND_POSITION)}).implementation(methodsGroup -> methodsGroup.methodWithExplicitJavaTypes("blockPositionLongLong", Arrays.asList(Optional.of(Slice.class), Optional.of(Slice.class))).methodWithExplicitJavaTypes("blockPositionShortShort", Arrays.asList(Optional.of(Long.TYPE), Optional.of(Long.TYPE))))).build();
        BuiltInScalarFunctionImplementation functionImplementation = function.specialize(SHORT_DECIMAL_BOUND_VARIABLES, 2, FUNCTION_AND_TYPE_MANAGER);
        Assert.assertEquals((int)functionImplementation.getAllChoices().size(), (int)2);
        Assert.assertEquals((Collection)((ScalarFunctionImplementationChoice)functionImplementation.getAllChoices().get(0)).getArgumentProperties(), Collections.nCopies(2, ScalarFunctionImplementationChoice.ArgumentProperty.valueTypeArgumentProperty((ScalarFunctionImplementationChoice.NullConvention)ScalarFunctionImplementationChoice.NullConvention.USE_NULL_FLAG)));
        Assert.assertEquals((Collection)((ScalarFunctionImplementationChoice)functionImplementation.getAllChoices().get(1)).getArgumentProperties(), Collections.nCopies(2, ScalarFunctionImplementationChoice.ArgumentProperty.valueTypeArgumentProperty((ScalarFunctionImplementationChoice.NullConvention)ScalarFunctionImplementationChoice.NullConvention.BLOCK_AND_POSITION)));
        LongArrayBlock block1 = new LongArrayBlock(0, Optional.empty(), new long[0]);
        LongArrayBlock block2 = new LongArrayBlock(0, Optional.empty(), new long[0]);
        Assert.assertFalse((boolean)((ScalarFunctionImplementationChoice)functionImplementation.getAllChoices().get(1)).getMethodHandle().invoke((Block)block1, 0, (Block)block2, 0));
        functionImplementation = function.specialize(LONG_DECIMAL_BOUND_VARIABLES, 2, FUNCTION_AND_TYPE_MANAGER);
        Assert.assertTrue((boolean)((ScalarFunctionImplementationChoice)functionImplementation.getAllChoices().get(1)).getMethodHandle().invoke((Block)block1, 0, (Block)block2, 0));
    }

    @Test
    public void testSelectsMethodBasedOnArgumentTypes() throws Throwable {
        SqlScalarFunction function = SqlScalarFunction.builder(TestMethods.class).signature(SIGNATURE).deterministic(true).calledOnNullInput(false).choice(choice -> choice.implementation(methodsGroup -> methodsGroup.methods(new String[]{"bigintToBigintReturnExtraParameter"})).implementation(methodsGroup -> methodsGroup.methods(new String[]{"varcharToBigintReturnExtraParameter"}).withExtraParameters(context -> ImmutableList.of((Object)context.getLiteral("x"))))).build();
        BuiltInScalarFunctionImplementation functionImplementation = function.specialize(BOUND_VARIABLES, 1, FUNCTION_AND_TYPE_MANAGER);
        Assert.assertEquals((Object)functionImplementation.getMethodHandle().invoke(INPUT_SLICE), (Object)10L);
    }

    @Test
    public void testSelectsMethodBasedOnReturnType() throws Throwable {
        SqlScalarFunction function = SqlScalarFunction.builder(TestMethods.class).signature(SIGNATURE).deterministic(true).calledOnNullInput(false).choice(choice -> choice.implementation(methodsGroup -> methodsGroup.methods(new String[]{"varcharToVarcharCreateSliceWithExtraParameterLength"})).implementation(methodsGroup -> methodsGroup.methods(new String[]{"varcharToBigintReturnExtraParameter"}).withExtraParameters(context -> ImmutableList.of((Object)42)))).build();
        BuiltInScalarFunctionImplementation functionImplementation = function.specialize(BOUND_VARIABLES, 1, FUNCTION_AND_TYPE_MANAGER);
        Assert.assertEquals((Object)functionImplementation.getMethodHandle().invoke(INPUT_SLICE), (Object)42L);
    }

    @Test
    public void testSameLiteralInArgumentsAndReturnValue() throws Throwable {
        Signature signature = SignatureBuilder.builder().name("foo").kind(FunctionKind.SCALAR).returnType(TypeSignature.parseTypeSignature((String)"varchar(x)", (Set)ImmutableSet.of((Object)"x"))).argumentTypes(new TypeSignature[]{TypeSignature.parseTypeSignature((String)"varchar(x)", (Set)ImmutableSet.of((Object)"x"))}).build();
        SqlScalarFunction function = SqlScalarFunction.builder(TestMethods.class).signature(signature).deterministic(true).calledOnNullInput(false).choice(choice -> choice.implementation(methodsGroup -> methodsGroup.methods(new String[]{"varcharToVarchar"}))).build();
        BuiltInScalarFunctionImplementation functionImplementation = function.specialize(BOUND_VARIABLES, 1, FUNCTION_AND_TYPE_MANAGER);
        Slice slice = functionImplementation.getMethodHandle().invoke(INPUT_SLICE);
        Assert.assertEquals((Object)slice, (Object)TestMethods.VARCHAR_TO_VARCHAR_RETURN_VALUE);
    }

    @Test
    public void testTypeParameters() throws Throwable {
        Signature signature = SignatureBuilder.builder().name("foo").kind(FunctionKind.SCALAR).typeVariableConstraints(new TypeVariableConstraint[]{Signature.comparableWithVariadicBound((String)"V", (String)"varchar")}).returnType(TypeSignature.parseTypeSignature((String)"V")).argumentTypes(new TypeSignature[]{TypeSignature.parseTypeSignature((String)"V")}).build();
        SqlScalarFunction function = SqlScalarFunction.builder(TestMethods.class).signature(signature).deterministic(true).calledOnNullInput(false).choice(choice -> choice.implementation(methodsGroup -> methodsGroup.methods(new String[]{"varcharToVarchar"}))).build();
        BuiltInScalarFunctionImplementation functionImplementation = function.specialize(BOUND_VARIABLES, 1, FUNCTION_AND_TYPE_MANAGER);
        Slice slice = functionImplementation.getMethodHandle().invoke(INPUT_SLICE);
        Assert.assertEquals((Object)slice, (Object)TestMethods.VARCHAR_TO_VARCHAR_RETURN_VALUE);
    }

    @Test
    public void testSetsHiddenToTrueForOperators() {
        Signature signature = SignatureBuilder.builder().operatorType(OperatorType.ADD).kind(FunctionKind.SCALAR).returnType(TypeSignature.parseTypeSignature((String)"varchar(x)", (Set)ImmutableSet.of((Object)"x"))).argumentTypes(new TypeSignature[]{TypeSignature.parseTypeSignature((String)"varchar(x)", (Set)ImmutableSet.of((Object)"x"))}).build();
        SqlScalarFunction function = SqlScalarFunction.builder(TestMethods.class, (OperatorType)OperatorType.ADD).signature(signature).deterministic(true).choice(choice -> choice.implementation(methodsGroup -> methodsGroup.methods(new String[]{"varcharToVarchar"}))).build();
        BuiltInScalarFunctionImplementation functionImplementation = function.specialize(BOUND_VARIABLES, 1, FUNCTION_AND_TYPE_MANAGER);
    }

    @Test(expectedExceptions={IllegalStateException.class}, expectedExceptionsMessageRegExp="method foo was not found in class com.facebook.presto.metadata.TestPolymorphicScalarFunction\\$TestMethods")
    public void testFailIfNotAllMethodsPresent() {
        SqlScalarFunction.builder(TestMethods.class).signature(SIGNATURE).deterministic(true).calledOnNullInput(false).choice(choice -> choice.implementation(methodsGroup -> methodsGroup.methods(new String[]{"bigintToBigintReturnExtraParameter"})).implementation(methodsGroup -> methodsGroup.methods(new String[]{"foo"}))).build();
    }

    @Test(expectedExceptions={IllegalStateException.class}, expectedExceptionsMessageRegExp="methods must be selected first")
    public void testFailNoMethodsAreSelectedWhenExtraParametersFunctionIsSet() {
        SqlScalarFunction.builder(TestMethods.class).signature(SIGNATURE).deterministic(true).calledOnNullInput(false).choice(choice -> choice.implementation(methodsGroup -> methodsGroup.withExtraParameters(context -> ImmutableList.of((Object)42)))).build();
    }

    @Test(expectedExceptions={IllegalStateException.class}, expectedExceptionsMessageRegExp="two matching methods \\(varcharToBigintReturnFirstExtraParameter and varcharToBigintReturnExtraParameter\\) for parameter types \\[varchar\\(10\\)\\]")
    public void testFailIfTwoMethodsWithSameArguments() {
        SqlScalarFunction function = SqlScalarFunction.builder(TestMethods.class).signature(SIGNATURE).deterministic(true).calledOnNullInput(false).choice(choice -> choice.implementation(methodsGroup -> methodsGroup.methods(new String[]{"varcharToBigintReturnFirstExtraParameter"})).implementation(methodsGroup -> methodsGroup.methods(new String[]{"varcharToBigintReturnExtraParameter"}))).build();
        function.specialize(BOUND_VARIABLES, 1, FUNCTION_AND_TYPE_MANAGER);
    }

    public static class TestMethods {
        static final Slice VARCHAR_TO_VARCHAR_RETURN_VALUE = Slices.utf8Slice((String)"hello world");
        static final long VARCHAR_TO_BIGINT_RETURN_VALUE = 42L;

        public static Slice varcharToVarchar(Slice varchar) {
            return VARCHAR_TO_VARCHAR_RETURN_VALUE;
        }

        public static long varcharToBigint(Slice varchar) {
            return 42L;
        }

        public static long varcharToBigintReturnExtraParameter(Slice varchar, long extraParameter) {
            return extraParameter;
        }

        public static long bigintToBigintReturnExtraParameter(long bigint, int extraParameter) {
            return bigint;
        }

        public static long varcharToBigintReturnFirstExtraParameter(Slice varchar, long extraParameter1, int extraParameter2) {
            return extraParameter1;
        }

        public static Slice varcharToVarcharCreateSliceWithExtraParameterLength(Slice string, int extraParameter) {
            return Slices.allocate((int)extraParameter);
        }

        public static boolean blockPositionLongLong(Block left, int leftPosition, Block right, int rightPosition) {
            return true;
        }

        public static boolean blockPositionShortShort(Block left, int leftPosition, Block right, int rightPosition) {
            return false;
        }

        public static boolean shortShort(long left, boolean leftNull, long right, boolean rightNull) {
            return false;
        }

        public static boolean longLong(Slice left, boolean leftNull, Slice right, boolean rightNull) {
            return false;
        }
    }
}

