/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.airlift.json.JsonModule;
import com.facebook.airlift.testing.Assertions;
import com.facebook.presto.connector.system.SystemTableHandle;
import com.facebook.presto.metadata.HandleJsonModule;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.SchemaTableName;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestSystemTableHandle {
    private static final ConnectorId CONNECTOR_ID = new ConnectorId("system_connector_id");
    private static final Map<String, Object> SCHEMA_AS_MAP = ImmutableMap.of((Object)"@type", (Object)"$system", (Object)"connectorId", (Object)CONNECTOR_ID.toString(), (Object)"schemaName", (Object)"system_schema", (Object)"tableName", (Object)"system_table");
    private ObjectMapper objectMapper;

    @BeforeMethod
    public void startUp() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new JsonModule(), new HandleJsonModule()});
        this.objectMapper = (ObjectMapper)injector.getInstance(ObjectMapper.class);
    }

    @Test
    public void testSystemSerialize() throws Exception {
        SystemTableHandle internalHandle = new SystemTableHandle(CONNECTOR_ID, "system_schema", "system_table");
        Assert.assertTrue((boolean)this.objectMapper.canSerialize(SystemTableHandle.class));
        String json = this.objectMapper.writeValueAsString((Object)internalHandle);
        this.testJsonEquals(json, SCHEMA_AS_MAP);
    }

    @Test
    public void testSystemDeserialize() throws Exception {
        String json = this.objectMapper.writeValueAsString(SCHEMA_AS_MAP);
        ConnectorTableHandle tableHandle = (ConnectorTableHandle)this.objectMapper.readValue(json, ConnectorTableHandle.class);
        Assert.assertEquals(tableHandle.getClass(), SystemTableHandle.class);
        SystemTableHandle systemHandle = (SystemTableHandle)tableHandle;
        Assert.assertEquals((Object)systemHandle.getConnectorId(), (Object)CONNECTOR_ID);
        Assert.assertEquals((Object)systemHandle.getSchemaTableName(), (Object)new SchemaTableName("system_schema", "system_table"));
    }

    private void testJsonEquals(String json, Map<String, Object> expectedMap) throws Exception {
        Map jsonMap = (Map)this.objectMapper.readValue(json, (TypeReference)new TypeReference<Map<String, Object>>(){});
        Assertions.assertEqualsIgnoreOrder(jsonMap.entrySet(), expectedMap.entrySet());
    }
}

