/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.metadata.TableLayoutResult;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.TestingColumnHandle;
import com.facebook.presto.testing.TestingConnectorSession;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestTableLayoutResult {
    @Test
    public void testComputeEnforced() {
        this.assertComputeEnforced((TupleDomain<ColumnHandle>)TupleDomain.all(), (TupleDomain<ColumnHandle>)TupleDomain.all(), (TupleDomain<ColumnHandle>)TupleDomain.all());
        this.assertComputeEnforcedFails((TupleDomain<ColumnHandle>)TupleDomain.all(), (TupleDomain<ColumnHandle>)TupleDomain.none());
        this.assertComputeEnforced((TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.all(), (TupleDomain<ColumnHandle>)TupleDomain.none());
        this.assertComputeEnforced((TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.all());
        this.assertComputeEnforced((TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new TestingColumnHandle("c1"), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L))), (TupleDomain<ColumnHandle>)TupleDomain.all(), (TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new TestingColumnHandle("c1"), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L))));
        this.assertComputeEnforced((TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new TestingColumnHandle("c1"), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L))), (TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new TestingColumnHandle("c1"), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L))), (TupleDomain<ColumnHandle>)TupleDomain.all());
        this.assertComputeEnforcedFails((TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new TestingColumnHandle("c1"), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L))), (TupleDomain<ColumnHandle>)TupleDomain.none());
        this.assertComputeEnforcedFails((TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new TestingColumnHandle("c1"), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L))), (TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new TestingColumnHandle("c1"), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)9999L))));
        this.assertComputeEnforcedFails((TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new TestingColumnHandle("c1"), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L))), (TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new TestingColumnHandle("c9999"), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L))));
        this.assertComputeEnforced((TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new TestingColumnHandle("c1"), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L), (Object)new TestingColumnHandle("c2"), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)2L))), (TupleDomain<ColumnHandle>)TupleDomain.all(), (TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new TestingColumnHandle("c1"), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L), (Object)new TestingColumnHandle("c2"), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)2L))));
        this.assertComputeEnforced((TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new TestingColumnHandle("c1"), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L), (Object)new TestingColumnHandle("c2"), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)2L))), (TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new TestingColumnHandle("c1"), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L))), (TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new TestingColumnHandle("c2"), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)2L))));
        this.assertComputeEnforced((TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new TestingColumnHandle("c1"), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L), (Object)new TestingColumnHandle("c2"), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)2L))), (TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new TestingColumnHandle("c2"), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)2L))), (TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new TestingColumnHandle("c1"), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L))));
        this.assertComputeEnforced((TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new TestingColumnHandle("c1"), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L), (Object)new TestingColumnHandle("c2"), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)2L))), (TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new TestingColumnHandle("c1"), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L), (Object)new TestingColumnHandle("c2"), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)2L))), (TupleDomain<ColumnHandle>)TupleDomain.all());
    }

    private void assertComputeEnforcedFails(TupleDomain<ColumnHandle> predicate, TupleDomain<ColumnHandle> unenforced) {
        try {
            TupleDomain enforced = TableLayoutResult.computeEnforced(predicate, unenforced);
            Assert.fail((String)String.format("expected IllegalArgumentException but found [%s]", enforced.toString(TestingConnectorSession.SESSION.getSqlFunctionProperties())));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void assertComputeEnforced(TupleDomain<ColumnHandle> predicate, TupleDomain<ColumnHandle> unenforced, TupleDomain<ColumnHandle> expectedEnforced) {
        TupleDomain enforced = TableLayoutResult.computeEnforced(predicate, unenforced);
        if (!enforced.equals(expectedEnforced)) {
            Assert.fail((String)String.format("expected [%s] but found [%s]", expectedEnforced.toString(TestingConnectorSession.SESSION.getSqlFunctionProperties()), enforced.toString(TestingConnectorSession.SESSION.getSqlFunctionProperties())));
        }
    }
}

