/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.airlift.concurrent.MoreFutures;
import com.facebook.airlift.concurrent.Threads;
import com.facebook.presto.RowPagesBuilder;
import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.execution.Lifespan;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.HashBuilderOperator;
import com.facebook.presto.operator.JoinBridgeManager;
import com.facebook.presto.operator.LookupJoinOperators;
import com.facebook.presto.operator.LookupSourceFactory;
import com.facebook.presto.operator.LookupSourceProvider;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.PagesIndex;
import com.facebook.presto.operator.PartitionedLookupSourceFactory;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spiller.PartitioningSpillerFactory;
import com.facebook.presto.spiller.SingleStreamSpillerFactory;
import com.facebook.presto.testing.TestingTaskContext;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.DataSize;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Random;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
@Fork(value=3)
@Warmup(iterations=5)
@Measurement(iterations=10, time=2, timeUnit=TimeUnit.SECONDS)
public class BenchmarkHashBuildAndJoinOperators {
    private static final int HASH_BUILD_OPERATOR_ID = 1;
    private static final int HASH_JOIN_OPERATOR_ID = 2;
    private static final PlanNodeId TEST_PLAN_NODE_ID = new PlanNodeId("test");
    private static final LookupJoinOperators LOOKUP_JOIN_OPERATORS = new LookupJoinOperators();

    @Benchmark
    public JoinBridgeManager<PartitionedLookupSourceFactory> benchmarkBuildHash(BuildContext buildContext) {
        return this.benchmarkBuildHash(buildContext, (List<Integer>)ImmutableList.of((Object)0, (Object)1, (Object)2));
    }

    private JoinBridgeManager<PartitionedLookupSourceFactory> benchmarkBuildHash(BuildContext buildContext, List<Integer> outputChannels) {
        DriverContext driverContext = buildContext.createTaskContext().addPipelineContext(0, true, true, false).addDriverContext();
        JoinBridgeManager lookupSourceFactoryManager = JoinBridgeManager.lookupAllAtOnce((PartitionedLookupSourceFactory)new PartitionedLookupSourceFactory(buildContext.getTypes(), (List)outputChannels.stream().map(buildContext.getTypes()::get).collect(ImmutableList.toImmutableList()), (List)buildContext.getHashChannels().stream().map(buildContext.getTypes()::get).collect(ImmutableList.toImmutableList()), 1, (Map)Objects.requireNonNull(ImmutableMap.of(), "layout is null"), false));
        HashBuilderOperator.HashBuilderOperatorFactory hashBuilderOperatorFactory = new HashBuilderOperator.HashBuilderOperatorFactory(1, TEST_PLAN_NODE_ID, lookupSourceFactoryManager, outputChannels, buildContext.getHashChannels(), buildContext.getHashChannel(), Optional.empty(), Optional.empty(), (List)ImmutableList.of(), 10000, (PagesIndex.Factory)new PagesIndex.TestingFactory(false), false, SingleStreamSpillerFactory.unsupportedSingleStreamSpillerFactory(), false);
        HashBuilderOperator operator = hashBuilderOperatorFactory.createOperator(driverContext);
        for (Page page : buildContext.getBuildPages()) {
            operator.addInput(page);
        }
        operator.finish();
        LookupSourceFactory lookupSourceFactory = (LookupSourceFactory)lookupSourceFactoryManager.getJoinBridge(Lifespan.taskWide());
        ListenableFuture lookupSourceProvider = lookupSourceFactory.createLookupSourceProvider();
        if (!lookupSourceProvider.isDone()) {
            throw new AssertionError((Object)"Expected lookup source provider to be ready");
        }
        ((LookupSourceProvider)MoreFutures.getFutureValue((Future)lookupSourceProvider)).close();
        return lookupSourceFactoryManager;
    }

    @Benchmark
    public List<Page> benchmarkJoinHash(JoinContext joinContext) {
        OperatorFactory joinOperatorFactory = LOOKUP_JOIN_OPERATORS.innerJoin(2, TEST_PLAN_NODE_ID, joinContext.getLookupSourceFactory(), joinContext.getTypes(), joinContext.getHashChannels(), joinContext.getHashChannel(), Optional.of(joinContext.getOutputChannels()), OptionalInt.empty(), PartitioningSpillerFactory.unsupportedPartitioningSpillerFactory(), false);
        DriverContext driverContext = joinContext.createTaskContext().addPipelineContext(0, true, true, false).addDriverContext();
        Operator joinOperator = joinOperatorFactory.createOperator(driverContext);
        Iterator<Page> input = joinContext.getProbePages().iterator();
        ImmutableList.Builder outputPages = ImmutableList.builder();
        boolean finishing = false;
        for (int loops = 0; !joinOperator.isFinished() && loops < 1000000; ++loops) {
            Page outputPage;
            if (joinOperator.needsInput()) {
                if (input.hasNext()) {
                    Page inputPage = input.next();
                    joinOperator.addInput(inputPage);
                } else if (!finishing) {
                    joinOperator.finish();
                    finishing = true;
                }
            }
            if ((outputPage = joinOperator.getOutput()) == null) continue;
            outputPages.add((Object)outputPage);
        }
        return outputPages.build();
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + BenchmarkHashBuildAndJoinOperators.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }

    @State(value=Scope.Thread)
    public static class JoinContext
    extends BuildContext {
        protected static final int PROBE_ROWS_NUMBER = 1400000;
        @Param(value={"0.1", "1", "2"})
        protected double matchRate = 1.0;
        @Param(value={"bigint", "all"})
        protected String outputColumns = "bigint";
        protected List<Page> probePages;
        protected List<Integer> outputChannels;
        protected JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactory;

        @Override
        @Setup
        public void setup() {
            super.setup();
            switch (this.outputColumns) {
                case "varchar": {
                    this.outputChannels = Ints.asList((int[])new int[]{0});
                    break;
                }
                case "bigint": {
                    this.outputChannels = Ints.asList((int[])new int[]{1});
                    break;
                }
                case "all": {
                    this.outputChannels = Ints.asList((int[])new int[]{0, 1, 2});
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(String.format("Unknown outputColumns value [%s]", this.hashColumns));
                }
            }
            this.lookupSourceFactory = new BenchmarkHashBuildAndJoinOperators().benchmarkBuildHash(this, this.outputChannels);
            this.initializeProbePages();
        }

        public JoinBridgeManager<PartitionedLookupSourceFactory> getLookupSourceFactory() {
            return this.lookupSourceFactory;
        }

        public List<Page> getProbePages() {
            return this.probePages;
        }

        public List<Integer> getOutputChannels() {
            return this.outputChannels;
        }

        protected void initializeProbePages() {
            RowPagesBuilder probePagesBuilder = RowPagesBuilder.rowPagesBuilder(this.buildHashEnabled, (List<Integer>)this.hashChannels, (Iterable<Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT));
            Random random = new Random(42L);
            int remainingRows = 1400000;
            int rowsInPage = 0;
            while (remainingRows > 0) {
                double roll = random.nextDouble();
                int columnA = 20 + remainingRows;
                int columnB = 30 + remainingRows;
                int columnC = 40 + remainingRows;
                int rowsCount = 1;
                if (this.matchRate < 1.0) {
                    if (roll > this.matchRate) {
                        columnA *= -1;
                        columnB *= -1;
                        columnC *= -1;
                    }
                } else if (this.matchRate > 1.0) {
                    roll = roll * 2.0 * this.matchRate + 1.0;
                    rowsCount = (int)Math.floor(roll);
                }
                for (int i = 0; i < rowsCount; ++i) {
                    if (rowsInPage >= 1024) {
                        probePagesBuilder.pageBreak();
                        rowsInPage = 0;
                    }
                    probePagesBuilder.row(String.format("%d", columnA), columnB, columnC);
                    --remainingRows;
                    ++rowsInPage;
                }
            }
            this.probePages = probePagesBuilder.build();
        }
    }

    @State(value=Scope.Thread)
    public static class BuildContext {
        protected static final int ROWS_PER_PAGE = 1024;
        protected static final int BUILD_ROWS_NUMBER = 8000000;
        @Param(value={"varchar", "bigint", "all"})
        protected String hashColumns = "bigint";
        @Param(value={"false", "true"})
        protected boolean buildHashEnabled;
        @Param(value={"1", "5"})
        protected int buildRowsRepetition = 1;
        protected ExecutorService executor;
        protected ScheduledExecutorService scheduledExecutor;
        protected List<Page> buildPages;
        protected OptionalInt hashChannel;
        protected List<Type> types;
        protected List<Integer> hashChannels;

        @Setup
        public void setup() {
            switch (this.hashColumns) {
                case "varchar": {
                    this.hashChannels = Ints.asList((int[])new int[]{0});
                    break;
                }
                case "bigint": {
                    this.hashChannels = Ints.asList((int[])new int[]{1});
                    break;
                }
                case "all": {
                    this.hashChannels = Ints.asList((int[])new int[]{0, 1, 2});
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(String.format("Unknown hashColumns value [%s]", this.hashColumns));
                }
            }
            this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test-executor-%s"));
            this.scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)"test-scheduledExecutor-%s"));
            this.initializeBuildPages();
        }

        public TaskContext createTaskContext() {
            return TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION, (DataSize)new DataSize(2.0, DataSize.Unit.GIGABYTE));
        }

        public OptionalInt getHashChannel() {
            return this.hashChannel;
        }

        public List<Integer> getHashChannels() {
            return this.hashChannels;
        }

        public List<Type> getTypes() {
            return this.types;
        }

        public List<Page> getBuildPages() {
            return this.buildPages;
        }

        protected void initializeBuildPages() {
            int newRows;
            RowPagesBuilder buildPagesBuilder = RowPagesBuilder.rowPagesBuilder(this.buildHashEnabled, this.hashChannels, (Iterable<Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT));
            int maxValue = 8000000 / this.buildRowsRepetition + 40;
            for (int rows = 0; rows < 8000000; rows += newRows) {
                newRows = Math.min(8000000 - rows, 1024);
                buildPagesBuilder.addSequencePage(newRows, (rows + 20) % maxValue, (rows + 30) % maxValue, (rows + 40) % maxValue);
                buildPagesBuilder.pageBreak();
            }
            this.types = buildPagesBuilder.getTypes();
            this.buildPages = buildPagesBuilder.build();
            this.hashChannel = buildPagesBuilder.getHashChannel().map(OptionalInt::of).orElse(OptionalInt.empty());
        }
    }
}

