/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.stats.GcMonitor;
import com.facebook.airlift.stats.TestingGcMonitor;
import com.facebook.airlift.testing.Assertions;
import com.facebook.presto.RowPagesBuilder;
import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.memory.MemoryPool;
import com.facebook.presto.memory.QueryContext;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorAssertion;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.TaskMemoryReservationSummary;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.memory.MemoryPoolId;
import com.facebook.presto.spiller.SpillSpaceTracker;
import com.facebook.presto.testing.TestingTaskContext;
import com.facebook.presto.testing.assertions.Assert;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;

public final class GroupByHashYieldAssertion {
    private static final ExecutorService EXECUTOR = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test-executor-%s"));
    private static final ScheduledExecutorService SCHEDULED_EXECUTOR = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)"test-scheduledExecutor-%s"));

    private GroupByHashYieldAssertion() {
    }

    public static List<Page> createPagesWithDistinctHashKeys(Type type, int pageCount, int positionCountPerPage) {
        RowPagesBuilder rowPagesBuilder = RowPagesBuilder.rowPagesBuilder(true, (List<Integer>)ImmutableList.of((Object)0), type);
        for (int i = 0; i < pageCount; ++i) {
            rowPagesBuilder.addSequencePage(positionCountPerPage, positionCountPerPage * i);
        }
        return rowPagesBuilder.build();
    }

    public static GroupByHashYieldResult finishOperatorWithYieldingGroupByHash(List<Page> input, Type hashKeyType, OperatorFactory operatorFactory, Function<Operator, Integer> getHashCapacity, long additionalMemoryInBytes) {
        Assertions.assertLessThan((Comparable)Long.valueOf(additionalMemoryInBytes), (Comparable)Long.valueOf(0x200000L), (String)"additionalMemoryInBytes should be a relatively small number");
        LinkedList<Page> result = new LinkedList<Page>();
        QueryId queryId1 = new QueryId("test_query1");
        QueryId queryId2 = new QueryId("test_query2");
        MemoryPool memoryPool = new MemoryPool(new MemoryPoolId("test"), new DataSize(1.0, DataSize.Unit.GIGABYTE));
        QueryContext queryContext = new QueryContext(queryId2, new DataSize(512.0, DataSize.Unit.MEGABYTE), new DataSize(1024.0, DataSize.Unit.MEGABYTE), new DataSize(512.0, DataSize.Unit.MEGABYTE), new DataSize(1.0, DataSize.Unit.GIGABYTE), memoryPool, (GcMonitor)new TestingGcMonitor(), (Executor)EXECUTOR, SCHEDULED_EXECUTOR, new DataSize(512.0, DataSize.Unit.MEGABYTE), new SpillSpaceTracker(new DataSize(512.0, DataSize.Unit.MEGABYTE)), JsonCodec.listJsonCodec(TaskMemoryReservationSummary.class));
        DriverContext driverContext = TestingTaskContext.createTaskContext((QueryContext)queryContext, (Executor)EXECUTOR, (Session)SessionTestUtils.TEST_SESSION).addPipelineContext(0, true, true, false).addDriverContext();
        Operator operator = operatorFactory.createOperator(driverContext);
        int yieldCount = 0;
        long expectedReservedExtraBytes = 0L;
        for (Page page : input) {
            long newMemoryUsage;
            org.testng.Assert.assertTrue((boolean)operator.needsInput());
            long reservedMemoryInBytes = memoryPool.getFreeBytes() - additionalMemoryInBytes;
            memoryPool.reserve(queryId1, "test", reservedMemoryInBytes);
            long oldMemoryUsage = operator.getOperatorContext().getDriverContext().getMemoryUsage();
            int oldCapacity = getHashCapacity.apply(operator);
            operator.addInput(page);
            Page output = operator.getOutput();
            if (output != null) {
                result.add(output);
            }
            if ((newMemoryUsage = operator.getOperatorContext().getDriverContext().getMemoryUsage()) < new DataSize(3.0, DataSize.Unit.MEGABYTE).toBytes()) {
                memoryPool.free(queryId1, "test", reservedMemoryInBytes);
                operator.getOutput();
                continue;
            }
            long actualIncreasedMemory = newMemoryUsage - oldMemoryUsage;
            if (operator.needsInput()) {
                org.testng.Assert.assertTrue((boolean)operator.getOperatorContext().isWaitingForMemory().isDone());
                org.testng.Assert.assertTrue((oldCapacity == getHashCapacity.apply(operator) ? 1 : 0) != 0);
                Assertions.assertLessThan((Comparable)Long.valueOf(actualIncreasedMemory), (Comparable)Long.valueOf(additionalMemoryInBytes));
                memoryPool.free(queryId1, "test", reservedMemoryInBytes);
                continue;
            }
            ++yieldCount;
            org.testng.Assert.assertFalse((boolean)operator.getOperatorContext().isWaitingForMemory().isDone());
            Assert.assertEquals((long)oldCapacity, (long)getHashCapacity.apply(operator).intValue());
            expectedReservedExtraBytes = GroupByHashYieldAssertion.getHashTableSizeInBytes(hashKeyType, oldCapacity * 2) + page.getRetainedSizeInBytes();
            Assertions.assertBetweenInclusive((Comparable)Long.valueOf(actualIncreasedMemory), (Comparable)Long.valueOf(expectedReservedExtraBytes), (Comparable)Long.valueOf(2L * expectedReservedExtraBytes + additionalMemoryInBytes));
            org.testng.Assert.assertNull((Object)operator.getOutput());
            memoryPool.free(queryId1, "test", reservedMemoryInBytes);
            output = operator.getOutput();
            if (output != null) {
                result.add(output);
            }
            org.testng.Assert.assertTrue((boolean)operator.needsInput());
            Assertions.assertGreaterThan((Comparable)getHashCapacity.apply(operator), (Comparable)Integer.valueOf(oldCapacity));
            long rehashedMemoryUsage = operator.getOperatorContext().getDriverContext().getMemoryUsage();
            long previousHashTableSizeInBytes = GroupByHashYieldAssertion.getHashTableSizeInBytes(hashKeyType, oldCapacity);
            long expectedMemoryUsageAfterRehash = newMemoryUsage - previousHashTableSizeInBytes;
            double memoryUsageErrorUpperBound = 1.02;
            double memoryUsageError = (double)rehashedMemoryUsage * 1.0 / (double)expectedMemoryUsageAfterRehash;
            Assertions.assertBetweenInclusive((Comparable)Double.valueOf(memoryUsageError), (Comparable)Double.valueOf(0.98), (Comparable)Double.valueOf(memoryUsageErrorUpperBound));
            org.testng.Assert.assertTrue((boolean)operator.needsInput());
        }
        result.addAll(OperatorAssertion.finishOperator(operator));
        return new GroupByHashYieldResult(yieldCount, expectedReservedExtraBytes, result);
    }

    private static long getHashTableSizeInBytes(Type hashKeyType, int capacity) {
        if (hashKeyType == BigintType.BIGINT) {
            return (long)capacity * 18L;
        }
        return (long)capacity * 19L;
    }

    public static final class GroupByHashYieldResult {
        private final int yieldCount;
        private final long maxReservedBytes;
        private final List<Page> output;

        public GroupByHashYieldResult(int yieldCount, long maxReservedBytes, List<Page> output) {
            this.yieldCount = yieldCount;
            this.maxReservedBytes = maxReservedBytes;
            this.output = Objects.requireNonNull(output, "output is null");
        }

        public int getYieldCount() {
            return this.yieldCount;
        }

        public long getMaxReservedBytes() {
            return this.maxReservedBytes;
        }

        public List<Page> getOutput() {
            return this.output;
        }
    }
}

