/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.TypeSignatureParameter;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.BuiltInTypeAndFunctionNamespaceManager;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.operator.ParametricImplementationsGroup;
import com.facebook.presto.operator.TestAnnotationEngine;
import com.facebook.presto.operator.aggregation.AggregationFromAnnotationsParser;
import com.facebook.presto.operator.aggregation.AggregationImplementation;
import com.facebook.presto.operator.aggregation.BuiltInAggregationFunctionImplementation;
import com.facebook.presto.operator.aggregation.ParametricAggregation;
import com.facebook.presto.operator.aggregation.state.NullableDoubleState;
import com.facebook.presto.operator.aggregation.state.NullableDoubleStateSerializer;
import com.facebook.presto.operator.aggregation.state.NullableLongState;
import com.facebook.presto.operator.aggregation.state.SliceState;
import com.facebook.presto.operator.annotations.LiteralImplementationDependency;
import com.facebook.presto.operator.annotations.OperatorImplementationDependency;
import com.facebook.presto.operator.annotations.TypeImplementationDependency;
import com.facebook.presto.spi.function.AccumulatorStateSerializer;
import com.facebook.presto.spi.function.AggregationFunction;
import com.facebook.presto.spi.function.AggregationState;
import com.facebook.presto.spi.function.AggregationStateSerializerFactory;
import com.facebook.presto.spi.function.BlockIndex;
import com.facebook.presto.spi.function.BlockPosition;
import com.facebook.presto.spi.function.CombineFunction;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.spi.function.InputFunction;
import com.facebook.presto.spi.function.LiteralParameters;
import com.facebook.presto.spi.function.LongVariableConstraint;
import com.facebook.presto.spi.function.OperatorDependency;
import com.facebook.presto.spi.function.OutputFunction;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import com.facebook.presto.spi.function.TypeParameterSpecialization;
import com.facebook.presto.spi.function.TypeParameters;
import com.facebook.presto.spi.function.aggregation.AggregationMetadata;
import com.facebook.presto.type.Constraint;
import com.facebook.presto.type.LiteralParameter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.TypeDescriptor;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestAnnotationEngineForAggregates
extends TestAnnotationEngine {
    private static final FunctionAndTypeManager FUNCTION_AND_TYPE_MANAGER = FunctionAndTypeManager.createTestFunctionAndTypeManager();

    @Test
    public void testSimpleExactAggregationParse() {
        Signature expectedSignature = new Signature(QualifiedObjectName.valueOf((CatalogSchemaName)BuiltInTypeAndFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"simple_exact_aggregate"), FunctionKind.AGGREGATE, DoubleType.DOUBLE.getTypeSignature(), (List)ImmutableList.of((Object)DoubleType.DOUBLE.getTypeSignature()));
        ParametricAggregation aggregation = AggregationFromAnnotationsParser.parseFunctionDefinition(ExactAggregationFunction.class);
        Assert.assertEquals((String)aggregation.getDescription(), (String)"Simple exact aggregate description");
        Assert.assertTrue((boolean)aggregation.isDeterministic());
        Assert.assertEquals((Object)aggregation.getSignature(), (Object)expectedSignature);
        ParametricImplementationsGroup implementations = aggregation.getImplementations();
        this.assertImplementationCount(implementations, 1, 0, 0);
        AggregationImplementation implementation = (AggregationImplementation)Iterables.getOnlyElement(implementations.getExactImplementations().values());
        Assert.assertFalse((boolean)implementation.getStateSerializerFactory().isPresent());
        Assert.assertEquals((Object)implementation.getDefinitionClass(), ExactAggregationFunction.class);
        this.assertDependencyCount(implementation, 0, 0, 0);
        Assert.assertFalse((boolean)implementation.hasSpecializedTypeParameters());
        ImmutableList expectedMetadataTypes = ImmutableList.of((Object)AggregationMetadata.ParameterMetadata.ParameterType.STATE, (Object)AggregationMetadata.ParameterMetadata.ParameterType.INPUT_CHANNEL);
        Assert.assertTrue((boolean)implementation.getInputParameterMetadataTypes().equals(expectedMetadataTypes));
        BuiltInAggregationFunctionImplementation specialized = aggregation.specialize(BoundVariables.builder().build(), 1, FUNCTION_AND_TYPE_MANAGER);
        Assert.assertEquals((Object)specialized.getFinalType(), (Object)DoubleType.DOUBLE);
        Assert.assertTrue((boolean)specialized.isDecomposable());
        Assert.assertEquals((String)specialized.name(), (String)"simple_exact_aggregate");
    }

    @Test
    public void testStateOnDifferentThanFirstPositionAggregationParse() {
        Signature expectedSignature = new Signature(QualifiedObjectName.valueOf((CatalogSchemaName)BuiltInTypeAndFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"simple_exact_aggregate_aggregation_state_moved"), FunctionKind.AGGREGATE, DoubleType.DOUBLE.getTypeSignature(), (List)ImmutableList.of((Object)DoubleType.DOUBLE.getTypeSignature()));
        ParametricAggregation aggregation = AggregationFromAnnotationsParser.parseFunctionDefinition(StateOnDifferentThanFirstPositionAggregationFunction.class);
        Assert.assertEquals((Object)aggregation.getSignature(), (Object)expectedSignature);
        AggregationImplementation implementation = (AggregationImplementation)Iterables.getOnlyElement(aggregation.getImplementations().getExactImplementations().values());
        Assert.assertEquals((Object)implementation.getDefinitionClass(), StateOnDifferentThanFirstPositionAggregationFunction.class);
        ImmutableList expectedMetadataTypes = ImmutableList.of((Object)AggregationMetadata.ParameterMetadata.ParameterType.INPUT_CHANNEL, (Object)AggregationMetadata.ParameterMetadata.ParameterType.STATE);
        Assert.assertTrue((boolean)implementation.getInputParameterMetadataTypes().equals(expectedMetadataTypes));
    }

    @Test
    public void testNotAnnotatedAggregateStateAggregationParse() {
        ParametricAggregation aggregation = AggregationFromAnnotationsParser.parseFunctionDefinition(NotAnnotatedAggregateStateAggregationFunction.class);
        AggregationImplementation implementation = (AggregationImplementation)Iterables.getOnlyElement(aggregation.getImplementations().getExactImplementations().values());
        ImmutableList expectedMetadataTypes = ImmutableList.of((Object)AggregationMetadata.ParameterMetadata.ParameterType.STATE, (Object)AggregationMetadata.ParameterMetadata.ParameterType.INPUT_CHANNEL);
        Assert.assertTrue((boolean)implementation.getInputParameterMetadataTypes().equals(expectedMetadataTypes));
        BuiltInAggregationFunctionImplementation specialized = aggregation.specialize(BoundVariables.builder().build(), 1, FUNCTION_AND_TYPE_MANAGER);
        Assert.assertEquals((Object)specialized.getFinalType(), (Object)DoubleType.DOUBLE);
        Assert.assertTrue((boolean)specialized.isDecomposable());
        Assert.assertEquals((String)specialized.name(), (String)"no_aggregation_state_aggregate");
    }

    @Test
    public void testCustomStateSerializerAggregationParse() {
        ParametricAggregation aggregation = AggregationFromAnnotationsParser.parseFunctionDefinition(CustomStateSerializerAggregationFunction.class);
        AggregationImplementation implementation = (AggregationImplementation)Iterables.getOnlyElement(aggregation.getImplementations().getExactImplementations().values());
        Assert.assertTrue((boolean)implementation.getStateSerializerFactory().isPresent());
        BuiltInAggregationFunctionImplementation specialized = aggregation.specialize(BoundVariables.builder().build(), 1, FUNCTION_AND_TYPE_MANAGER);
        AccumulatorStateSerializer createdSerializer = ((AggregationMetadata.AccumulatorStateDescriptor)Iterables.getOnlyElement((Iterable)specialized.getAggregationMetadata().getAccumulatorStateDescriptors())).getSerializer();
        TypeDescriptor.OfField serializerFactory = ((MethodHandle)implementation.getStateSerializerFactory().get()).type().returnType();
        Assert.assertTrue((boolean)((Class)serializerFactory).isInstance(createdSerializer));
    }

    @Test
    public void testNotDecomposableAggregationParse() {
        Signature expectedSignature = new Signature(QualifiedObjectName.valueOf((CatalogSchemaName)BuiltInTypeAndFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"custom_decomposable_aggregate"), FunctionKind.AGGREGATE, DoubleType.DOUBLE.getTypeSignature(), (List)ImmutableList.of((Object)DoubleType.DOUBLE.getTypeSignature()));
        ParametricAggregation aggregation = AggregationFromAnnotationsParser.parseFunctionDefinition(NotDecomposableAggregationFunction.class);
        Assert.assertEquals((String)aggregation.getDescription(), (String)"Aggregate with Decomposable=false");
        Assert.assertTrue((boolean)aggregation.isDeterministic());
        Assert.assertEquals((Object)aggregation.getSignature(), (Object)expectedSignature);
        BuiltInAggregationFunctionImplementation specialized = aggregation.specialize(BoundVariables.builder().build(), 1, FUNCTION_AND_TYPE_MANAGER);
        Assert.assertEquals((Object)specialized.getFinalType(), (Object)DoubleType.DOUBLE);
        Assert.assertFalse((boolean)specialized.isDecomposable());
        Assert.assertEquals((String)specialized.name(), (String)"custom_decomposable_aggregate");
    }

    @Test
    public void testSimpleGenericAggregationFunctionParse() {
        Signature expectedSignature = new Signature(QualifiedObjectName.valueOf((CatalogSchemaName)BuiltInTypeAndFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"simple_generic_implementations"), FunctionKind.AGGREGATE, (List)ImmutableList.of((Object)Signature.typeVariable((String)"T")), (List)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"T"), (List)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"T")), false);
        ParametricAggregation aggregation = AggregationFromAnnotationsParser.parseFunctionDefinition(GenericAggregationFunction.class);
        Assert.assertEquals((String)aggregation.getDescription(), (String)"Simple aggregate with two generic implementations");
        Assert.assertTrue((boolean)aggregation.isDeterministic());
        Assert.assertEquals((Object)aggregation.getSignature(), (Object)expectedSignature);
        ParametricImplementationsGroup implementations = aggregation.getImplementations();
        this.assertImplementationCount(implementations, 0, 0, 2);
        AggregationImplementation implementationDouble = (AggregationImplementation)((ImmutableList)implementations.getGenericImplementations().stream().filter(impl -> impl.getStateClass() == NullableDoubleState.class).collect(ImmutableList.toImmutableList())).get(0);
        Assert.assertFalse((boolean)implementationDouble.getStateSerializerFactory().isPresent());
        Assert.assertEquals((Object)implementationDouble.getDefinitionClass(), GenericAggregationFunction.class);
        this.assertDependencyCount(implementationDouble, 0, 0, 0);
        Assert.assertFalse((boolean)implementationDouble.hasSpecializedTypeParameters());
        ImmutableList expectedMetadataTypes = ImmutableList.of((Object)AggregationMetadata.ParameterMetadata.ParameterType.STATE, (Object)AggregationMetadata.ParameterMetadata.ParameterType.INPUT_CHANNEL);
        Assert.assertTrue((boolean)implementationDouble.getInputParameterMetadataTypes().equals(expectedMetadataTypes));
        Assert.assertEquals((Object)implementationDouble.getStateClass(), NullableDoubleState.class);
        AggregationImplementation implementationLong = (AggregationImplementation)((ImmutableList)implementations.getGenericImplementations().stream().filter(impl -> impl.getStateClass() == NullableLongState.class).collect(ImmutableList.toImmutableList())).get(0);
        Assert.assertFalse((boolean)implementationLong.getStateSerializerFactory().isPresent());
        Assert.assertEquals((Object)implementationLong.getDefinitionClass(), GenericAggregationFunction.class);
        this.assertDependencyCount(implementationLong, 0, 0, 0);
        Assert.assertFalse((boolean)implementationLong.hasSpecializedTypeParameters());
        Assert.assertTrue((boolean)implementationLong.getInputParameterMetadataTypes().equals(expectedMetadataTypes));
        Assert.assertEquals((Object)implementationLong.getStateClass(), NullableLongState.class);
        BuiltInAggregationFunctionImplementation specialized = aggregation.specialize(BoundVariables.builder().setTypeVariable("T", (Type)DoubleType.DOUBLE).build(), 1, FUNCTION_AND_TYPE_MANAGER);
        Assert.assertEquals((Object)specialized.getFinalType(), (Object)DoubleType.DOUBLE);
        Assert.assertTrue((boolean)specialized.getParameterTypes().equals(ImmutableList.of((Object)DoubleType.DOUBLE)));
        Assert.assertTrue((boolean)specialized.isDecomposable());
        Assert.assertEquals((String)specialized.name(), (String)"simple_generic_implementations");
    }

    @Test
    public void testSimpleBlockInputAggregationParse() {
        Signature expectedSignature = new Signature(QualifiedObjectName.valueOf((CatalogSchemaName)BuiltInTypeAndFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"block_input_aggregate"), FunctionKind.AGGREGATE, DoubleType.DOUBLE.getTypeSignature(), (List)ImmutableList.of((Object)DoubleType.DOUBLE.getTypeSignature()));
        ParametricAggregation aggregation = AggregationFromAnnotationsParser.parseFunctionDefinition(BlockInputAggregationFunction.class);
        Assert.assertEquals((String)aggregation.getDescription(), (String)"Simple aggregate with @BlockPosition usage");
        Assert.assertTrue((boolean)aggregation.isDeterministic());
        Assert.assertEquals((Object)aggregation.getSignature(), (Object)expectedSignature);
        ParametricImplementationsGroup implementations = aggregation.getImplementations();
        this.assertImplementationCount(implementations, 1, 0, 0);
        AggregationImplementation implementation = (AggregationImplementation)Iterables.getOnlyElement(implementations.getExactImplementations().values());
        Assert.assertFalse((boolean)implementation.getStateSerializerFactory().isPresent());
        Assert.assertEquals((Object)implementation.getDefinitionClass(), BlockInputAggregationFunction.class);
        this.assertDependencyCount(implementation, 0, 0, 0);
        Assert.assertFalse((boolean)implementation.hasSpecializedTypeParameters());
        ImmutableList expectedMetadataTypes = ImmutableList.of((Object)AggregationMetadata.ParameterMetadata.ParameterType.STATE, (Object)AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INPUT_CHANNEL, (Object)AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INDEX);
        Assert.assertEquals((Collection)implementation.getInputParameterMetadataTypes(), (Collection)expectedMetadataTypes);
        BuiltInAggregationFunctionImplementation specialized = aggregation.specialize(BoundVariables.builder().build(), 1, FUNCTION_AND_TYPE_MANAGER);
        Assert.assertEquals((Object)specialized.getFinalType(), (Object)DoubleType.DOUBLE);
        Assert.assertTrue((boolean)specialized.isDecomposable());
        Assert.assertEquals((String)specialized.name(), (String)"block_input_aggregate");
    }

    public void testSimpleImplicitSpecializedAggregationParse() {
        Signature expectedSignature = new Signature(QualifiedObjectName.valueOf((CatalogSchemaName)BuiltInTypeAndFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"implicit_specialized_aggregate"), FunctionKind.AGGREGATE, (List)ImmutableList.of((Object)Signature.typeVariable((String)"T")), (List)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"T"), (List)ImmutableList.of((Object)new TypeSignature("array", new TypeSignatureParameter[]{TypeSignatureParameter.of((TypeSignature)TypeSignature.parseTypeSignature((String)"T"))}), (Object)TypeSignature.parseTypeSignature((String)"T")), false);
        ParametricAggregation aggregation = AggregationFromAnnotationsParser.parseFunctionDefinition(ImplicitSpecializedAggregationFunction.class);
        Assert.assertEquals((String)aggregation.getDescription(), (String)"Simple implicit specialized aggregate");
        Assert.assertTrue((boolean)aggregation.isDeterministic());
        Assert.assertEquals((Object)aggregation.getSignature(), (Object)expectedSignature);
        ParametricImplementationsGroup implementations = aggregation.getImplementations();
        this.assertImplementationCount(implementations, 0, 0, 2);
        AggregationImplementation implementation1 = (AggregationImplementation)implementations.getSpecializedImplementations().get(0);
        Assert.assertTrue((boolean)implementation1.hasSpecializedTypeParameters());
        Assert.assertFalse((boolean)implementation1.hasSpecializedTypeParameters());
        ImmutableList expectedMetadataTypes = ImmutableList.of((Object)AggregationMetadata.ParameterMetadata.ParameterType.STATE, (Object)AggregationMetadata.ParameterMetadata.ParameterType.INPUT_CHANNEL, (Object)AggregationMetadata.ParameterMetadata.ParameterType.INPUT_CHANNEL);
        Assert.assertTrue((boolean)implementation1.getInputParameterMetadataTypes().equals(expectedMetadataTypes));
        AggregationImplementation implementation2 = (AggregationImplementation)implementations.getSpecializedImplementations().get(1);
        Assert.assertTrue((boolean)implementation2.hasSpecializedTypeParameters());
        Assert.assertFalse((boolean)implementation2.hasSpecializedTypeParameters());
        Assert.assertTrue((boolean)implementation2.getInputParameterMetadataTypes().equals(expectedMetadataTypes));
        BuiltInAggregationFunctionImplementation specialized = aggregation.specialize(BoundVariables.builder().setTypeVariable("T", (Type)DoubleType.DOUBLE).build(), 1, FUNCTION_AND_TYPE_MANAGER);
        Assert.assertEquals((Object)specialized.getFinalType(), (Object)DoubleType.DOUBLE);
        Assert.assertTrue((boolean)specialized.isDecomposable());
        Assert.assertEquals((String)specialized.name(), (String)"implicit_specialized_aggregate");
    }

    public void testSimpleExplicitSpecializedAggregationParse() {
        Signature expectedSignature = new Signature(QualifiedObjectName.valueOf((CatalogSchemaName)BuiltInTypeAndFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"explicit_specialized_aggregate"), FunctionKind.AGGREGATE, (List)ImmutableList.of((Object)Signature.typeVariable((String)"T")), (List)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"T"), (List)ImmutableList.of((Object)new TypeSignature("array", new TypeSignatureParameter[]{TypeSignatureParameter.of((TypeSignature)TypeSignature.parseTypeSignature((String)"T"))})), false);
        ParametricAggregation aggregation = AggregationFromAnnotationsParser.parseFunctionDefinition(ExplicitSpecializedAggregationFunction.class);
        Assert.assertEquals((String)aggregation.getDescription(), (String)"Simple explicit specialized aggregate");
        Assert.assertTrue((boolean)aggregation.isDeterministic());
        Assert.assertEquals((Object)aggregation.getSignature(), (Object)expectedSignature);
        ParametricImplementationsGroup implementations = aggregation.getImplementations();
        this.assertImplementationCount(implementations, 0, 1, 1);
        AggregationImplementation implementation1 = (AggregationImplementation)implementations.getSpecializedImplementations().get(0);
        Assert.assertTrue((boolean)implementation1.hasSpecializedTypeParameters());
        Assert.assertFalse((boolean)implementation1.hasSpecializedTypeParameters());
        ImmutableList expectedMetadataTypes = ImmutableList.of((Object)AggregationMetadata.ParameterMetadata.ParameterType.STATE, (Object)AggregationMetadata.ParameterMetadata.ParameterType.INPUT_CHANNEL);
        Assert.assertTrue((boolean)implementation1.getInputParameterMetadataTypes().equals(expectedMetadataTypes));
        AggregationImplementation implementation2 = (AggregationImplementation)implementations.getSpecializedImplementations().get(1);
        Assert.assertTrue((boolean)implementation2.hasSpecializedTypeParameters());
        Assert.assertFalse((boolean)implementation2.hasSpecializedTypeParameters());
        Assert.assertTrue((boolean)implementation2.getInputParameterMetadataTypes().equals(expectedMetadataTypes));
        BuiltInAggregationFunctionImplementation specialized = aggregation.specialize(BoundVariables.builder().setTypeVariable("T", (Type)DoubleType.DOUBLE).build(), 1, FUNCTION_AND_TYPE_MANAGER);
        Assert.assertEquals((Object)specialized.getFinalType(), (Object)DoubleType.DOUBLE);
        Assert.assertTrue((boolean)specialized.isDecomposable());
        Assert.assertEquals((String)specialized.name(), (String)"implicit_specialized_aggregate");
    }

    @Test
    public void testMultiOutputAggregationParse() {
        Signature expectedSignature1 = new Signature(QualifiedObjectName.valueOf((CatalogSchemaName)BuiltInTypeAndFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"multi_output_aggregate_1"), FunctionKind.AGGREGATE, DoubleType.DOUBLE.getTypeSignature(), (List)ImmutableList.of((Object)DoubleType.DOUBLE.getTypeSignature()));
        Signature expectedSignature2 = new Signature(QualifiedObjectName.valueOf((CatalogSchemaName)BuiltInTypeAndFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"multi_output_aggregate_2"), FunctionKind.AGGREGATE, DoubleType.DOUBLE.getTypeSignature(), (List)ImmutableList.of((Object)DoubleType.DOUBLE.getTypeSignature()));
        List aggregations = AggregationFromAnnotationsParser.parseFunctionDefinitions(MultiOutputAggregationFunction.class);
        Assert.assertEquals((int)aggregations.size(), (int)2);
        ParametricAggregation aggregation1 = (ParametricAggregation)((ImmutableList)aggregations.stream().filter(aggregate -> aggregate.getSignature().getNameSuffix().equals("multi_output_aggregate_1")).collect(ImmutableList.toImmutableList())).get(0);
        Assert.assertEquals((Object)aggregation1.getSignature(), (Object)expectedSignature1);
        Assert.assertEquals((String)aggregation1.getDescription(), (String)"Simple multi output function aggregate specialized description");
        ParametricAggregation aggregation2 = (ParametricAggregation)((ImmutableList)aggregations.stream().filter(aggregate -> aggregate.getSignature().getNameSuffix().equals("multi_output_aggregate_2")).collect(ImmutableList.toImmutableList())).get(0);
        Assert.assertEquals((Object)aggregation2.getSignature(), (Object)expectedSignature2);
        Assert.assertEquals((String)aggregation2.getDescription(), (String)"Simple multi output function aggregate generic description");
        ImmutableList expectedMetadataTypes = ImmutableList.of((Object)AggregationMetadata.ParameterMetadata.ParameterType.STATE, (Object)AggregationMetadata.ParameterMetadata.ParameterType.INPUT_CHANNEL);
        ParametricImplementationsGroup implementations1 = aggregation1.getImplementations();
        this.assertImplementationCount(implementations1, 1, 0, 0);
        ParametricImplementationsGroup implementations2 = aggregation2.getImplementations();
        this.assertImplementationCount(implementations2, 1, 0, 0);
        AggregationImplementation implementation = (AggregationImplementation)Iterables.getOnlyElement(implementations1.getExactImplementations().values());
        Assert.assertFalse((boolean)implementation.getStateSerializerFactory().isPresent());
        Assert.assertEquals((Object)implementation.getDefinitionClass(), MultiOutputAggregationFunction.class);
        this.assertDependencyCount(implementation, 0, 0, 0);
        Assert.assertFalse((boolean)implementation.hasSpecializedTypeParameters());
        Assert.assertTrue((boolean)implementation.getInputParameterMetadataTypes().equals(expectedMetadataTypes));
        BuiltInAggregationFunctionImplementation specialized = aggregation1.specialize(BoundVariables.builder().build(), 1, FUNCTION_AND_TYPE_MANAGER);
        Assert.assertEquals((Object)specialized.getFinalType(), (Object)DoubleType.DOUBLE);
        Assert.assertTrue((boolean)specialized.isDecomposable());
        Assert.assertEquals((String)specialized.name(), (String)"multi_output_aggregate_1");
    }

    @Test
    public void testInjectOperatorAggregateParse() {
        Signature expectedSignature = new Signature(QualifiedObjectName.valueOf((CatalogSchemaName)BuiltInTypeAndFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"inject_operator_aggregate"), FunctionKind.AGGREGATE, DoubleType.DOUBLE.getTypeSignature(), (List)ImmutableList.of((Object)DoubleType.DOUBLE.getTypeSignature()));
        ParametricAggregation aggregation = AggregationFromAnnotationsParser.parseFunctionDefinition(InjectOperatorAggregateFunction.class);
        Assert.assertEquals((String)aggregation.getDescription(), (String)"Simple aggregate with operator injected");
        Assert.assertTrue((boolean)aggregation.isDeterministic());
        Assert.assertEquals((Object)aggregation.getSignature(), (Object)expectedSignature);
        ParametricImplementationsGroup implementations = aggregation.getImplementations();
        AggregationImplementation implementation = (AggregationImplementation)Iterables.getOnlyElement(implementations.getExactImplementations().values());
        Assert.assertTrue((boolean)implementation.getStateSerializerFactory().isPresent());
        Assert.assertEquals((Object)implementation.getDefinitionClass(), InjectOperatorAggregateFunction.class);
        this.assertDependencyCount(implementation, 1, 1, 1);
        Assert.assertEquals((int)implementation.getStateSerializerFactoryDependencies().size(), (int)1);
        Assert.assertTrue((boolean)(implementation.getInputDependencies().get(0) instanceof OperatorImplementationDependency));
        Assert.assertTrue((boolean)(implementation.getCombineDependencies().get(0) instanceof OperatorImplementationDependency));
        Assert.assertTrue((boolean)(implementation.getOutputDependencies().get(0) instanceof OperatorImplementationDependency));
        Assert.assertTrue((boolean)(implementation.getStateSerializerFactoryDependencies().get(0) instanceof OperatorImplementationDependency));
        Assert.assertFalse((boolean)implementation.hasSpecializedTypeParameters());
        ImmutableList expectedMetadataTypes = ImmutableList.of((Object)AggregationMetadata.ParameterMetadata.ParameterType.STATE, (Object)AggregationMetadata.ParameterMetadata.ParameterType.INPUT_CHANNEL);
        Assert.assertTrue((boolean)implementation.getInputParameterMetadataTypes().equals(expectedMetadataTypes));
        BuiltInAggregationFunctionImplementation specialized = aggregation.specialize(BoundVariables.builder().build(), 1, FUNCTION_AND_TYPE_MANAGER);
        Assert.assertEquals((Object)specialized.getFinalType(), (Object)DoubleType.DOUBLE);
        Assert.assertTrue((boolean)specialized.isDecomposable());
        Assert.assertEquals((String)specialized.name(), (String)"inject_operator_aggregate");
    }

    @Test
    public void testInjectTypeAggregateParse() {
        Signature expectedSignature = new Signature(QualifiedObjectName.valueOf((CatalogSchemaName)BuiltInTypeAndFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"inject_type_aggregate"), FunctionKind.AGGREGATE, (List)ImmutableList.of((Object)Signature.typeVariable((String)"T")), (List)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"T"), (List)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"T")), false);
        ParametricAggregation aggregation = AggregationFromAnnotationsParser.parseFunctionDefinition(InjectTypeAggregateFunction.class);
        Assert.assertEquals((String)aggregation.getDescription(), (String)"Simple aggregate with type injected");
        Assert.assertTrue((boolean)aggregation.isDeterministic());
        Assert.assertEquals((Object)aggregation.getSignature(), (Object)expectedSignature);
        ParametricImplementationsGroup implementations = aggregation.getImplementations();
        Assert.assertEquals((int)implementations.getGenericImplementations().size(), (int)1);
        AggregationImplementation implementation = (AggregationImplementation)implementations.getGenericImplementations().get(0);
        Assert.assertTrue((boolean)implementation.getStateSerializerFactory().isPresent());
        Assert.assertEquals((Object)implementation.getDefinitionClass(), InjectTypeAggregateFunction.class);
        this.assertDependencyCount(implementation, 1, 1, 1);
        Assert.assertEquals((int)implementation.getStateSerializerFactoryDependencies().size(), (int)1);
        Assert.assertTrue((boolean)(implementation.getInputDependencies().get(0) instanceof TypeImplementationDependency));
        Assert.assertTrue((boolean)(implementation.getCombineDependencies().get(0) instanceof TypeImplementationDependency));
        Assert.assertTrue((boolean)(implementation.getOutputDependencies().get(0) instanceof TypeImplementationDependency));
        Assert.assertTrue((boolean)(implementation.getStateSerializerFactoryDependencies().get(0) instanceof TypeImplementationDependency));
        Assert.assertFalse((boolean)implementation.hasSpecializedTypeParameters());
        ImmutableList expectedMetadataTypes = ImmutableList.of((Object)AggregationMetadata.ParameterMetadata.ParameterType.STATE, (Object)AggregationMetadata.ParameterMetadata.ParameterType.INPUT_CHANNEL);
        Assert.assertTrue((boolean)implementation.getInputParameterMetadataTypes().equals(expectedMetadataTypes));
        BuiltInAggregationFunctionImplementation specialized = aggregation.specialize(BoundVariables.builder().setTypeVariable("T", (Type)DoubleType.DOUBLE).build(), 1, FUNCTION_AND_TYPE_MANAGER);
        Assert.assertEquals((Object)specialized.getFinalType(), (Object)DoubleType.DOUBLE);
        Assert.assertTrue((boolean)specialized.isDecomposable());
        Assert.assertEquals((String)specialized.name(), (String)"inject_type_aggregate");
    }

    @Test
    public void testInjectLiteralAggregateParse() {
        Signature expectedSignature = new Signature(QualifiedObjectName.valueOf((CatalogSchemaName)BuiltInTypeAndFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"inject_literal_aggregate"), FunctionKind.AGGREGATE, TypeSignature.parseTypeSignature((String)"varchar(x)", (Set)ImmutableSet.of((Object)"x")), (List)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"varchar(x)", (Set)ImmutableSet.of((Object)"x"))));
        ParametricAggregation aggregation = AggregationFromAnnotationsParser.parseFunctionDefinition(InjectLiteralAggregateFunction.class);
        Assert.assertEquals((String)aggregation.getDescription(), (String)"Simple aggregate with type literal");
        Assert.assertTrue((boolean)aggregation.isDeterministic());
        Assert.assertEquals((Object)aggregation.getSignature(), (Object)expectedSignature);
        ParametricImplementationsGroup implementations = aggregation.getImplementations();
        Assert.assertEquals((int)implementations.getGenericImplementations().size(), (int)1);
        AggregationImplementation implementation = (AggregationImplementation)implementations.getGenericImplementations().get(0);
        Assert.assertTrue((boolean)implementation.getStateSerializerFactory().isPresent());
        Assert.assertEquals((Object)implementation.getDefinitionClass(), InjectLiteralAggregateFunction.class);
        this.assertDependencyCount(implementation, 1, 1, 1);
        Assert.assertEquals((int)implementation.getStateSerializerFactoryDependencies().size(), (int)1);
        Assert.assertTrue((boolean)(implementation.getInputDependencies().get(0) instanceof LiteralImplementationDependency));
        Assert.assertTrue((boolean)(implementation.getCombineDependencies().get(0) instanceof LiteralImplementationDependency));
        Assert.assertTrue((boolean)(implementation.getOutputDependencies().get(0) instanceof LiteralImplementationDependency));
        Assert.assertTrue((boolean)(implementation.getStateSerializerFactoryDependencies().get(0) instanceof LiteralImplementationDependency));
        Assert.assertFalse((boolean)implementation.hasSpecializedTypeParameters());
        ImmutableList expectedMetadataTypes = ImmutableList.of((Object)AggregationMetadata.ParameterMetadata.ParameterType.STATE, (Object)AggregationMetadata.ParameterMetadata.ParameterType.INPUT_CHANNEL);
        Assert.assertTrue((boolean)implementation.getInputParameterMetadataTypes().equals(expectedMetadataTypes));
        BuiltInAggregationFunctionImplementation specialized = aggregation.specialize(BoundVariables.builder().setLongVariable("x", Long.valueOf(17L)).build(), 1, FUNCTION_AND_TYPE_MANAGER);
        Assert.assertEquals((Object)specialized.getFinalType(), (Object)VarcharType.createVarcharType((int)17));
        Assert.assertTrue((boolean)specialized.isDecomposable());
        Assert.assertEquals((String)specialized.name(), (String)"inject_literal_aggregate");
    }

    @Test
    public void testLongConstraintAggregateFunctionParse() {
        Signature expectedSignature = new Signature(QualifiedObjectName.valueOf((CatalogSchemaName)BuiltInTypeAndFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"parametric_aggregate_long_constraint"), FunctionKind.AGGREGATE, (List)ImmutableList.of(), (List)ImmutableList.of((Object)new LongVariableConstraint("z", "x + y")), TypeSignature.parseTypeSignature((String)"varchar(z)", (Set)ImmutableSet.of((Object)"z")), (List)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"varchar(x)", (Set)ImmutableSet.of((Object)"x")), (Object)TypeSignature.parseTypeSignature((String)"varchar(y)", (Set)ImmutableSet.of((Object)"y"))), false);
        ParametricAggregation aggregation = AggregationFromAnnotationsParser.parseFunctionDefinition(LongConstraintAggregateFunction.class);
        Assert.assertEquals((String)aggregation.getDescription(), (String)"Parametric aggregate with parametric type returned");
        Assert.assertTrue((boolean)aggregation.isDeterministic());
        Assert.assertEquals((Object)aggregation.getSignature(), (Object)expectedSignature);
        ParametricImplementationsGroup implementations = aggregation.getImplementations();
        Assert.assertEquals((int)implementations.getGenericImplementations().size(), (int)1);
        AggregationImplementation implementation = (AggregationImplementation)implementations.getGenericImplementations().get(0);
        Assert.assertTrue((!implementation.getStateSerializerFactory().isPresent() ? 1 : 0) != 0);
        Assert.assertEquals((Object)implementation.getDefinitionClass(), LongConstraintAggregateFunction.class);
        this.assertDependencyCount(implementation, 0, 0, 0);
        Assert.assertEquals((int)implementation.getStateSerializerFactoryDependencies().size(), (int)0);
        Assert.assertFalse((boolean)implementation.hasSpecializedTypeParameters());
        ImmutableList expectedMetadataTypes = ImmutableList.of((Object)AggregationMetadata.ParameterMetadata.ParameterType.STATE, (Object)AggregationMetadata.ParameterMetadata.ParameterType.INPUT_CHANNEL, (Object)AggregationMetadata.ParameterMetadata.ParameterType.INPUT_CHANNEL);
        Assert.assertTrue((boolean)implementation.getInputParameterMetadataTypes().equals(expectedMetadataTypes));
        BuiltInAggregationFunctionImplementation specialized = aggregation.specialize(BoundVariables.builder().setLongVariable("x", Long.valueOf(17L)).setLongVariable("y", Long.valueOf(13L)).setLongVariable("z", Long.valueOf(30L)).build(), 2, FUNCTION_AND_TYPE_MANAGER);
        Assert.assertEquals((Object)specialized.getFinalType(), (Object)VarcharType.createVarcharType((int)30));
        Assert.assertTrue((boolean)specialized.isDecomposable());
        Assert.assertEquals((String)specialized.name(), (String)"parametric_aggregate_long_constraint");
    }

    @Test
    public void testFixedTypeParameterInjectionAggregateFunctionParse() {
        Signature expectedSignature = new Signature(QualifiedObjectName.valueOf((CatalogSchemaName)BuiltInTypeAndFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"fixed_type_parameter_injection"), FunctionKind.AGGREGATE, (List)ImmutableList.of(), (List)ImmutableList.of(), DoubleType.DOUBLE.getTypeSignature(), (List)ImmutableList.of((Object)DoubleType.DOUBLE.getTypeSignature()), false);
        ParametricAggregation aggregation = AggregationFromAnnotationsParser.parseFunctionDefinition(FixedTypeParameterInjectionAggregateFunction.class);
        Assert.assertEquals((String)aggregation.getDescription(), (String)"Simple aggregate with fixed parameter type injected");
        Assert.assertTrue((boolean)aggregation.isDeterministic());
        Assert.assertEquals((Object)aggregation.getSignature(), (Object)expectedSignature);
        ParametricImplementationsGroup implementations = aggregation.getImplementations();
        this.assertImplementationCount(implementations, 1, 0, 0);
        AggregationImplementation implementationDouble = (AggregationImplementation)implementations.getExactImplementations().get(expectedSignature);
        Assert.assertFalse((boolean)implementationDouble.getStateSerializerFactory().isPresent());
        Assert.assertEquals((Object)implementationDouble.getDefinitionClass(), FixedTypeParameterInjectionAggregateFunction.class);
        this.assertDependencyCount(implementationDouble, 1, 1, 1);
        Assert.assertFalse((boolean)implementationDouble.hasSpecializedTypeParameters());
        ImmutableList expectedMetadataTypes = ImmutableList.of((Object)AggregationMetadata.ParameterMetadata.ParameterType.STATE, (Object)AggregationMetadata.ParameterMetadata.ParameterType.INPUT_CHANNEL);
        Assert.assertTrue((boolean)implementationDouble.getInputParameterMetadataTypes().equals(expectedMetadataTypes));
        Assert.assertEquals((Object)implementationDouble.getStateClass(), NullableDoubleState.class);
    }

    @Test
    public void testPartiallyFixedTypeParameterInjectionAggregateFunctionParse() {
        Signature expectedSignature = new Signature(QualifiedObjectName.valueOf((CatalogSchemaName)BuiltInTypeAndFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"partially_fixed_type_parameter_injection"), FunctionKind.AGGREGATE, (List)ImmutableList.of((Object)Signature.typeVariable((String)"T1"), (Object)Signature.typeVariable((String)"T2")), (List)ImmutableList.of(), DoubleType.DOUBLE.getTypeSignature(), (List)ImmutableList.of((Object)DoubleType.DOUBLE.getTypeSignature()), false);
        ParametricAggregation aggregation = AggregationFromAnnotationsParser.parseFunctionDefinition(PartiallyFixedTypeParameterInjectionAggregateFunction.class);
        Assert.assertEquals((String)aggregation.getDescription(), (String)"Simple aggregate with fixed parameter type injected");
        Assert.assertTrue((boolean)aggregation.isDeterministic());
        Assert.assertEquals((Object)aggregation.getSignature(), (Object)expectedSignature);
        ParametricImplementationsGroup implementations = aggregation.getImplementations();
        this.assertImplementationCount(implementations, 0, 0, 1);
        AggregationImplementation implementationDouble = (AggregationImplementation)((ImmutableList)implementations.getGenericImplementations().stream().filter(impl -> impl.getStateClass() == NullableDoubleState.class).collect(ImmutableList.toImmutableList())).get(0);
        Assert.assertFalse((boolean)implementationDouble.getStateSerializerFactory().isPresent());
        Assert.assertEquals((Object)implementationDouble.getDefinitionClass(), PartiallyFixedTypeParameterInjectionAggregateFunction.class);
        this.assertDependencyCount(implementationDouble, 1, 1, 1);
        Assert.assertFalse((boolean)implementationDouble.hasSpecializedTypeParameters());
        ImmutableList expectedMetadataTypes = ImmutableList.of((Object)AggregationMetadata.ParameterMetadata.ParameterType.STATE, (Object)AggregationMetadata.ParameterMetadata.ParameterType.INPUT_CHANNEL);
        Assert.assertTrue((boolean)implementationDouble.getInputParameterMetadataTypes().equals(expectedMetadataTypes));
        Assert.assertEquals((Object)implementationDouble.getStateClass(), NullableDoubleState.class);
        BuiltInAggregationFunctionImplementation specialized = aggregation.specialize(BoundVariables.builder().setTypeVariable("T1", (Type)DoubleType.DOUBLE).setTypeVariable("T2", (Type)DoubleType.DOUBLE).build(), 1, FUNCTION_AND_TYPE_MANAGER);
        Assert.assertEquals((Object)specialized.getFinalType(), (Object)DoubleType.DOUBLE);
        Assert.assertTrue((boolean)specialized.getParameterTypes().equals(ImmutableList.of((Object)DoubleType.DOUBLE)));
        Assert.assertTrue((boolean)specialized.isDecomposable());
        Assert.assertEquals((String)specialized.name(), (String)"partially_fixed_type_parameter_injection");
    }

    @AggregationFunction(value="partially_fixed_type_parameter_injection")
    @Description(value="Simple aggregate with fixed parameter type injected")
    public static class PartiallyFixedTypeParameterInjectionAggregateFunction {
        @InputFunction
        @TypeParameters(value={@TypeParameter(value="T1"), @TypeParameter(value="T2")})
        public static void input(@TypeParameter(value="ROW(ARRAY(T1),ROW(ROW(T2)),CHAR)") Type type, @AggregationState NullableDoubleState state, @SqlType(value="double") double value) {
        }

        @CombineFunction
        @TypeParameters(value={@TypeParameter(value="T1"), @TypeParameter(value="T2")})
        public static void combine(@TypeParameter(value="ROW(ARRAY(T1),ROW(ROW(T2)),CHAR)") Type type, @AggregationState NullableDoubleState state, @AggregationState NullableDoubleState otherState) {
        }

        @OutputFunction(value="double")
        @TypeParameters(value={@TypeParameter(value="T1"), @TypeParameter(value="T2")})
        public static void output(@TypeParameter(value="ROW(ARRAY(T1),ROW(ROW(T2)),CHAR)") Type type, @AggregationState NullableDoubleState state, BlockBuilder out) {
        }
    }

    @AggregationFunction(value="fixed_type_parameter_injection")
    @Description(value="Simple aggregate with fixed parameter type injected")
    public static class FixedTypeParameterInjectionAggregateFunction {
        @InputFunction
        public static void input(@TypeParameter(value="ROW(ARRAY(BIGINT),ROW(ROW(CHAR)),BIGINT,MAP(BIGINT,CHAR))") Type type, @AggregationState NullableDoubleState state, @SqlType(value="double") double value) {
        }

        @CombineFunction
        public static void combine(@TypeParameter(value="ROW(ARRAY(BIGINT),ROW(ROW(CHAR)),BIGINT,MAP(BIGINT,CHAR))") Type type, @AggregationState NullableDoubleState state, @AggregationState NullableDoubleState otherState) {
        }

        @OutputFunction(value="double")
        public static void output(@TypeParameter(value="ROW(ARRAY(BIGINT),ROW(ROW(CHAR)),BIGINT,MAP(BIGINT,CHAR))") Type type, @AggregationState NullableDoubleState state, BlockBuilder out) {
        }
    }

    @AggregationFunction(value="parametric_aggregate_long_constraint")
    @Description(value="Parametric aggregate with parametric type returned")
    public static class LongConstraintAggregateFunction {
        @InputFunction
        @LiteralParameters(value={"x", "y", "z"})
        @Constraint(variable="z", expression="x + y")
        public static void input(@AggregationState SliceState state, @SqlType(value="varchar(x)") Slice slice1, @SqlType(value="varchar(y)") Slice slice2) {
        }

        @CombineFunction
        public static void combine(@AggregationState SliceState combine1, @AggregationState SliceState combine2) {
        }

        @OutputFunction(value="varchar(z)")
        public static void output(@AggregationState SliceState state, BlockBuilder out) {
        }
    }

    @AggregationFunction(value="inject_literal_aggregate")
    @Description(value="Simple aggregate with type literal")
    public static class InjectLiteralAggregateFunction {
        @InputFunction
        @LiteralParameters(value={"x"})
        public static void input(@LiteralParameter(value="x") Long varcharSize, @AggregationState SliceState state, @SqlType(value="varchar(x)") Slice slice) {
        }

        @CombineFunction
        public static void combine(@LiteralParameter(value="x") Long varcharSize, @AggregationState SliceState combine1, @AggregationState SliceState combine2) {
        }

        @OutputFunction(value="varchar(x)")
        public static void output(@LiteralParameter(value="x") Long varcharSize, @AggregationState SliceState state, BlockBuilder out) {
        }

        @AggregationStateSerializerFactory(value=SliceState.class)
        public static CustomStateSerializerAggregationFunction.CustomSerializer createSerializer(@LiteralParameter(value="x") Long varcharSize) {
            return new CustomStateSerializerAggregationFunction.CustomSerializer();
        }
    }

    @AggregationFunction(value="inject_type_aggregate")
    @Description(value="Simple aggregate with type injected")
    public static class InjectTypeAggregateFunction {
        @InputFunction
        @TypeParameter(value="T")
        public static void input(@TypeParameter(value="T") Type type, @AggregationState NullableDoubleState state, @SqlType(value="T") double value) {
        }

        @CombineFunction
        public static void combine(@TypeParameter(value="T") Type type, @AggregationState NullableDoubleState combine1, @AggregationState NullableDoubleState combine2) {
        }

        @OutputFunction(value="T")
        public static void output(@TypeParameter(value="T") Type type, @AggregationState NullableDoubleState state, BlockBuilder out) {
        }

        @AggregationStateSerializerFactory(value=NullableDoubleState.class)
        public static CustomStateSerializerAggregationFunction.CustomSerializer createSerializer(@TypeParameter(value="T") Type type) {
            return new CustomStateSerializerAggregationFunction.CustomSerializer();
        }
    }

    @AggregationFunction(value="inject_operator_aggregate")
    @Description(value="Simple aggregate with operator injected")
    public static class InjectOperatorAggregateFunction {
        @InputFunction
        public static void input(@OperatorDependency(operator=OperatorType.LESS_THAN, argumentTypes={"double", "double"}) MethodHandle methodHandle, @AggregationState NullableDoubleState state, @SqlType(value="double") double value) {
        }

        @CombineFunction
        public static void combine(@OperatorDependency(operator=OperatorType.LESS_THAN, argumentTypes={"double", "double"}) MethodHandle methodHandle, @AggregationState NullableDoubleState combine1, @AggregationState NullableDoubleState combine2) {
        }

        @OutputFunction(value="double")
        public static void output(@OperatorDependency(operator=OperatorType.LESS_THAN, argumentTypes={"double", "double"}) MethodHandle methodHandle, @AggregationState NullableDoubleState state, BlockBuilder out) {
        }

        @AggregationStateSerializerFactory(value=NullableDoubleState.class)
        public static CustomStateSerializerAggregationFunction.CustomSerializer createSerializer(@OperatorDependency(operator=OperatorType.LESS_THAN, argumentTypes={"double", "double"}) MethodHandle methodHandle) {
            return new CustomStateSerializerAggregationFunction.CustomSerializer();
        }
    }

    @AggregationFunction(value="multi_output_aggregate")
    @Description(value="Simple multi output function aggregate generic description")
    public static class MultiOutputAggregationFunction {
        @InputFunction
        public static void input(@AggregationState NullableDoubleState state, @SqlType(value="double") double value) {
        }

        @CombineFunction
        public static void combine(@AggregationState NullableDoubleState combine1, @AggregationState NullableDoubleState combine2) {
        }

        @AggregationFunction(value="multi_output_aggregate_1")
        @Description(value="Simple multi output function aggregate specialized description")
        @OutputFunction(value="double")
        public static void output1(@AggregationState NullableDoubleState state, BlockBuilder out) {
        }

        @AggregationFunction(value="multi_output_aggregate_2")
        @OutputFunction(value="double")
        public static void output2(@AggregationState NullableDoubleState state, BlockBuilder out) {
        }
    }

    @AggregationFunction(value="explicit_specialized_aggregate")
    @Description(value="Simple explicit specialized aggregate")
    public static class ExplicitSpecializedAggregationFunction {
        @InputFunction
        @TypeParameterSpecialization(name="T", nativeContainerType=double.class)
        @TypeParameter(value="T")
        public static void input(@AggregationState NullableDoubleState state, @SqlType(value="array(T)") Block arrayBlock) {
        }

        @InputFunction
        @TypeParameter(value="T")
        public static void input(@AggregationState NullableLongState state, @SqlType(value="array(T)") Block arrayBlock) {
        }

        @CombineFunction
        public static void combine(@AggregationState NullableLongState state, @AggregationState NullableLongState otherState) {
        }

        @CombineFunction
        public static void combine(@AggregationState NullableDoubleState state, @AggregationState NullableDoubleState otherState) {
        }

        @OutputFunction(value="T")
        public static void output(@AggregationState NullableLongState state, BlockBuilder out) {
        }

        @OutputFunction(value="T")
        public static void output(@AggregationState NullableDoubleState state, BlockBuilder out) {
        }
    }

    @AggregationFunction(value="implicit_specialized_aggregate")
    @Description(value="Simple implicit specialized aggregate")
    public static class ImplicitSpecializedAggregationFunction {
        @InputFunction
        @TypeParameter(value="T")
        public static void input(@AggregationState NullableDoubleState state, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="T") double additionalValue) {
        }

        @InputFunction
        @TypeParameter(value="T")
        public static void input(@AggregationState NullableLongState state, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="T") long additionalValue) {
        }

        @CombineFunction
        public static void combine(@AggregationState NullableLongState state, @AggregationState NullableLongState otherState) {
        }

        @CombineFunction
        public static void combine(@AggregationState NullableDoubleState state, @AggregationState NullableDoubleState otherState) {
        }

        @OutputFunction(value="T")
        public static void output(@AggregationState NullableLongState state, BlockBuilder out) {
        }

        @OutputFunction(value="T")
        public static void output(@AggregationState NullableDoubleState state, BlockBuilder out) {
        }
    }

    @AggregationFunction(value="block_input_aggregate")
    @Description(value="Simple aggregate with @BlockPosition usage")
    public static class BlockInputAggregationFunction {
        @InputFunction
        public static void input(@AggregationState NullableDoubleState state, @BlockPosition @SqlType(value="double") Block value, @BlockIndex int id) {
        }

        @CombineFunction
        public static void combine(@AggregationState NullableDoubleState combine1, @AggregationState NullableDoubleState combine2) {
        }

        @OutputFunction(value="double")
        public static void output(@AggregationState NullableDoubleState state, BlockBuilder out) {
        }
    }

    @AggregationFunction(value="simple_generic_implementations")
    @Description(value="Simple aggregate with two generic implementations")
    public static class GenericAggregationFunction {
        @InputFunction
        @TypeParameter(value="T")
        public static void input(@AggregationState NullableDoubleState state, @SqlType(value="T") double value) {
        }

        @InputFunction
        @TypeParameter(value="T")
        public static void input(@AggregationState NullableLongState state, @SqlType(value="T") long value) {
        }

        @CombineFunction
        public static void combine(@AggregationState NullableLongState state, @AggregationState NullableLongState otherState) {
        }

        @CombineFunction
        public static void combine(@AggregationState NullableDoubleState state, @AggregationState NullableDoubleState otherState) {
        }

        @OutputFunction(value="T")
        public static void output(@AggregationState NullableLongState state, BlockBuilder out) {
        }

        @OutputFunction(value="T")
        public static void output(@AggregationState NullableDoubleState state, BlockBuilder out) {
        }
    }

    @AggregationFunction(value="custom_decomposable_aggregate", decomposable=false)
    @Description(value="Aggregate with Decomposable=false")
    public static class NotDecomposableAggregationFunction {
        @InputFunction
        public static void input(@AggregationState NullableDoubleState state, @SqlType(value="double") double value) {
        }

        @CombineFunction
        public static void combine(@AggregationState NullableDoubleState combine1, @AggregationState NullableDoubleState combine2) {
        }

        @OutputFunction(value="double")
        public static void output(@AggregationState NullableDoubleState state, BlockBuilder out) {
        }

        @AggregationStateSerializerFactory(value=NullableDoubleState.class)
        public static AccumulatorStateSerializer<?> createSerializer() {
            return new CustomStateSerializerAggregationFunction.CustomSerializer();
        }
    }

    @AggregationFunction(value="custom_serializer_aggregate")
    @Description(value="Aggregate with no @AggregationState annotations")
    public static class CustomStateSerializerAggregationFunction {
        @InputFunction
        public static void input(@AggregationState NullableDoubleState state, @SqlType(value="double") double value) {
        }

        @CombineFunction
        public static void combine(@AggregationState NullableDoubleState combine1, @AggregationState NullableDoubleState combine2) {
        }

        @OutputFunction(value="double")
        public static void output(@AggregationState NullableDoubleState state, BlockBuilder out) {
        }

        @AggregationStateSerializerFactory(value=NullableDoubleState.class)
        public static CustomSerializer createSerializer() {
            return new CustomSerializer();
        }

        public static class CustomSerializer
        extends NullableDoubleStateSerializer {
        }
    }

    @AggregationFunction(value="no_aggregation_state_aggregate")
    @Description(value="Aggregate with no @AggregationState annotations")
    public static class NotAnnotatedAggregateStateAggregationFunction {
        @InputFunction
        public static void input(NullableDoubleState state, @SqlType(value="double") double value) {
        }

        @CombineFunction
        public static void combine(NullableDoubleState combine1, NullableDoubleState combine2) {
        }

        @OutputFunction(value="double")
        public static void output(NullableDoubleState state, BlockBuilder out) {
        }
    }

    @AggregationFunction(value="simple_exact_aggregate_aggregation_state_moved")
    @Description(value="Simple exact function which has @AggregationState on different than first positions")
    public static class StateOnDifferentThanFirstPositionAggregationFunction {
        @InputFunction
        public static void input(@SqlType(value="double") double value, @AggregationState NullableDoubleState state) {
        }

        @CombineFunction
        public static void combine(@AggregationState NullableDoubleState combine1, @AggregationState NullableDoubleState combine2) {
        }

        @OutputFunction(value="double")
        public static void output(BlockBuilder out, @AggregationState NullableDoubleState state) {
        }
    }

    @AggregationFunction(value="simple_exact_aggregate")
    @Description(value="Simple exact aggregate description")
    public static class ExactAggregationFunction {
        @InputFunction
        public static void input(@AggregationState NullableDoubleState state, @SqlType(value="double") double value) {
        }

        @CombineFunction
        public static void combine(@AggregationState NullableDoubleState combine1, @AggregationState NullableDoubleState combine2) {
        }

        @OutputFunction(value="double")
        public static void output(@AggregationState NullableDoubleState state, BlockBuilder out) {
        }
    }
}

