/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.predicate.Range;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.predicate.ValueSet;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeUtils;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.operator.DynamicFilterSourceOperator;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorAssertion;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.PipelineContext;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.TestingTaskContext;
import com.facebook.presto.testing.assertions.Assert;
import com.facebook.presto.type.ColorType;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.IntStream;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestDynamicFilterSourceOperator {
    private ExecutorService executor;
    private ScheduledExecutorService scheduledExecutor;
    private PipelineContext pipelineContext;
    private ImmutableList.Builder<TupleDomain<String>> partitions;

    @BeforeMethod
    public void setUp() {
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test-executor-%s"));
        this.scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)"test-scheduledExecutor-%s"));
        this.pipelineContext = TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION).addPipelineContext(0, true, true, false);
        this.partitions = ImmutableList.builder();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        this.executor.shutdownNow();
        this.scheduledExecutor.shutdownNow();
    }

    private void verifyPassthrough(Operator operator, List<Type> types, Page ... pages) {
        this.verifyPassthrough(operator, types, Arrays.asList(pages));
    }

    private void verifyPassthrough(Operator operator, List<Type> types, List<Page> pages) {
        ImmutableList inputPages = ImmutableList.copyOf(pages);
        List<Page> outputPages = OperatorAssertion.toPages(operator, inputPages.iterator());
        MaterializedResult actual = OperatorAssertion.toMaterializedResult(this.pipelineContext.getSession(), types, outputPages);
        MaterializedResult expected = OperatorAssertion.toMaterializedResult(this.pipelineContext.getSession(), types, (List<Page>)inputPages);
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
    }

    private OperatorFactory createOperatorFactory(DynamicFilterSourceOperator.Channel ... buildChannels) {
        return this.createOperatorFactory(100, new DataSize(10.0, DataSize.Unit.KILOBYTE), 1000000, Arrays.asList(buildChannels));
    }

    private OperatorFactory createOperatorFactory(int maxFilterPositionsCount, DataSize maxFilterSize, int minMaxCollectionLimit, Iterable<DynamicFilterSourceOperator.Channel> buildChannels) {
        return new DynamicFilterSourceOperator.DynamicFilterSourceOperatorFactory(0, new PlanNodeId("PLAN_NODE_ID"), this::consumePredicate, (List)ImmutableList.copyOf(buildChannels), maxFilterPositionsCount, maxFilterSize, minMaxCollectionLimit);
    }

    private void consumePredicate(TupleDomain<String> partitionPredicate) {
        this.partitions.add(partitionPredicate);
    }

    private Operator createOperator(OperatorFactory operatorFactory) {
        return operatorFactory.createOperator(this.pipelineContext.addDriverContext());
    }

    private static DynamicFilterSourceOperator.Channel channel(int index, Type type) {
        return new DynamicFilterSourceOperator.Channel(Integer.toString(index), type, index);
    }

    private void assertDynamicFilters(int maxFilterPositionsCount, List<Type> types, List<Page> pages, List<TupleDomain<String>> expectedTupleDomains) {
        this.assertDynamicFilters(maxFilterPositionsCount, new DataSize(10.0, DataSize.Unit.KILOBYTE), 1000000, types, pages, expectedTupleDomains);
    }

    private void assertDynamicFilters(int maxFilterPositionsCount, DataSize maxFilterSize, int minMaxCollectionLimit, List<Type> types, List<Page> pages, List<TupleDomain<String>> expectedTupleDomains) {
        List buildChannels = (List)IntStream.range(0, types.size()).mapToObj(i -> TestDynamicFilterSourceOperator.channel(i, (Type)types.get(i))).collect(ImmutableList.toImmutableList());
        OperatorFactory operatorFactory = this.createOperatorFactory(maxFilterPositionsCount, maxFilterSize, minMaxCollectionLimit, buildChannels);
        this.verifyPassthrough(this.createOperator(operatorFactory), types, pages);
        operatorFactory.noMoreOperators();
        Assert.assertEquals((Collection)this.partitions.build(), expectedTupleDomains);
    }

    @Test
    public void testCollectMultipleOperators() {
        OperatorFactory operatorFactory = this.createOperatorFactory(TestDynamicFilterSourceOperator.channel(0, (Type)BigintType.BIGINT));
        Operator op1 = this.createOperator(operatorFactory);
        this.verifyPassthrough(op1, (List<Type>)ImmutableList.of((Object)BigintType.BIGINT), new Page(new Block[]{BlockAssertions.createLongsBlock(1, 2)}), new Page(new Block[]{BlockAssertions.createLongsBlock(3, 5)}));
        Operator op2 = this.createOperator(operatorFactory);
        operatorFactory.noMoreOperators();
        Assert.assertEquals((Collection)this.partitions.build(), (Collection)ImmutableList.of((Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)"0", (Object)Domain.multipleValues((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)1L, (Object)2L, (Object)3L, (Object)5L))))));
        this.verifyPassthrough(op2, (List<Type>)ImmutableList.of((Object)BigintType.BIGINT), new Page(new Block[]{BlockAssertions.createLongsBlock(2, 3)}), new Page(new Block[]{BlockAssertions.createLongsBlock(1, 4)}));
        Assert.assertEquals((Collection)this.partitions.build(), (Collection)ImmutableList.of((Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)"0", (Object)Domain.multipleValues((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)1L, (Object)2L, (Object)3L, (Object)5L)))), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)"0", (Object)Domain.multipleValues((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)1L, (Object)2L, (Object)3L, (Object)4L))))));
    }

    @Test
    public void testCollectMultipleColumns() {
        OperatorFactory operatorFactory = this.createOperatorFactory(TestDynamicFilterSourceOperator.channel(0, (Type)BooleanType.BOOLEAN), TestDynamicFilterSourceOperator.channel(1, (Type)DoubleType.DOUBLE));
        this.verifyPassthrough(this.createOperator(operatorFactory), (List<Type>)ImmutableList.of((Object)BooleanType.BOOLEAN, (Object)DoubleType.DOUBLE), new Page(new Block[]{BlockAssertions.createBooleansBlock((Boolean)true, 2), BlockAssertions.createDoublesBlock(1.5, 3.0)}), new Page(new Block[]{BlockAssertions.createBooleansBlock((Boolean)false, 1), BlockAssertions.createDoublesBlock(4.5)}));
        operatorFactory.noMoreOperators();
        Assert.assertEquals((Collection)this.partitions.build(), (Collection)ImmutableList.of((Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)"0", (Object)Domain.multipleValues((Type)BooleanType.BOOLEAN, (List)ImmutableList.of((Object)true, (Object)false)), (Object)"1", (Object)Domain.multipleValues((Type)DoubleType.DOUBLE, (List)ImmutableList.of((Object)1.5, (Object)3.0, (Object)4.5))))));
    }

    @Test
    public void testCollectOnlyFirstColumn() {
        OperatorFactory operatorFactory = this.createOperatorFactory(TestDynamicFilterSourceOperator.channel(0, (Type)BooleanType.BOOLEAN));
        this.verifyPassthrough(this.createOperator(operatorFactory), (List<Type>)ImmutableList.of((Object)BooleanType.BOOLEAN, (Object)DoubleType.DOUBLE), new Page(new Block[]{BlockAssertions.createBooleansBlock((Boolean)true, 2), BlockAssertions.createDoublesBlock(1.5, 3.0)}), new Page(new Block[]{BlockAssertions.createBooleansBlock((Boolean)false, 1), BlockAssertions.createDoublesBlock(4.5)}));
        operatorFactory.noMoreOperators();
        Assert.assertEquals((Collection)this.partitions.build(), (Collection)ImmutableList.of((Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)"0", (Object)Domain.multipleValues((Type)BooleanType.BOOLEAN, (List)ImmutableList.of((Object)true, (Object)false))))));
    }

    @Test
    public void testCollectOnlyLastColumn() {
        OperatorFactory operatorFactory = this.createOperatorFactory(TestDynamicFilterSourceOperator.channel(1, (Type)DoubleType.DOUBLE));
        this.verifyPassthrough(this.createOperator(operatorFactory), (List<Type>)ImmutableList.of((Object)BooleanType.BOOLEAN, (Object)DoubleType.DOUBLE), new Page(new Block[]{BlockAssertions.createBooleansBlock((Boolean)true, 2), BlockAssertions.createDoublesBlock(1.5, 3.0)}), new Page(new Block[]{BlockAssertions.createBooleansBlock((Boolean)false, 1), BlockAssertions.createDoublesBlock(4.5)}));
        operatorFactory.noMoreOperators();
        Assert.assertEquals((Collection)this.partitions.build(), (Collection)ImmutableList.of((Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)"1", (Object)Domain.multipleValues((Type)DoubleType.DOUBLE, (List)ImmutableList.of((Object)1.5, (Object)3.0, (Object)4.5))))));
    }

    @Test
    public void testCollectWithNulls() {
        Block blockWithNulls = IntegerType.INTEGER.createFixedSizeBlockBuilder(0).writeInt(3).appendNull().writeInt(4).build();
        OperatorFactory operatorFactory = this.createOperatorFactory(TestDynamicFilterSourceOperator.channel(0, (Type)IntegerType.INTEGER));
        this.verifyPassthrough(this.createOperator(operatorFactory), (List<Type>)ImmutableList.of((Object)IntegerType.INTEGER), new Page(new Block[]{BlockAssertions.createLongsBlock(1, 2, 3)}), new Page(new Block[]{blockWithNulls}), new Page(new Block[]{BlockAssertions.createLongsBlock(4, 5)}));
        operatorFactory.noMoreOperators();
        Assert.assertEquals((Collection)this.partitions.build(), (Collection)ImmutableList.of((Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)"0", (Object)Domain.create((ValueSet)ValueSet.of((Type)IntegerType.INTEGER, (Object)1L, (Object[])new Object[]{2L, 3L, 4L, 5L}), (boolean)false)))));
    }

    @Test
    public void testCollectWithDoubleNaN() {
        BlockBuilder input = DoubleType.DOUBLE.createBlockBuilder(null, 10);
        DoubleType.DOUBLE.writeDouble(input, 42.0);
        DoubleType.DOUBLE.writeDouble(input, Double.NaN);
        OperatorFactory operatorFactory = this.createOperatorFactory(TestDynamicFilterSourceOperator.channel(0, (Type)DoubleType.DOUBLE));
        this.verifyPassthrough(this.createOperator(operatorFactory), (List<Type>)ImmutableList.of((Object)DoubleType.DOUBLE), new Page(new Block[]{input.build()}));
        operatorFactory.noMoreOperators();
        Assert.assertEquals((Collection)this.partitions.build(), (Collection)ImmutableList.of((Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)"0", (Object)Domain.multipleValues((Type)DoubleType.DOUBLE, (List)ImmutableList.of((Object)42.0))))));
    }

    @Test
    public void testCollectWithRealNaN() {
        BlockBuilder input = RealType.REAL.createBlockBuilder(null, 10);
        RealType.REAL.writeLong(input, (long)Float.floatToRawIntBits(42.0f));
        RealType.REAL.writeLong(input, (long)Float.floatToRawIntBits(Float.NaN));
        OperatorFactory operatorFactory = this.createOperatorFactory(TestDynamicFilterSourceOperator.channel(0, (Type)RealType.REAL));
        this.verifyPassthrough(this.createOperator(operatorFactory), (List<Type>)ImmutableList.of((Object)RealType.REAL), new Page(new Block[]{input.build()}));
        operatorFactory.noMoreOperators();
        Assert.assertEquals((Collection)this.partitions.build(), (Collection)ImmutableList.of((Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)"0", (Object)Domain.multipleValues((Type)RealType.REAL, (List)ImmutableList.of((Object)Float.floatToRawIntBits(42.0f)))))));
    }

    @Test
    public void testCollectTooMuchRowsDouble() {
        int maxPositionsCount = 100;
        this.assertDynamicFilters(maxPositionsCount, (List<Type>)ImmutableList.of((Object)DoubleType.DOUBLE), (List<Page>)ImmutableList.of((Object)new Page(new Block[]{BlockAssertions.createDoubleSequenceBlock(0, maxPositionsCount + 1)}), (Object)new Page(new Block[]{BlockAssertions.createDoubleRepeatBlock(Double.NaN, maxPositionsCount + 1)})), (List<TupleDomain<String>>)ImmutableList.of((Object)TupleDomain.all()));
    }

    @Test
    public void testCollectTooMuchRowsReal() {
        int maxPositionsCount = 100;
        this.assertDynamicFilters(maxPositionsCount, (List<Type>)ImmutableList.of((Object)RealType.REAL), (List<Page>)ImmutableList.of((Object)new Page(new Block[]{BlockAssertions.createSequenceBlockOfReal(0, maxPositionsCount + 1)}), (Object)new Page(new Block[]{BlockAssertions.createBlockOfReals(Collections.nCopies(maxPositionsCount + 1, Float.valueOf(Float.NaN)))})), (List<TupleDomain<String>>)ImmutableList.of((Object)TupleDomain.all()));
    }

    @Test
    public void testCollectTooMuchRowsNonOrderable() {
        int maxPositionsCount = 100;
        this.assertDynamicFilters(maxPositionsCount, (List<Type>)ImmutableList.of((Object)ColorType.COLOR), (List<Page>)ImmutableList.of((Object)new Page(new Block[]{BlockAssertions.createColorSequenceBlock(0, maxPositionsCount + 1)})), (List<TupleDomain<String>>)ImmutableList.of((Object)TupleDomain.all()));
    }

    @Test
    public void testCollectRowsNonOrderable() {
        int maxPositionsCount = 100;
        Block block = BlockAssertions.createColorSequenceBlock(0, maxPositionsCount / 2);
        ImmutableList.Builder values = ImmutableList.builder();
        for (int position = 0; position < block.getPositionCount(); ++position) {
            values.add(TypeUtils.readNativeValue((Type)ColorType.COLOR, (Block)block, (int)position));
        }
        this.assertDynamicFilters(maxPositionsCount, (List<Type>)ImmutableList.of((Object)ColorType.COLOR), (List<Page>)ImmutableList.of((Object)new Page(new Block[]{block})), (List<TupleDomain<String>>)ImmutableList.of((Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)"0", (Object)Domain.create((ValueSet)ValueSet.copyOf((Type)ColorType.COLOR, (Collection)values.build()), (boolean)false)))));
    }

    @Test
    public void testCollectNoFilters() {
        OperatorFactory operatorFactory = this.createOperatorFactory(new DynamicFilterSourceOperator.Channel[0]);
        this.verifyPassthrough(this.createOperator(operatorFactory), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT), new Page(new Block[]{BlockAssertions.createLongsBlock(1, 2, 3)}));
        operatorFactory.noMoreOperators();
        Assert.assertEquals((Collection)this.partitions.build(), (Collection)ImmutableList.of((Object)TupleDomain.all()));
    }

    @Test
    public void testCollectEmptyBuildSide() {
        OperatorFactory operatorFactory = this.createOperatorFactory(TestDynamicFilterSourceOperator.channel(0, (Type)BigintType.BIGINT));
        this.verifyPassthrough(this.createOperator(operatorFactory), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT), new Page[0]);
        operatorFactory.noMoreOperators();
        Assert.assertEquals((Collection)this.partitions.build(), (Collection)ImmutableList.of((Object)TupleDomain.none()));
    }

    @Test
    public void testSingleColumnCollectMinMaxRangeWhenTooManyPositions() {
        int maxPositionsCount = 100;
        Page largePage = new Page(new Block[]{BlockAssertions.createLongSequenceBlock(0, maxPositionsCount + 1)});
        this.assertDynamicFilters(maxPositionsCount, (List<Type>)ImmutableList.of((Object)BigintType.BIGINT), (List<Page>)ImmutableList.of((Object)largePage), (List<TupleDomain<String>>)ImmutableList.of((Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)"0", (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)true, (Object)maxPositionsCount, (boolean)true), (Range[])new Range[0]), (boolean)false)))));
    }

    @Test
    public void testMultipleColumnsCollectMinMaxRangeWhenTooManyPositions() {
        int maxPositionsCount = 300;
        Page largePage = new Page(new Block[]{BlockAssertions.createLongSequenceBlock(0, 101), BlockAssertions.createColorSequenceBlock(100, 201), BlockAssertions.createLongSequenceBlock(200, 301)});
        ImmutableList expectedTupleDomains = ImmutableList.of((Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)"0", (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)true, (Object)100L, (boolean)true), (Range[])new Range[0]), (boolean)false), (Object)"2", (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)BigintType.BIGINT, (Object)200L, (boolean)true, (Object)300L, (boolean)true), (Range[])new Range[0]), (boolean)false))));
        this.assertDynamicFilters(maxPositionsCount, (List<Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)ColorType.COLOR, (Object)BigintType.BIGINT), (List<Page>)ImmutableList.of((Object)largePage), (List<TupleDomain<String>>)expectedTupleDomains);
    }

    @Test
    public void testMultipleColumnsCollectMinMaxWithNulls() {
        int maxPositionsCount = 100;
        Page largePage = new Page(new Block[]{BlockAssertions.createLongsBlock(Collections.nCopies(100, null)), BlockAssertions.createLongSequenceBlock(200, 301)});
        this.assertDynamicFilters(maxPositionsCount, (List<Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT), (List<Page>)ImmutableList.of((Object)largePage), (List<TupleDomain<String>>)ImmutableList.of((Object)TupleDomain.none()));
    }

    @Test
    public void testSingleColumnCollectMinMaxRangeWhenTooManyBytes() {
        DataSize maxSize = new DataSize(10.0, DataSize.Unit.KILOBYTE);
        long maxByteSize = maxSize.toBytes();
        String largeText = Strings.repeat((String)"A", (int)((int)maxByteSize + 1));
        Page largePage = new Page(new Block[]{BlockAssertions.createStringsBlock(largeText)});
        this.assertDynamicFilters(100, maxSize, 100, (List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR), (List<Page>)ImmutableList.of((Object)largePage), (List<TupleDomain<String>>)ImmutableList.of((Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)"0", (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)largeText), (boolean)true, (Object)Slices.utf8Slice((String)largeText), (boolean)true), (Range[])new Range[0]), (boolean)false)))));
    }

    @Test
    public void testMultipleColumnsCollectMinMaxRangeWhenTooManyBytes() {
        DataSize maxSize = new DataSize(10.0, DataSize.Unit.KILOBYTE);
        long maxByteSize = maxSize.toBytes();
        String largeTextA = Strings.repeat((String)"A", (int)((int)(maxByteSize / 2L) + 1));
        String largeTextB = Strings.repeat((String)"B", (int)((int)(maxByteSize / 2L) + 1));
        Page largePage = new Page(new Block[]{BlockAssertions.createStringsBlock(largeTextA), BlockAssertions.createStringsBlock(largeTextB)});
        ImmutableList expectedTupleDomains = ImmutableList.of((Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)"0", (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)largeTextA), (boolean)true, (Object)Slices.utf8Slice((String)largeTextA), (boolean)true), (Range[])new Range[0]), (boolean)false), (Object)"1", (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)largeTextB), (boolean)true, (Object)Slices.utf8Slice((String)largeTextB), (boolean)true), (Range[])new Range[0]), (boolean)false))));
        this.assertDynamicFilters(100, maxSize, 100, (List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR), (List<Page>)ImmutableList.of((Object)largePage), (List<TupleDomain<String>>)expectedTupleDomains);
    }

    @Test
    public void testCollectMultipleLargePages() {
        int maxPositionsCount = 100;
        Page page1 = new Page(new Block[]{BlockAssertions.createLongSequenceBlock(50, 151)});
        Page page2 = new Page(new Block[]{BlockAssertions.createLongSequenceBlock(0, 101)});
        Page page3 = new Page(new Block[]{BlockAssertions.createLongSequenceBlock(100, 201)});
        this.assertDynamicFilters(maxPositionsCount, (List<Type>)ImmutableList.of((Object)BigintType.BIGINT), (List<Page>)ImmutableList.of((Object)page1, (Object)page2, (Object)page3), (List<TupleDomain<String>>)ImmutableList.of((Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)"0", (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)true, (Object)200L, (boolean)true), (Range[])new Range[0]), (boolean)false)))));
    }

    @Test
    public void testCollectDeduplication() {
        int maxPositionsCount = 100;
        Page largePage = new Page(new Block[]{BlockAssertions.createLongRepeatBlock(7, maxPositionsCount * 10)});
        Page nullsPage = new Page(new Block[]{BlockAssertions.createLongsBlock(Arrays.asList(new Long[maxPositionsCount * 10]))});
        this.assertDynamicFilters(maxPositionsCount, (List<Type>)ImmutableList.of((Object)BigintType.BIGINT), (List<Page>)ImmutableList.of((Object)largePage, (Object)nullsPage), (List<TupleDomain<String>>)ImmutableList.of((Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)"0", (Object)Domain.create((ValueSet)ValueSet.of((Type)BigintType.BIGINT, (Object)7L, (Object[])new Object[0]), (boolean)false)))));
    }

    @Test
    public void testCollectMinMaxLimitSinglePage() {
        int maxPositionsCount = 100;
        this.assertDynamicFilters(maxPositionsCount, new DataSize(10.0, DataSize.Unit.KILOBYTE), 2 * maxPositionsCount, (List<Type>)ImmutableList.of((Object)BigintType.BIGINT), (List<Page>)ImmutableList.of((Object)new Page(new Block[]{BlockAssertions.createLongSequenceBlock(0, 2 * maxPositionsCount + 1)})), (List<TupleDomain<String>>)ImmutableList.of((Object)TupleDomain.all()));
    }

    @Test
    public void testCollectMinMaxLimitMultiplePages() {
        int maxPositionsCount = 100;
        this.assertDynamicFilters(maxPositionsCount, new DataSize(10.0, DataSize.Unit.KILOBYTE), 2 * maxPositionsCount + 1, (List<Type>)ImmutableList.of((Object)BigintType.BIGINT), (List<Page>)ImmutableList.of((Object)new Page(new Block[]{BlockAssertions.createLongSequenceBlock(0, maxPositionsCount + 1)}), (Object)new Page(new Block[]{BlockAssertions.createLongSequenceBlock(0, maxPositionsCount + 1)})), (List<TupleDomain<String>>)ImmutableList.of((Object)TupleDomain.all()));
    }
}

