/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.execution.Lifespan;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.JoinBridgeManager;
import com.facebook.presto.operator.NestedLoopBuildOperator;
import com.facebook.presto.operator.NestedLoopJoinBridge;
import com.facebook.presto.operator.NestedLoopJoinPages;
import com.facebook.presto.operator.NestedLoopJoinPagesSupplier;
import com.facebook.presto.operator.PipelineExecutionStrategy;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.testing.TestingTaskContext;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestNestedLoopBuildOperator {
    private ExecutorService executor;
    private ScheduledExecutorService scheduledExecutor;

    @BeforeClass
    public void setUp() {
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test-executor-%s"));
        this.scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)"test-scheduledExecutor-%s"));
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.executor.shutdownNow();
        this.scheduledExecutor.shutdownNow();
    }

    @Test
    public void testNestedLoopBuild() throws Exception {
        TaskContext taskContext = this.createTaskContext();
        ImmutableList buildTypes = ImmutableList.of((Object)BigintType.BIGINT);
        JoinBridgeManager nestedLoopJoinBridgeManager = new JoinBridgeManager(false, PipelineExecutionStrategy.UNGROUPED_EXECUTION, PipelineExecutionStrategy.UNGROUPED_EXECUTION, NestedLoopJoinPagesSupplier::new, (List)buildTypes);
        NestedLoopBuildOperator.NestedLoopBuildOperatorFactory nestedLoopBuildOperatorFactory = new NestedLoopBuildOperator.NestedLoopBuildOperatorFactory(3, new PlanNodeId("test"), nestedLoopJoinBridgeManager);
        DriverContext driverContext = taskContext.addPipelineContext(0, true, true, false).addDriverContext();
        NestedLoopBuildOperator nestedLoopBuildOperator = (NestedLoopBuildOperator)nestedLoopBuildOperatorFactory.createOperator(driverContext);
        NestedLoopJoinBridge nestedLoopJoinBridge = (NestedLoopJoinBridge)nestedLoopJoinBridgeManager.getJoinBridge(Lifespan.taskWide());
        Assert.assertFalse((boolean)nestedLoopJoinBridge.getPagesFuture().isDone());
        Page buildPage1 = new Page(3, new Block[]{BlockAssertions.createLongSequenceBlock(11, 14)});
        Page buildPageEmpty = new Page(0);
        Page buildPage2 = new Page(3000, new Block[]{BlockAssertions.createLongSequenceBlock(4000, 7000)});
        nestedLoopBuildOperator.addInput(buildPage1);
        nestedLoopBuildOperator.addInput(buildPageEmpty);
        nestedLoopBuildOperator.addInput(buildPage2);
        nestedLoopBuildOperator.finish();
        Assert.assertTrue((boolean)nestedLoopJoinBridge.getPagesFuture().isDone());
        List buildPages = ((NestedLoopJoinPages)nestedLoopJoinBridge.getPagesFuture().get()).getPages();
        Assert.assertEquals(buildPages.get(0), (Object)buildPage1);
        Assert.assertEquals(buildPages.get(1), (Object)buildPage2);
        Assert.assertEquals((int)buildPages.size(), (int)2);
    }

    @Test
    public void testNestedLoopBuildNoBlock() throws Exception {
        TaskContext taskContext = this.createTaskContext();
        ImmutableList buildTypes = ImmutableList.of();
        JoinBridgeManager nestedLoopJoinBridgeManager = new JoinBridgeManager(false, PipelineExecutionStrategy.UNGROUPED_EXECUTION, PipelineExecutionStrategy.UNGROUPED_EXECUTION, NestedLoopJoinPagesSupplier::new, (List)buildTypes);
        NestedLoopBuildOperator.NestedLoopBuildOperatorFactory nestedLoopBuildOperatorFactory = new NestedLoopBuildOperator.NestedLoopBuildOperatorFactory(3, new PlanNodeId("test"), nestedLoopJoinBridgeManager);
        DriverContext driverContext = taskContext.addPipelineContext(0, true, true, false).addDriverContext();
        NestedLoopBuildOperator nestedLoopBuildOperator = (NestedLoopBuildOperator)nestedLoopBuildOperatorFactory.createOperator(driverContext);
        NestedLoopJoinBridge nestedLoopJoinBridge = (NestedLoopJoinBridge)nestedLoopJoinBridgeManager.getJoinBridge(Lifespan.taskWide());
        Assert.assertFalse((boolean)nestedLoopJoinBridge.getPagesFuture().isDone());
        Page buildPage1 = new Page(3);
        Page buildPageEmpty = new Page(0);
        Page buildPage2 = new Page(3000);
        nestedLoopBuildOperator.addInput(buildPage1);
        nestedLoopBuildOperator.addInput(buildPageEmpty);
        nestedLoopBuildOperator.addInput(buildPage2);
        nestedLoopBuildOperator.finish();
        Assert.assertTrue((boolean)nestedLoopJoinBridge.getPagesFuture().isDone());
        List buildPages = ((NestedLoopJoinPages)nestedLoopJoinBridge.getPagesFuture().get()).getPages();
        Assert.assertEquals((int)buildPages.size(), (int)1);
        Assert.assertEquals((int)((Page)buildPages.get(0)).getPositionCount(), (int)3003);
    }

    @Test
    public void testNestedLoopNoBlocksMaxSizeLimit() throws Exception {
        TaskContext taskContext = this.createTaskContext();
        ImmutableList buildTypes = ImmutableList.of();
        JoinBridgeManager nestedLoopJoinBridgeManager = new JoinBridgeManager(false, PipelineExecutionStrategy.UNGROUPED_EXECUTION, PipelineExecutionStrategy.UNGROUPED_EXECUTION, NestedLoopJoinPagesSupplier::new, (List)buildTypes);
        NestedLoopBuildOperator.NestedLoopBuildOperatorFactory nestedLoopBuildOperatorFactory = new NestedLoopBuildOperator.NestedLoopBuildOperatorFactory(3, new PlanNodeId("test"), nestedLoopJoinBridgeManager);
        DriverContext driverContext = taskContext.addPipelineContext(0, true, true, false).addDriverContext();
        NestedLoopBuildOperator nestedLoopBuildOperator = (NestedLoopBuildOperator)nestedLoopBuildOperatorFactory.createOperator(driverContext);
        NestedLoopJoinBridge nestedLoopJoinBridge = (NestedLoopJoinBridge)nestedLoopJoinBridgeManager.getJoinBridge(Lifespan.taskWide());
        Assert.assertFalse((boolean)nestedLoopJoinBridge.getPagesFuture().isDone());
        Page massivePage = new Page(8292);
        nestedLoopBuildOperator.addInput(massivePage);
        nestedLoopBuildOperator.finish();
        Assert.assertTrue((boolean)nestedLoopJoinBridge.getPagesFuture().isDone());
        List buildPages = ((NestedLoopJoinPages)nestedLoopJoinBridge.getPagesFuture().get()).getPages();
        Assert.assertEquals((int)buildPages.size(), (int)2);
        Assert.assertEquals((int)((Page)buildPages.get(0)).getPositionCount(), (int)8192);
        Assert.assertEquals((int)((Page)buildPages.get(1)).getPositionCount(), (int)100);
    }

    private TaskContext createTaskContext() {
        return TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION);
    }
}

