/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.drift.codec.ThriftCodec;
import com.facebook.drift.codec.ThriftCodecManager;
import com.facebook.drift.codec.internal.ThriftCodecFactory;
import com.facebook.drift.codec.internal.compiler.CompilerThriftCodecFactory;
import com.facebook.drift.codec.internal.reflection.ReflectionThriftCodecFactory;
import com.facebook.drift.codec.metadata.ThriftCatalog;
import com.facebook.drift.codec.utils.DurationToMillisThriftCodec;
import com.facebook.drift.codec.utils.JodaDateTimeToEpochMillisThriftCodec;
import com.facebook.drift.protocol.TBinaryProtocol;
import com.facebook.drift.protocol.TCompactProtocol;
import com.facebook.drift.protocol.TFacebookCompactProtocol;
import com.facebook.drift.protocol.TMemoryBuffer;
import com.facebook.drift.protocol.TProtocol;
import com.facebook.drift.protocol.TProtocolReader;
import com.facebook.drift.protocol.TProtocolWriter;
import com.facebook.drift.protocol.TTransport;
import com.facebook.presto.operator.ExchangeClientStatus;
import com.facebook.presto.operator.OperatorInfoUnion;
import com.facebook.presto.operator.PageBufferClientStatus;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.List;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.Function;
import org.assertj.core.api.Assertions;
import org.joda.time.DateTime;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestOperatorInfoUnionSerde {
    private static final ThriftCatalog COMMON_CATALOG = new ThriftCatalog();
    private static final DurationToMillisThriftCodec DURATION_CODEC = new DurationToMillisThriftCodec(COMMON_CATALOG);
    private static final JodaDateTimeToEpochMillisThriftCodec DATE_TIME_CODEC = new JodaDateTimeToEpochMillisThriftCodec(COMMON_CATALOG);
    private static final ThriftCodecManager COMPILER_READ_CODEC_MANAGER = new ThriftCodecManager((ThriftCodecFactory)new CompilerThriftCodecFactory(false), COMMON_CATALOG, (Set)ImmutableSet.of((Object)DURATION_CODEC, (Object)DATE_TIME_CODEC));
    private static final ThriftCodecManager COMPILER_WRITE_CODEC_MANAGER = new ThriftCodecManager((ThriftCodecFactory)new CompilerThriftCodecFactory(false), COMMON_CATALOG, (Set)ImmutableSet.of((Object)DURATION_CODEC, (Object)DATE_TIME_CODEC));
    private static final ThriftCodec<OperatorInfoUnion> COMPILER_READ_CODEC = COMPILER_READ_CODEC_MANAGER.getCodec(OperatorInfoUnion.class);
    private static final ThriftCodec<OperatorInfoUnion> COMPILER_WRITE_CODEC = COMPILER_WRITE_CODEC_MANAGER.getCodec(OperatorInfoUnion.class);
    private static final ThriftCodecManager REFLECTION_READ_CODEC_MANAGER = new ThriftCodecManager((ThriftCodecFactory)new ReflectionThriftCodecFactory(), COMMON_CATALOG, (Set)ImmutableSet.of((Object)DURATION_CODEC, (Object)DATE_TIME_CODEC));
    private static final ThriftCodecManager REFLECTION_WRITE_CODEC_MANAGER = new ThriftCodecManager((ThriftCodecFactory)new ReflectionThriftCodecFactory(), COMMON_CATALOG, (Set)ImmutableSet.of((Object)DURATION_CODEC, (Object)DATE_TIME_CODEC));
    private static final ThriftCodec<OperatorInfoUnion> REFLECTION_READ_CODEC = REFLECTION_READ_CODEC_MANAGER.getCodec(OperatorInfoUnion.class);
    private static final ThriftCodec<OperatorInfoUnion> REFLECTION_WRITE_CODEC = REFLECTION_WRITE_CODEC_MANAGER.getCodec(OperatorInfoUnion.class);
    private static final TMemoryBuffer transport = new TMemoryBuffer(102400);
    private OperatorInfoUnion operatorInfoUnion;

    @BeforeMethod
    public void setUp() {
        this.operatorInfoUnion = new OperatorInfoUnion(this.getExchangeClientStatus());
    }

    @DataProvider
    public Object[][] codecCombinations() {
        return new Object[][]{{COMPILER_READ_CODEC, COMPILER_WRITE_CODEC}, {COMPILER_READ_CODEC, REFLECTION_WRITE_CODEC}, {REFLECTION_READ_CODEC, COMPILER_WRITE_CODEC}, {REFLECTION_READ_CODEC, REFLECTION_WRITE_CODEC}};
    }

    @Test(dataProvider="codecCombinations")
    public void testRoundTripSerializeBinaryProtocol(ThriftCodec<OperatorInfoUnion> readCodec, ThriftCodec<OperatorInfoUnion> writeCodec) throws Exception {
        OperatorInfoUnion operatorInfoUnion = this.getRoundTripSerialize(readCodec, writeCodec, TBinaryProtocol::new);
        this.assertSerde(operatorInfoUnion);
    }

    @Test(dataProvider="codecCombinations")
    public void testRoundTripSerializeTCompactProtocol(ThriftCodec<OperatorInfoUnion> readCodec, ThriftCodec<OperatorInfoUnion> writeCodec) throws Exception {
        OperatorInfoUnion operatorInfoUnion = this.getRoundTripSerialize(readCodec, writeCodec, TCompactProtocol::new);
        this.assertSerde(operatorInfoUnion);
    }

    @Test(dataProvider="codecCombinations")
    public void testRoundTripSerializeTFacebookCompactProtocol(ThriftCodec<OperatorInfoUnion> readCodec, ThriftCodec<OperatorInfoUnion> writeCodec) throws Exception {
        OperatorInfoUnion operatorInfoUnion = this.getRoundTripSerialize(readCodec, writeCodec, TFacebookCompactProtocol::new);
        this.assertSerde(operatorInfoUnion);
    }

    private OperatorInfoUnion getRoundTripSerialize(ThriftCodec<OperatorInfoUnion> readCodec, ThriftCodec<OperatorInfoUnion> writeCodec, Function<TTransport, TProtocol> protocolFactory) throws Exception {
        TProtocol protocol = protocolFactory.apply((TTransport)transport);
        writeCodec.write((Object)this.operatorInfoUnion, (TProtocolWriter)protocol);
        return (OperatorInfoUnion)readCodec.read((TProtocolReader)protocol);
    }

    private void assertSerde(OperatorInfoUnion operatorInfoUnion) {
        ExchangeClientStatus exchangeClientStatus = operatorInfoUnion.getExchangeClientStatus();
        Assert.assertNotNull((Object)exchangeClientStatus);
        Assertions.assertThat((long)exchangeClientStatus.getBufferedBytes()).isEqualTo(246L);
        Assertions.assertThat((long)exchangeClientStatus.getMaxBufferedBytes()).isEqualTo(762L);
        Assertions.assertThat((long)exchangeClientStatus.getAverageBytesPerRequest()).isEqualTo(4155L);
        Assertions.assertThat((long)exchangeClientStatus.getSuccessfulRequestsCount()).isEqualTo(5708L);
        Assertions.assertThat((int)exchangeClientStatus.getBufferedPages()).isEqualTo(316);
        Assertions.assertThat((boolean)exchangeClientStatus.isNoMoreLocations()).isTrue();
        List pageBufferClientStatuses = exchangeClientStatus.getPageBufferClientStatuses();
        Assert.assertNotNull((Object)pageBufferClientStatuses);
        Assertions.assertThat((List)pageBufferClientStatuses).hasSize(1);
        PageBufferClientStatus pageBufferClientStatus = (PageBufferClientStatus)pageBufferClientStatuses.get(0);
        Assertions.assertThat((URI)pageBufferClientStatus.getUri()).isEqualTo((Object)URI.create("http://fake"));
        Assertions.assertThat((String)pageBufferClientStatus.getState()).isEqualTo((Object)"running");
        Assertions.assertThat((Comparable)pageBufferClientStatus.getLastUpdate()).isEqualTo((Object)new DateTime(2022, 10, 28, 16, 7, 15, 0));
        Assertions.assertThat((long)pageBufferClientStatus.getRowsReceived()).isEqualTo(7174L);
        Assertions.assertThat((int)pageBufferClientStatus.getPagesReceived()).isEqualTo(612);
        Assertions.assertThat((OptionalLong)pageBufferClientStatus.getRowsRejected()).isEqualTo((Object)OptionalLong.of(93L));
        Assertions.assertThat((OptionalInt)pageBufferClientStatus.getPagesRejected()).isEqualTo((Object)OptionalInt.of(12));
        Assertions.assertThat((int)pageBufferClientStatus.getRequestsScheduled()).isEqualTo(2);
        Assertions.assertThat((int)pageBufferClientStatus.getRequestsCompleted()).isEqualTo(71);
        Assertions.assertThat((int)pageBufferClientStatus.getRequestsFailed()).isEqualTo(3);
        Assertions.assertThat((String)pageBufferClientStatus.getHttpRequestState()).isEqualTo((Object)"OK");
    }

    private ExchangeClientStatus getExchangeClientStatus() {
        return new ExchangeClientStatus(246L, 762L, 4155L, 5708L, 316, true, (List)ImmutableList.of((Object)new PageBufferClientStatus(URI.create("http://fake"), "running", new DateTime(2022, 10, 28, 16, 7, 15, 0), 7174L, 612, OptionalLong.of(93L), OptionalInt.of(12), 2, 71, 3, "OK")));
    }
}

