/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.stats.Distribution;
import com.facebook.presto.operator.DriverStats;
import com.facebook.presto.operator.OperatorStats;
import com.facebook.presto.operator.PipelineStats;
import com.facebook.presto.operator.TestDriverStats;
import com.facebook.presto.operator.TestOperatorStats;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestPipelineStats {
    public static final PipelineStats EXPECTED = new PipelineStats(0, new DateTime(100L), new DateTime(101L), new DateTime(102L), true, false, 1, 2, 1, 21L, 3, 2, 22L, 19, 4, 5L, 6L, 7L, TestPipelineStats.getTestDistribution(8), TestPipelineStats.getTestDistribution(9), 10L, 11L, 13L, false, (Set)ImmutableSet.of(), 123L, 14L, 15L, 16L, 17L, 18L, 19L, 20L, (List)ImmutableList.of((Object)TestOperatorStats.EXPECTED), (List)ImmutableList.of((Object)TestDriverStats.EXPECTED));

    @Test
    public void testJson() {
        JsonCodec codec = JsonCodec.jsonCodec(PipelineStats.class);
        String json = codec.toJson((Object)EXPECTED);
        PipelineStats actual = (PipelineStats)codec.fromJson(json);
        TestPipelineStats.assertExpectedPipelineStats(actual);
    }

    public static void assertExpectedPipelineStats(PipelineStats actual) {
        Assert.assertEquals((Object)actual.getFirstStartTime(), (Object)new DateTime(100L, DateTimeZone.UTC));
        Assert.assertEquals((Object)actual.getLastStartTime(), (Object)new DateTime(101L, DateTimeZone.UTC));
        Assert.assertEquals((Object)actual.getLastEndTime(), (Object)new DateTime(102L, DateTimeZone.UTC));
        Assert.assertEquals((boolean)actual.isInputPipeline(), (boolean)true);
        Assert.assertEquals((boolean)actual.isOutputPipeline(), (boolean)false);
        Assert.assertEquals((int)actual.getTotalDrivers(), (int)1);
        Assert.assertEquals((int)actual.getQueuedDrivers(), (int)2);
        Assert.assertEquals((int)actual.getQueuedPartitionedDrivers(), (int)1);
        Assert.assertEquals((long)actual.getQueuedPartitionedSplitsWeight(), (long)21L);
        Assert.assertEquals((int)actual.getRunningDrivers(), (int)3);
        Assert.assertEquals((int)actual.getRunningPartitionedDrivers(), (int)2);
        Assert.assertEquals((long)actual.getRunningPartitionedSplitsWeight(), (long)22L);
        Assert.assertEquals((int)actual.getBlockedDrivers(), (int)19);
        Assert.assertEquals((int)actual.getCompletedDrivers(), (int)4);
        Assert.assertEquals((long)actual.getUserMemoryReservationInBytes(), (long)5L);
        Assert.assertEquals((long)actual.getRevocableMemoryReservationInBytes(), (long)6L);
        Assert.assertEquals((long)actual.getSystemMemoryReservationInBytes(), (long)7L);
        Assert.assertEquals((double)actual.getQueuedTime().getCount(), (double)8.0);
        Assert.assertEquals((double)actual.getElapsedTime().getCount(), (double)9.0);
        Assert.assertEquals((long)actual.getTotalScheduledTimeInNanos(), (long)10L);
        Assert.assertEquals((long)actual.getTotalCpuTimeInNanos(), (long)11L);
        Assert.assertEquals((long)actual.getTotalBlockedTimeInNanos(), (long)13L);
        Assert.assertEquals((long)actual.getTotalAllocationInBytes(), (long)123L);
        Assert.assertEquals((long)actual.getRawInputDataSizeInBytes(), (long)14L);
        Assert.assertEquals((long)actual.getRawInputPositions(), (long)15L);
        Assert.assertEquals((long)actual.getProcessedInputDataSizeInBytes(), (long)16L);
        Assert.assertEquals((long)actual.getProcessedInputPositions(), (long)17L);
        Assert.assertEquals((long)actual.getOutputDataSizeInBytes(), (long)18L);
        Assert.assertEquals((long)actual.getOutputPositions(), (long)19L);
        Assert.assertEquals((long)actual.getPhysicalWrittenDataSizeInBytes(), (long)20L);
        Assert.assertEquals((int)actual.getOperatorSummaries().size(), (int)1);
        TestOperatorStats.assertExpectedOperatorStats((OperatorStats)actual.getOperatorSummaries().get(0));
        Assert.assertEquals((int)actual.getDrivers().size(), (int)1);
        TestDriverStats.assertExpectedDriverStats((DriverStats)actual.getDrivers().get(0));
    }

    private static Distribution.DistributionSnapshot getTestDistribution(int count) {
        Distribution distribution = new Distribution();
        for (int i = 0; i < count; ++i) {
            distribution.add((long)i);
        }
        return distribution.snapshot();
    }
}

