/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.common.block.ArrayAllocator;
import com.facebook.presto.operator.SimpleArrayAllocator;
import com.facebook.presto.operator.UncheckedStackArrayAllocator;
import io.airlift.slice.SizeOf;
import java.util.ArrayDeque;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestSimpleArrayAllocator {
    @Test
    public void testNewLease() {
        SimpleArrayAllocator allocator = new SimpleArrayAllocator(10);
        this.testNewLease((ArrayAllocator)allocator);
        allocator = new UncheckedStackArrayAllocator(10);
        this.testNewLease((ArrayAllocator)allocator);
    }

    @Test
    public void testOverAllocateLeases() {
        SimpleArrayAllocator allocator = new SimpleArrayAllocator(2);
        allocator.borrowIntArray(10);
        allocator.borrowIntArray(10);
        Assert.assertThrows(IllegalStateException.class, () -> allocator.borrowIntArray(10));
    }

    @Test
    public void testReturnArrayNotBorrowed() {
        SimpleArrayAllocator allocator = new SimpleArrayAllocator(2);
        int[] array = allocator.borrowIntArray(10);
        allocator.returnArray(array);
        Assert.assertThrows(IllegalArgumentException.class, () -> allocator.returnArray(array));
    }

    private void testNewLease(ArrayAllocator allocator) {
        int i;
        ArrayDeque<int[]> intArrayList = new ArrayDeque<int[]>();
        for (int i2 = 0; i2 < 5; ++i2) {
            intArrayList.push(allocator.borrowIntArray(10));
        }
        Assert.assertEquals((int)allocator.getBorrowedArrayCount(), (int)5);
        Assert.assertEquals((long)allocator.getEstimatedSizeInBytes(), (long)(SizeOf.sizeOfIntArray((int)10) * 5L));
        ArrayDeque<byte[]> byteArrayList = new ArrayDeque<byte[]>();
        for (i = 0; i < 5; ++i) {
            byteArrayList.push(allocator.borrowByteArray(10));
        }
        Assert.assertEquals((int)allocator.getBorrowedArrayCount(), (int)10);
        Assert.assertEquals((long)allocator.getEstimatedSizeInBytes(), (long)((SizeOf.sizeOfIntArray((int)10) + SizeOf.sizeOfByteArray((int)10)) * 5L));
        for (i = 0; i < 5; ++i) {
            allocator.returnArray((int[])intArrayList.pop());
        }
        Assert.assertEquals((int)allocator.getBorrowedArrayCount(), (int)5);
        Assert.assertEquals((long)allocator.getEstimatedSizeInBytes(), (long)((SizeOf.sizeOfIntArray((int)10) + SizeOf.sizeOfByteArray((int)10)) * 5L));
        for (i = 0; i < 5; ++i) {
            allocator.returnArray((byte[])byteArrayList.pop());
        }
        Assert.assertEquals((int)allocator.getBorrowedArrayCount(), (int)0);
        Assert.assertEquals((long)allocator.getEstimatedSizeInBytes(), (long)((SizeOf.sizeOfIntArray((int)10) + SizeOf.sizeOfByteArray((int)10)) * 5L));
        int[] intBorrowed = allocator.borrowIntArray(101);
        Assert.assertEquals((long)allocator.getEstimatedSizeInBytes(), (long)(SizeOf.sizeOfIntArray((int)101) + SizeOf.sizeOfByteArray((int)10) * 5L));
        allocator.returnArray(intBorrowed);
        Assert.assertEquals((long)allocator.getEstimatedSizeInBytes(), (long)(SizeOf.sizeOfIntArray((int)101) + SizeOf.sizeOfByteArray((int)10) * 5L));
        byte[] byteBorrowed = allocator.borrowByteArray(101);
        Assert.assertEquals((long)allocator.getEstimatedSizeInBytes(), (long)(SizeOf.sizeOfIntArray((int)101) + SizeOf.sizeOfByteArray((int)101)));
        allocator.returnArray(byteBorrowed);
        Assert.assertEquals((long)allocator.getEstimatedSizeInBytes(), (long)(SizeOf.sizeOfIntArray((int)101) + SizeOf.sizeOfByteArray((int)101)));
    }
}

