/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.common.RuntimeStats;
import com.facebook.presto.operator.PipelineStats;
import com.facebook.presto.operator.TaskStats;
import com.facebook.presto.operator.TestPipelineStats;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestTaskStats {
    private static final TaskStats EXPECTED = new TaskStats(new DateTime(1L), new DateTime(2L), new DateTime(100L), new DateTime(101L), new DateTime(3L), 4L, 5L, 6, 7, 5, 28L, 8, 6, 29L, 24, 10, 11.0, 43.0, 12L, 13L, 14L, 26L, 27L, 42L, 15L, 16L, 18L, false, (Set)ImmutableSet.of(), 123L, 19L, 20L, 21L, 22L, 23L, 24L, 25L, 26, 27L, (List)ImmutableList.of((Object)TestPipelineStats.EXPECTED), new RuntimeStats());

    @Test
    public void testJson() {
        JsonCodec codec = JsonCodec.jsonCodec(TaskStats.class);
        String json = codec.toJson((Object)EXPECTED);
        TaskStats actual = (TaskStats)codec.fromJson(json);
        TestTaskStats.assertExpectedTaskStats(actual);
    }

    public static void assertExpectedTaskStats(TaskStats actual) {
        Assert.assertEquals((Object)actual.getCreateTime(), (Object)new DateTime(1L, DateTimeZone.UTC));
        Assert.assertEquals((Object)actual.getFirstStartTime(), (Object)new DateTime(2L, DateTimeZone.UTC));
        Assert.assertEquals((Object)actual.getLastStartTime(), (Object)new DateTime(100L, DateTimeZone.UTC));
        Assert.assertEquals((Object)actual.getLastEndTime(), (Object)new DateTime(101L, DateTimeZone.UTC));
        Assert.assertEquals((Object)actual.getEndTime(), (Object)new DateTime(3L, DateTimeZone.UTC));
        Assert.assertEquals((long)actual.getElapsedTimeInNanos(), (long)4L);
        Assert.assertEquals((long)actual.getQueuedTimeInNanos(), (long)5L);
        Assert.assertEquals((int)actual.getTotalDrivers(), (int)6);
        Assert.assertEquals((int)actual.getQueuedDrivers(), (int)7);
        Assert.assertEquals((int)actual.getQueuedPartitionedDrivers(), (int)5);
        Assert.assertEquals((long)actual.getQueuedPartitionedSplitsWeight(), (long)28L);
        Assert.assertEquals((int)actual.getRunningDrivers(), (int)8);
        Assert.assertEquals((int)actual.getRunningPartitionedDrivers(), (int)6);
        Assert.assertEquals((long)actual.getRunningPartitionedSplitsWeight(), (long)29L);
        Assert.assertEquals((int)actual.getBlockedDrivers(), (int)24);
        Assert.assertEquals((int)actual.getCompletedDrivers(), (int)10);
        Assert.assertEquals((double)actual.getCumulativeUserMemory(), (double)11.0);
        Assert.assertEquals((long)actual.getUserMemoryReservationInBytes(), (long)12L);
        Assert.assertEquals((long)actual.getRevocableMemoryReservationInBytes(), (long)13L);
        Assert.assertEquals((long)actual.getSystemMemoryReservationInBytes(), (long)14L);
        Assert.assertEquals((long)actual.getPeakTotalMemoryInBytes(), (long)26L);
        Assert.assertEquals((long)actual.getPeakNodeTotalMemoryInBytes(), (long)42L);
        Assert.assertEquals((long)actual.getTotalScheduledTimeInNanos(), (long)15L);
        Assert.assertEquals((long)actual.getTotalCpuTimeInNanos(), (long)16L);
        Assert.assertEquals((long)actual.getTotalBlockedTimeInNanos(), (long)18L);
        Assert.assertEquals((long)actual.getTotalAllocationInBytes(), (long)123L);
        Assert.assertEquals((long)actual.getRawInputDataSizeInBytes(), (long)19L);
        Assert.assertEquals((long)actual.getRawInputPositions(), (long)20L);
        Assert.assertEquals((long)actual.getProcessedInputDataSizeInBytes(), (long)21L);
        Assert.assertEquals((long)actual.getProcessedInputPositions(), (long)22L);
        Assert.assertEquals((long)actual.getOutputDataSizeInBytes(), (long)23L);
        Assert.assertEquals((long)actual.getOutputPositions(), (long)24L);
        Assert.assertEquals((long)actual.getPhysicalWrittenDataSizeInBytes(), (long)25L);
        Assert.assertEquals((int)actual.getPipelines().size(), (int)1);
        TestPipelineStats.assertExpectedPipelineStats((PipelineStats)actual.getPipelines().get(0));
    }
}

