/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.operator.aggregation.AbstractTestAggregationFunction;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.testng.annotations.Test;

public abstract class AbstractTestRealRegrAggregationFunction
extends AbstractTestAggregationFunction {
    @Override
    public Block[] getSequenceBlocks(int start, int length) {
        return new Block[]{BlockAssertions.createSequenceBlockOfReal(start, start + length), BlockAssertions.createSequenceBlockOfReal(start + 2, start + 2 + length)};
    }

    @Override
    protected List<String> getFunctionParameterTypes() {
        return ImmutableList.of((Object)"real", (Object)"real");
    }

    @Override
    @Test
    public void testSinglePosition() {
        this.testAggregation(this.getExpectedValue(0, 2), this.getSequenceBlocks(0, 2));
    }

    @Test
    public void testNonTrivialResult() {
        this.testNonTrivialAggregation(new Float[]{Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(3.0f), Float.valueOf(4.0f), Float.valueOf(5.0f)}, new Float[]{Float.valueOf(1.0f), Float.valueOf(4.0f), Float.valueOf(9.0f), Float.valueOf(16.0f), Float.valueOf(25.0f)});
        this.testNonTrivialAggregation(new Float[]{Float.valueOf(1.0f), Float.valueOf(4.0f), Float.valueOf(9.0f), Float.valueOf(16.0f), Float.valueOf(25.0f)}, new Float[]{Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(3.0f), Float.valueOf(4.0f), Float.valueOf(5.0f)});
    }

    protected abstract void testNonTrivialAggregation(Float[] var1, Float[] var2);
}

