/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.VariableWidthBlockBuilder;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.UnscaledDecimal128Arithmetic;
import com.facebook.presto.operator.aggregation.DecimalSumAggregation;
import com.facebook.presto.operator.aggregation.state.LongDecimalWithOverflowState;
import com.facebook.presto.operator.aggregation.state.LongDecimalWithOverflowStateFactory;
import io.airlift.slice.Slice;
import java.math.BigInteger;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestDecimalSumAggregation {
    private static final BigInteger TWO = new BigInteger("2");
    private static final DecimalType TYPE = DecimalType.createDecimalType((int)38, (int)0);
    private LongDecimalWithOverflowState state;

    @BeforeMethod
    public void setUp() {
        this.state = new LongDecimalWithOverflowStateFactory().createSingleState();
    }

    @Test
    public void testOverflow() {
        TestDecimalSumAggregation.addToState(this.state, TWO.pow(126));
        Assert.assertEquals((long)this.state.getOverflow(), (long)0L);
        Assert.assertEquals((Object)this.state.getLongDecimal(), (Object)UnscaledDecimal128Arithmetic.unscaledDecimal((BigInteger)TWO.pow(126)));
        TestDecimalSumAggregation.addToState(this.state, TWO.pow(126));
        Assert.assertEquals((long)this.state.getOverflow(), (long)1L);
        Assert.assertEquals((Object)this.state.getLongDecimal(), (Object)UnscaledDecimal128Arithmetic.unscaledDecimal((long)0L));
    }

    @Test
    public void testUnderflow() {
        TestDecimalSumAggregation.addToState(this.state, TWO.pow(126).negate());
        Assert.assertEquals((long)this.state.getOverflow(), (long)0L);
        Assert.assertEquals((Object)this.state.getLongDecimal(), (Object)UnscaledDecimal128Arithmetic.unscaledDecimal((BigInteger)TWO.pow(126).negate()));
        TestDecimalSumAggregation.addToState(this.state, TWO.pow(126).negate());
        Assert.assertEquals((long)this.state.getOverflow(), (long)-1L);
        Assert.assertEquals((int)UnscaledDecimal128Arithmetic.compare((Slice)this.state.getLongDecimal(), (Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((long)0L)), (int)0);
    }

    @Test
    public void testUnderflowAfterOverflow() {
        TestDecimalSumAggregation.addToState(this.state, TWO.pow(126));
        TestDecimalSumAggregation.addToState(this.state, TWO.pow(126));
        TestDecimalSumAggregation.addToState(this.state, TWO.pow(125));
        Assert.assertEquals((long)this.state.getOverflow(), (long)1L);
        Assert.assertEquals((Object)this.state.getLongDecimal(), (Object)UnscaledDecimal128Arithmetic.unscaledDecimal((BigInteger)TWO.pow(125)));
        TestDecimalSumAggregation.addToState(this.state, TWO.pow(126).negate());
        TestDecimalSumAggregation.addToState(this.state, TWO.pow(126).negate());
        TestDecimalSumAggregation.addToState(this.state, TWO.pow(126).negate());
        Assert.assertEquals((long)this.state.getOverflow(), (long)0L);
        Assert.assertEquals((Object)this.state.getLongDecimal(), (Object)UnscaledDecimal128Arithmetic.unscaledDecimal((BigInteger)TWO.pow(125).negate()));
    }

    @Test
    public void testCombineOverflow() {
        TestDecimalSumAggregation.addToState(this.state, TWO.pow(125));
        TestDecimalSumAggregation.addToState(this.state, TWO.pow(126));
        LongDecimalWithOverflowState otherState = new LongDecimalWithOverflowStateFactory().createSingleState();
        TestDecimalSumAggregation.addToState(otherState, TWO.pow(125));
        TestDecimalSumAggregation.addToState(otherState, TWO.pow(126));
        DecimalSumAggregation.combine((LongDecimalWithOverflowState)this.state, (LongDecimalWithOverflowState)otherState);
        Assert.assertEquals((long)this.state.getOverflow(), (long)1L);
        Assert.assertEquals((Object)this.state.getLongDecimal(), (Object)UnscaledDecimal128Arithmetic.unscaledDecimal((BigInteger)TWO.pow(126)));
    }

    @Test
    public void testCombineUnderflow() {
        TestDecimalSumAggregation.addToState(this.state, TWO.pow(125).negate());
        TestDecimalSumAggregation.addToState(this.state, TWO.pow(126).negate());
        LongDecimalWithOverflowState otherState = new LongDecimalWithOverflowStateFactory().createSingleState();
        TestDecimalSumAggregation.addToState(otherState, TWO.pow(125).negate());
        TestDecimalSumAggregation.addToState(otherState, TWO.pow(126).negate());
        DecimalSumAggregation.combine((LongDecimalWithOverflowState)this.state, (LongDecimalWithOverflowState)otherState);
        Assert.assertEquals((long)this.state.getOverflow(), (long)-1L);
        Assert.assertEquals((Object)this.state.getLongDecimal(), (Object)UnscaledDecimal128Arithmetic.unscaledDecimal((BigInteger)TWO.pow(126).negate()));
    }

    @Test(expectedExceptions={ArithmeticException.class})
    public void testOverflowOnOutput() {
        TestDecimalSumAggregation.addToState(this.state, TWO.pow(126));
        TestDecimalSumAggregation.addToState(this.state, TWO.pow(126));
        Assert.assertEquals((long)this.state.getOverflow(), (long)1L);
        DecimalSumAggregation.outputLongDecimal((LongDecimalWithOverflowState)this.state, (BlockBuilder)new VariableWidthBlockBuilder(null, 10, 100));
    }

    private static void addToState(LongDecimalWithOverflowState state, BigInteger value) {
        BlockBuilder blockBuilder = TYPE.createFixedSizeBlockBuilder(1);
        TYPE.writeSlice(blockBuilder, UnscaledDecimal128Arithmetic.unscaledDecimal((BigInteger)value));
        if (TYPE.isShort()) {
            DecimalSumAggregation.inputShortDecimal((LongDecimalWithOverflowState)state, (Block)blockBuilder.build(), (int)0);
        } else {
            DecimalSumAggregation.inputLongDecimal((LongDecimalWithOverflowState)state, (Block)blockBuilder.build(), (int)0);
        }
    }
}

