/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.operator.aggregation.AbstractTestDoubleRegrAggregationFunction;
import com.google.common.base.Preconditions;
import org.apache.commons.math3.stat.regression.SimpleRegression;

public class TestDoubleRegrSyyAggregation
extends AbstractTestDoubleRegrAggregationFunction {
    @Override
    protected String getFunctionName() {
        return "regr_syy";
    }

    @Override
    public Object getExpectedValue(int start, int length) {
        if (length == 0) {
            return null;
        }
        if (length <= 1) {
            return 0.0;
        }
        SimpleRegression regression = new SimpleRegression();
        for (int i = start; i < start + length; ++i) {
            regression.addData((double)(i + 2), (double)i);
        }
        return regression.getTotalSumSquares();
    }

    @Override
    protected void testNonTrivialAggregation(Double[] y, Double[] x) {
        SimpleRegression regression = new SimpleRegression();
        for (int i = 0; i < x.length; ++i) {
            regression.addData(x[i].doubleValue(), y[i].doubleValue());
        }
        double expected = regression.getTotalSumSquares();
        Preconditions.checkArgument((Double.isFinite(expected) && expected != 0.0 ? 1 : 0) != 0, (Object)"Expected result is trivial");
        this.testAggregation(expected, BlockAssertions.createDoublesBlock(y), BlockAssertions.createDoublesBlock(x));
    }
}

