/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.operator.aggregation.AbstractTestAggregationFunction;
import com.facebook.presto.operator.aggregation.AggregationTestUtils;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.function.JavaAggregationFunctionImplementation;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestEntropyAggregation
extends AbstractTestAggregationFunction {
    private static final String FUNCTION_NAME = "entropy";
    private JavaAggregationFunctionImplementation entropyFunction;

    @BeforeClass
    public void setUp() {
        FunctionAndTypeManager functionAndTypeManager = MetadataManager.createTestMetadataManager().getFunctionAndTypeManager();
        this.entropyFunction = functionAndTypeManager.getJavaAggregateFunctionImplementation(functionAndTypeManager.lookupFunction(FUNCTION_NAME, TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT})));
    }

    @Test
    public void entropyOfASingle() {
        AggregationTestUtils.assertAggregation(this.entropyFunction, (Object)0.0, BlockAssertions.createLongsBlock(1L));
    }

    @Test
    public void entropyOfTwoEquals() {
        Long x = 1L;
        AggregationTestUtils.assertAggregation(this.entropyFunction, (Object)1.0, BlockAssertions.createLongsBlock(x, x));
        x = 20L;
        AggregationTestUtils.assertAggregation(this.entropyFunction, (Object)1.0, BlockAssertions.createLongsBlock(x, x));
    }

    @Test
    public void entropyOfTwoEqualsWithNulls() {
        Long x = 1L;
        AggregationTestUtils.assertAggregation(this.entropyFunction, (Object)1.0, BlockAssertions.createLongsBlock(x, null, x));
        x = 10L;
        AggregationTestUtils.assertAggregation(this.entropyFunction, (Object)1.0, BlockAssertions.createLongsBlock(null, null, x, x));
    }

    @Test
    public void entropyOfTwoSkewed() {
        Long lower = 30L;
        Long higher = 70L;
        Double expected = 0.8812908992306931;
        AggregationTestUtils.assertAggregation(this.entropyFunction, (Object)expected, BlockAssertions.createLongsBlock(lower, higher));
        AggregationTestUtils.assertAggregation(this.entropyFunction, (Object)expected, BlockAssertions.createLongsBlock(higher, lower));
    }

    @Test
    public void entropyOfOnlyNulls() {
        AggregationTestUtils.assertAggregation(this.entropyFunction, (Object)0.0, BlockAssertions.createLongsBlock(null, null));
    }

    @Test
    public void entropyOfNegativeCount() {
        String error = "";
        try {
            AggregationTestUtils.assertAggregation(this.entropyFunction, (Object)0.0, BlockAssertions.createLongsBlock(-1L));
        }
        catch (PrestoException e) {
            error = e.getMessage();
        }
        Assert.assertTrue((boolean)error.toLowerCase(Locale.ENGLISH).contains("negative"));
    }

    @Override
    public Block[] getSequenceBlocks(int start, int length) {
        BlockBuilder blockBuilder = BigintType.BIGINT.createBlockBuilder(null, length);
        for (int i = start; i < start + length; ++i) {
            BigintType.BIGINT.writeLong(blockBuilder, (long)Math.abs(i));
        }
        return new Block[]{blockBuilder.build()};
    }

    @Override
    public Number getExpectedValue(int start, int length) {
        ArrayList counts = IntStream.range(start, start + length).map(c -> Math.abs(c)).boxed().collect(Collectors.toCollection(ArrayList::new));
        if (counts.stream().anyMatch(c -> c < 0)) {
            return null;
        }
        double sum = counts.stream().mapToDouble(c -> Math.max((double)c.intValue(), 0.0)).sum();
        if (sum == 0.0) {
            return 0.0;
        }
        ArrayList entropies = counts.stream().filter(c -> c > 0).map(c -> (double)c.intValue() / sum * Math.log(sum / (double)c.intValue())).collect(Collectors.toCollection(ArrayList::new));
        return entropies.isEmpty() ? 0.0 : entropies.stream().mapToDouble(c -> c).sum() / Math.log(2.0);
    }

    @Override
    protected String getFunctionName() {
        return FUNCTION_NAME;
    }

    @Override
    protected List<String> getFunctionParameterTypes() {
        return ImmutableList.of((Object)"integer");
    }
}

