/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.operator.OperatorAssertion;
import com.facebook.presto.operator.aggregation.AggregationTestUtils;
import com.facebook.presto.spi.function.JavaAggregationFunctionImplementation;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.util.StructuralTestUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.testng.annotations.Test;

public class TestMapAggAggregation {
    private static final FunctionAndTypeManager FUNCTION_AND_TYPE_MANAGER = MetadataManager.createTestMetadataManager().getFunctionAndTypeManager();

    @Test
    public void testDuplicateKeysValues() {
        JavaAggregationFunctionImplementation aggFunc = this.getAggregation(new Type[]{DoubleType.DOUBLE, VarcharType.VARCHAR});
        AggregationTestUtils.assertAggregation(aggFunc, (Object)ImmutableMap.of((Object)1.0, (Object)"a"), BlockAssertions.createDoublesBlock(1.0, 1.0, 1.0), BlockAssertions.createStringsBlock("a", "b", "c"));
        aggFunc = this.getAggregation(new Type[]{DoubleType.DOUBLE, IntegerType.INTEGER});
        AggregationTestUtils.assertAggregation(aggFunc, (Object)ImmutableMap.of((Object)1.0, (Object)99, (Object)2.0, (Object)99, (Object)3.0, (Object)99), BlockAssertions.createDoublesBlock(1.0, 2.0, 3.0), BlockAssertions.createTypedLongsBlock((Type)IntegerType.INTEGER, (Iterable<Long>)ImmutableList.of((Object)99L, (Object)99L, (Object)99L)));
    }

    @Test
    public void testSimpleMaps() {
        JavaAggregationFunctionImplementation aggFunc = this.getAggregation(new Type[]{DoubleType.DOUBLE, VarcharType.VARCHAR});
        AggregationTestUtils.assertAggregation(aggFunc, (Object)ImmutableMap.of((Object)1.0, (Object)"a", (Object)2.0, (Object)"b", (Object)3.0, (Object)"c"), BlockAssertions.createDoublesBlock(1.0, 2.0, 3.0), BlockAssertions.createStringsBlock("a", "b", "c"));
        aggFunc = this.getAggregation(new Type[]{DoubleType.DOUBLE, IntegerType.INTEGER});
        AggregationTestUtils.assertAggregation(aggFunc, (Object)ImmutableMap.of((Object)1.0, (Object)3, (Object)2.0, (Object)2, (Object)3.0, (Object)1), BlockAssertions.createDoublesBlock(1.0, 2.0, 3.0), BlockAssertions.createTypedLongsBlock((Type)IntegerType.INTEGER, (Iterable<Long>)ImmutableList.of((Object)3L, (Object)2L, (Object)1L)));
        aggFunc = this.getAggregation(new Type[]{DoubleType.DOUBLE, BooleanType.BOOLEAN});
        AggregationTestUtils.assertAggregation(aggFunc, (Object)ImmutableMap.of((Object)1.0, (Object)true, (Object)2.0, (Object)false, (Object)3.0, (Object)false), BlockAssertions.createDoublesBlock(1.0, 2.0, 3.0), BlockAssertions.createBooleansBlock(true, false, false));
    }

    @Test
    public void testNull() {
        JavaAggregationFunctionImplementation doubleDouble = this.getAggregation(new Type[]{DoubleType.DOUBLE, DoubleType.DOUBLE});
        AggregationTestUtils.assertAggregation(doubleDouble, (Object)ImmutableMap.of((Object)1.0, (Object)2.0), BlockAssertions.createDoublesBlock(1.0, null, null), BlockAssertions.createDoublesBlock(2.0, 3.0, 4.0));
        AggregationTestUtils.assertAggregation(doubleDouble, null, BlockAssertions.createDoublesBlock(null, null, null), BlockAssertions.createDoublesBlock(2.0, 3.0, 4.0));
        LinkedHashMap<Double, Object> expected = new LinkedHashMap<Double, Object>();
        expected.put(1.0, null);
        expected.put(2.0, null);
        expected.put(3.0, null);
        AggregationTestUtils.assertAggregation(doubleDouble, expected, BlockAssertions.createDoublesBlock(1.0, 2.0, 3.0), BlockAssertions.createDoublesBlock(null, null, null));
    }

    @Test
    public void testDoubleArrayMap() {
        JavaAggregationFunctionImplementation aggFunc = this.getAggregation(new Type[]{DoubleType.DOUBLE, new ArrayType((Type)VarcharType.VARCHAR)});
        AggregationTestUtils.assertAggregation(aggFunc, (Object)ImmutableMap.of((Object)1.0, (Object)ImmutableList.of((Object)"a", (Object)"b"), (Object)2.0, (Object)ImmutableList.of((Object)"c", (Object)"d"), (Object)3.0, (Object)ImmutableList.of((Object)"e", (Object)"f")), BlockAssertions.createDoublesBlock(1.0, 2.0, 3.0), BlockAssertions.createStringArraysBlock((Iterable<? extends Iterable<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"a", (Object)"b"), (Object)ImmutableList.of((Object)"c", (Object)"d"), (Object)ImmutableList.of((Object)"e", (Object)"f"))));
    }

    @Test
    public void testDoubleMapMap() {
        MapType innerMapType = StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR);
        JavaAggregationFunctionImplementation aggFunc = this.getAggregation(new Type[]{DoubleType.DOUBLE, innerMapType});
        BlockBuilder builder = innerMapType.createBlockBuilder(null, 3);
        innerMapType.writeObject(builder, (Object)StructuralTestUtil.mapBlockOf((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR, ImmutableMap.of((Object)"a", (Object)"b")));
        innerMapType.writeObject(builder, (Object)StructuralTestUtil.mapBlockOf((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR, ImmutableMap.of((Object)"c", (Object)"d")));
        innerMapType.writeObject(builder, (Object)StructuralTestUtil.mapBlockOf((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR, ImmutableMap.of((Object)"e", (Object)"f")));
        AggregationTestUtils.assertAggregation(aggFunc, (Object)ImmutableMap.of((Object)1.0, (Object)ImmutableMap.of((Object)"a", (Object)"b"), (Object)2.0, (Object)ImmutableMap.of((Object)"c", (Object)"d"), (Object)3.0, (Object)ImmutableMap.of((Object)"e", (Object)"f")), BlockAssertions.createDoublesBlock(1.0, 2.0, 3.0), builder.build());
    }

    @Test
    public void testDoubleRowMap() {
        RowType innerRowType = RowType.from((List)ImmutableList.of((Object)RowType.field((String)"f1", (Type)IntegerType.INTEGER), (Object)RowType.field((String)"f2", (Type)DoubleType.DOUBLE)));
        JavaAggregationFunctionImplementation aggFunc = this.getAggregation(new Type[]{DoubleType.DOUBLE, innerRowType});
        BlockBuilder builder = innerRowType.createBlockBuilder(null, 3);
        innerRowType.writeObject(builder, (Object)OperatorAssertion.toRow((List<Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)DoubleType.DOUBLE), 1L, 1.0));
        innerRowType.writeObject(builder, (Object)OperatorAssertion.toRow((List<Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)DoubleType.DOUBLE), 2L, 2.0));
        innerRowType.writeObject(builder, (Object)OperatorAssertion.toRow((List<Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)DoubleType.DOUBLE), 3L, 3.0));
        AggregationTestUtils.assertAggregation(aggFunc, (Object)ImmutableMap.of((Object)1.0, (Object)ImmutableList.of((Object)1, (Object)1.0), (Object)2.0, (Object)ImmutableList.of((Object)2, (Object)2.0), (Object)3.0, (Object)ImmutableList.of((Object)3, (Object)3.0)), BlockAssertions.createDoublesBlock(1.0, 2.0, 3.0), builder.build());
    }

    @Test
    public void testArrayDoubleMap() {
        JavaAggregationFunctionImplementation aggFunc = this.getAggregation(new Type[]{new ArrayType((Type)VarcharType.VARCHAR), DoubleType.DOUBLE});
        AggregationTestUtils.assertAggregation(aggFunc, (Object)ImmutableMap.of((Object)ImmutableList.of((Object)"a", (Object)"b"), (Object)1.0, (Object)ImmutableList.of((Object)"c", (Object)"d"), (Object)2.0, (Object)ImmutableList.of((Object)"e", (Object)"f"), (Object)3.0), BlockAssertions.createStringArraysBlock((Iterable<? extends Iterable<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"a", (Object)"b"), (Object)ImmutableList.of((Object)"c", (Object)"d"), (Object)ImmutableList.of((Object)"e", (Object)"f"))), BlockAssertions.createDoublesBlock(1.0, 2.0, 3.0));
    }

    private JavaAggregationFunctionImplementation getAggregation(Type ... arguments) {
        return FUNCTION_AND_TYPE_MANAGER.getJavaAggregateFunctionImplementation(FUNCTION_AND_TYPE_MANAGER.lookupFunction("map_agg", TypeSignatureProvider.fromTypes((Type[])arguments)));
    }
}

