/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.airlift.stats.cardinality.HyperLogLog;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.HyperLogLogType;
import com.facebook.presto.common.type.SqlVarbinary;
import com.facebook.presto.operator.aggregation.AbstractTestAggregationFunction;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class TestMergeHyperLogLogAggregation
extends AbstractTestAggregationFunction {
    private static final int NUMBER_OF_BUCKETS = 16;

    @Override
    public Block[] getSequenceBlocks(int start, int length) {
        BlockBuilder blockBuilder = HyperLogLogType.HYPER_LOG_LOG.createBlockBuilder(null, length);
        for (int i = start; i < start + length; ++i) {
            HyperLogLog hll = HyperLogLog.newInstance((int)16);
            hll.add((long)i);
            hll.makeDense();
            HyperLogLogType.HYPER_LOG_LOG.writeSlice(blockBuilder, hll.serialize());
        }
        return new Block[]{blockBuilder.build()};
    }

    @Override
    protected String getFunctionName() {
        return "merge";
    }

    @Override
    protected List<String> getFunctionParameterTypes() {
        return ImmutableList.of((Object)"HyperLogLog");
    }

    @Override
    public Object getExpectedValue(int start, int length) {
        if (length == 0) {
            return null;
        }
        HyperLogLog hll = HyperLogLog.newInstance((int)16);
        for (int i = start; i < start + length; ++i) {
            hll.add((long)i);
        }
        hll.makeDense();
        return new SqlVarbinary(hll.serialize().getBytes());
    }
}

