/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.operator.aggregation.AbstractTestRealRegrAggregationFunction;
import com.google.common.base.Preconditions;

public class TestRealRegrAvgxAggregation
extends AbstractTestRealRegrAggregationFunction {
    @Override
    protected String getFunctionName() {
        return "regr_avgx";
    }

    @Override
    public Object getExpectedValue(int start, int length) {
        if (length == 0) {
            return null;
        }
        float expected = 0.0f;
        for (int i = start; i < start + length; ++i) {
            expected += (float)(i + 2);
        }
        return Float.valueOf(expected / (float)length);
    }

    @Override
    protected void testNonTrivialAggregation(Float[] y, Float[] x) {
        float expected = 0.0f;
        for (int i = 0; i < x.length; ++i) {
            expected += x[i].floatValue();
        }
        Preconditions.checkArgument((Float.isFinite(expected /= (float)x.length) && expected != 0.0f ? 1 : 0) != 0, (Object)"Expected result is trivial");
        this.testAggregation(Float.valueOf(expected), BlockAssertions.createBlockOfReals(y), BlockAssertions.createBlockOfReals(x));
    }
}

