/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.SqlVarbinary;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.operator.aggregation.AggregationTestUtils;
import com.facebook.presto.operator.aggregation.TestMergeTDigestFunction;
import com.facebook.presto.operator.aggregation.TestStatisticalDigestAggregationFunction;
import com.facebook.presto.spi.function.JavaAggregationFunctionImplementation;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.tdigest.TDigest;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class TestTDigestAggregationFunction
extends TestStatisticalDigestAggregationFunction {
    private static final double STANDARD_COMPRESSION_FACTOR = 100.0;

    @Override
    protected double getParameter() {
        return 100.0;
    }

    @Override
    protected JavaAggregationFunctionImplementation getAggregationFunction(Type ... type) {
        FunctionAndTypeManager functionAndTypeManager = METADATA.getFunctionAndTypeManager();
        return functionAndTypeManager.getJavaAggregateFunctionImplementation(functionAndTypeManager.lookupFunction("tdigest_agg", TypeSignatureProvider.fromTypes((Type[])type)));
    }

    @Override
    protected void testAggregationDoubles(JavaAggregationFunctionImplementation function, Page page, double error, double ... inputs) {
        AggregationTestUtils.assertAggregation(function, TestMergeTDigestFunction.TDIGEST_EQUALITY, "test multiple positions", page, this.getExpectedValueDoubles(100.0, inputs));
        List rows = Arrays.stream(inputs).sorted().boxed().collect(Collectors.toList());
        SqlVarbinary returned = (SqlVarbinary)AggregationTestUtils.aggregation(function, page);
        this.assertPercentileWithinError("tdigest", "double", returned, 0.01, rows, 0.1, 0.5, 0.9, 0.99);
        this.assertValueWithinError("double", returned, 100.0, rows, 0.1, 0.5, 0.9, 0.99);
    }

    @Override
    protected Object getExpectedValueDoubles(double compression, double ... values) {
        if (values.length == 0) {
            return null;
        }
        TDigest tDigest = TDigest.createTDigest((double)compression);
        Arrays.stream(values).forEach(arg_0 -> ((TDigest)tDigest).add(arg_0));
        return new SqlVarbinary(tDigest.serialize().getBytes());
    }

    private void assertValueWithinError(String type, SqlVarbinary binary, double error, List<? extends Number> rows, double ... percentiles) {
        if (rows.isEmpty()) {
            return;
        }
        for (double percentile : percentiles) {
            this.assertValueWithinError(type, binary, error, rows, percentile);
        }
        this.assertValuesWithinError(type, binary, error, rows, percentiles);
    }

    private void assertValueWithinError(String type, SqlVarbinary binary, double error, List<? extends Number> rows, double percentile) {
        Number lowerBound = this.getLowerBoundQuantile(percentile, error);
        Number upperBound = this.getUpperBoundQuantile(percentile, error);
        this.functionAssertions.assertFunction(String.format("quantile_at_value(CAST(X'%s' AS tdigest(%s)), %s) >= %s", binary.toString().replaceAll("\\s+", " "), type, this.sortNumberList(rows).get((int)((double)rows.size() * percentile)).doubleValue(), lowerBound), (Type)BooleanType.BOOLEAN, true);
        this.functionAssertions.assertFunction(String.format("quantile_at_value(CAST(X'%s' AS tdigest(%s)), %s) <= %s", binary.toString().replaceAll("\\s+", " "), type, this.sortNumberList(rows).get((int)((double)rows.size() * percentile)).doubleValue(), upperBound), (Type)BooleanType.BOOLEAN, true);
    }

    private void assertValuesWithinError(String type, SqlVarbinary binary, double error, List<? extends Number> rows, double[] percentiles) {
        List boxedPercentiles = (List)Arrays.stream(percentiles).sorted().boxed().collect(ImmutableList.toImmutableList());
        List boxedValues = (List)boxedPercentiles.stream().map(percentile -> this.sortNumberList(rows).get((int)((double)rows.size() * percentile)).doubleValue()).collect(ImmutableList.toImmutableList());
        List lowerBounds = (List)boxedPercentiles.stream().map(percentile -> this.getLowerBoundQuantile((double)percentile, error)).collect(ImmutableList.toImmutableList());
        List upperBounds = (List)boxedPercentiles.stream().map(percentile -> this.getUpperBoundQuantile((double)percentile, error)).collect(ImmutableList.toImmutableList());
        this.functionAssertions.assertFunction(String.format("zip_with(quantiles_at_values(CAST(X'%s' AS tdigest(%s)), ARRAY[%s]), ARRAY[%s], (value, lowerbound) -> value >= lowerbound)", binary.toString().replaceAll("\\s+", " "), type, ARRAY_JOINER.join((Iterable)boxedValues), ARRAY_JOINER.join((Iterable)lowerBounds)), METADATA.getType(TypeSignature.parseTypeSignature((String)"array(boolean)")), Collections.nCopies(percentiles.length, true));
        this.functionAssertions.assertFunction(String.format("zip_with(quantiles_at_values(CAST(X'%s' AS tdigest(%s)), ARRAY[%s]), ARRAY[%s], (value, upperbound) -> value <= upperbound)", binary.toString().replaceAll("\\s+", " "), type, ARRAY_JOINER.join((Iterable)boxedValues), ARRAY_JOINER.join((Iterable)upperBounds)), METADATA.getType(TypeSignature.parseTypeSignature((String)"array(boolean)")), Collections.nCopies(percentiles.length, true));
    }

    private Number getLowerBoundQuantile(double quantile, double error) {
        return Math.max(0.0, quantile - error);
    }

    private Number getUpperBoundQuantile(double quantile, double error) {
        return Math.min(1.0, quantile + error);
    }

    private List<? extends Number> sortNumberList(List<? extends Number> list) {
        ArrayList<? extends Number> sorted = new ArrayList<Number>(list);
        Collections.sort(sorted, new Comparator<Number>(){

            @Override
            public int compare(Number o1, Number o2) {
                Double d1 = o1 == null ? Double.POSITIVE_INFINITY : o1.doubleValue();
                Double d2 = o2 == null ? Double.POSITIVE_INFINITY : o2.doubleValue();
                return d1.compareTo(d2);
            }
        });
        return sorted;
    }
}

