/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.SqlVarbinary;
import com.facebook.presto.operator.aggregation.AbstractTestAggregationFunction;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.datasketches.theta.Union;

public class TestThetaSketchAggregationFunction
extends AbstractTestAggregationFunction {
    @Override
    public Block[] getSequenceBlocks(int start, int length) {
        BlockBuilder blockBuilder = DoubleType.DOUBLE.createBlockBuilder(null, length);
        for (int i = start; i < start + length; ++i) {
            DoubleType.DOUBLE.writeDouble(blockBuilder, (double)i);
        }
        return new Block[]{blockBuilder.build()};
    }

    @Override
    protected String getFunctionName() {
        return "sketch_theta";
    }

    @Override
    protected List<String> getFunctionParameterTypes() {
        return ImmutableList.of((Object)"double");
    }

    @Override
    public Object getExpectedValue(int start, int length) {
        Block values = this.getSequenceBlocks(start, length)[0];
        Union union = Union.builder().buildUnion();
        for (int i = 0; i < length; ++i) {
            union.update(DoubleType.DOUBLE.getDouble(values, i));
        }
        return new SqlVarbinary(union.getResult().toByteArray());
    }
}

