/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.differentialentropy;

import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.operator.aggregation.AggregationTestUtils;
import com.facebook.presto.operator.aggregation.differentialentropy.AbstractTestFixedHistogramAggregation;
import com.facebook.presto.spi.PrestoException;
import java.util.ArrayList;
import org.testng.annotations.Test;

public class TestFixedHistogramMleAggregation
extends AbstractTestFixedHistogramAggregation {
    public TestFixedHistogramMleAggregation() {
        super("fixed_histogram_mle");
    }

    @Test(expectedExceptions={PrestoException.class}, expectedExceptionsMessageRegExp="In differential_entropy UDF, bucket count must be non-negative: -200")
    public void testIllegalBucketCount() {
        AggregationTestUtils.aggregation(this.getFunction(), BlockAssertions.createLongsBlock(-200), BlockAssertions.createDoublesBlock(0.1), BlockAssertions.createDoublesBlock(0.2), BlockAssertions.createStringsBlock(this.method), BlockAssertions.createDoublesBlock(0.0), BlockAssertions.createDoublesBlock(0.2));
    }

    @Test(expectedExceptions={PrestoException.class}, expectedExceptionsMessageRegExp="In differential_entropy UDF, weight must be non-negative: -0.2")
    public void testNegativeWeight() {
        AggregationTestUtils.aggregation(this.getFunction(), BlockAssertions.createLongsBlock(200), BlockAssertions.createDoublesBlock(0.1), BlockAssertions.createDoublesBlock(-0.2), BlockAssertions.createStringsBlock(this.method), BlockAssertions.createDoublesBlock(0.0), BlockAssertions.createDoublesBlock(0.2));
    }

    @Test(expectedExceptions={PrestoException.class}, expectedExceptionsMessageRegExp="In differential_entropy UDF, sample must be at least min: sample=-100.0, min=0.0")
    public void testTooSmallSample() {
        AggregationTestUtils.aggregation(this.getFunction(), BlockAssertions.createLongsBlock(200), BlockAssertions.createDoublesBlock(-100.0), BlockAssertions.createDoublesBlock(0.2), BlockAssertions.createStringsBlock(this.method), BlockAssertions.createDoublesBlock(0.0), BlockAssertions.createDoublesBlock(0.2));
    }

    @Test(expectedExceptions={PrestoException.class}, expectedExceptionsMessageRegExp="In differential_entropy UDF, sample must be at most max: sample=300.0, max=0.2")
    public void testTooLargeSample() {
        AggregationTestUtils.aggregation(this.getFunction(), BlockAssertions.createLongsBlock(200), BlockAssertions.createDoublesBlock(300.0), BlockAssertions.createDoublesBlock(0.2), BlockAssertions.createStringsBlock(this.method), BlockAssertions.createDoublesBlock(0.0), BlockAssertions.createDoublesBlock(0.2));
    }

    @Test(expectedExceptions={PrestoException.class}, expectedExceptionsMessageRegExp="In differential_entropy UDF, min must be larger than max: min=0.2, max=0.1")
    public void testIllegalMinMax() {
        AggregationTestUtils.aggregation(this.getFunction(), BlockAssertions.createLongsBlock(200), BlockAssertions.createDoublesBlock(0.1), BlockAssertions.createDoublesBlock(0.2), BlockAssertions.createStringsBlock(this.method), BlockAssertions.createDoublesBlock(0.2), BlockAssertions.createDoublesBlock(0.1));
    }

    @Override
    public Double getExpectedValue(int start, int length) {
        ArrayList<Double> samples = new ArrayList<Double>();
        ArrayList<Double> weights = new ArrayList<Double>();
        TestFixedHistogramMleAggregation.generateSamplesAndWeights(start, length, samples, weights);
        return TestFixedHistogramMleAggregation.calculateEntropy(samples, weights);
    }
}

