/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.differentialentropy;

import com.facebook.presto.operator.aggregation.differentialentropy.UnweightedDoubleReservoirSample;
import java.util.Arrays;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestUnweightedDoubleReservoirSample {
    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Maximum number of samples must be positive: 0")
    public void testIllegalMaxSamples() {
        new UnweightedDoubleReservoirSample(0);
    }

    @Test
    public void testGetMaxSamples() {
        UnweightedDoubleReservoirSample reservoir = new UnweightedDoubleReservoirSample(200);
        Assert.assertEquals((int)reservoir.getMaxSamples(), (int)200);
        Assert.assertEquals((int)reservoir.getTotalPopulationCount(), (int)0);
    }

    @Test
    public void testFew() {
        UnweightedDoubleReservoirSample reservoir = new UnweightedDoubleReservoirSample(200);
        reservoir.add(1.0);
        reservoir.add(2.0);
        reservoir.add(3.0);
        Assert.assertEquals((double[])Arrays.stream(reservoir.getSamples()).sorted().toArray(), (double[])new double[]{1.0, 2.0, 3.0});
        Assert.assertEquals((int)reservoir.getTotalPopulationCount(), (int)3);
    }

    @Test
    public void testMany() {
        UnweightedDoubleReservoirSample reservoir = new UnweightedDoubleReservoirSample(200);
        long streamLength = 1000000L;
        int i = 0;
        while ((long)i < streamLength) {
            Assert.assertEquals((int)reservoir.getTotalPopulationCount(), (int)i);
            reservoir.add((double)i);
            ++i;
        }
        double[] quantized = new double[4];
        for (double sample : reservoir.getSamples()) {
            int index;
            int n = index = (int)(4.0 * sample / (double)(streamLength + 1L));
            quantized[n] = quantized[n] + 1.0;
        }
        int expectedMin = 25;
        for (int i2 = 0; i2 < 4; ++i2) {
            Assert.assertTrue((quantized[i2] > (double)expectedMin ? 1 : 0) != 0, (String)String.format("Expected quantized[i] > got: i=%s, quantized=%s, got=%s", i2, quantized[i2], expectedMin));
        }
    }
}

