/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.minmaxby;

import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.bytecode.DynamicClassLoader;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.DictionaryBlock;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.SqlDecimal;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.UnknownType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.operator.aggregation.AggregationTestUtils;
import com.facebook.presto.operator.aggregation.minmaxby.KeyAndBlockPositionValueState;
import com.facebook.presto.operator.aggregation.minmaxby.LongAndBlockPositionStateSerializer;
import com.facebook.presto.operator.aggregation.minmaxby.LongAndBlockPositionValueState;
import com.facebook.presto.operator.aggregation.state.StateCompiler;
import com.facebook.presto.spi.function.AccumulatorStateFactory;
import com.facebook.presto.spi.function.JavaAggregationFunctionImplementation;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.util.StructuralTestUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestMinMaxByAggregation {
    private static final MetadataManager metadata = MetadataManager.createTestMetadataManager();
    private static final FunctionAndTypeManager FUNCTION_AND_TYPE_MANAGER = metadata.getFunctionAndTypeManager();

    @Test
    public void testAllRegistered() {
        Set orderableTypes = (Set)TestMinMaxByAggregation.getTypes().stream().filter(Type::isOrderable).collect(ImmutableSet.toImmutableSet());
        for (Type keyType : orderableTypes) {
            for (Type valueType : TestMinMaxByAggregation.getTypes()) {
                if (!StateCompiler.getSupportedFieldTypes().contains(valueType.getJavaType())) continue;
                Assert.assertNotNull((Object)this.getMinByAggregation(valueType, keyType));
                Assert.assertNotNull((Object)this.getMaxByAggregation(valueType, keyType));
            }
        }
    }

    private static List<Type> getTypes() {
        List simpleTypes = metadata.getFunctionAndTypeManager().getTypes();
        return new ImmutableList.Builder().addAll((Iterable)simpleTypes).add((Object)VarcharType.VARCHAR).add((Object)DecimalType.createDecimalType((int)1)).add((Object)RowType.anonymous((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR, (Object)DoubleType.DOUBLE))).build();
    }

    @Test
    public void testMinUnknown() {
        JavaAggregationFunctionImplementation unknownKey = this.getMinByAggregation(new Type[]{UnknownType.UNKNOWN, DoubleType.DOUBLE});
        AggregationTestUtils.assertAggregation(unknownKey, null, BlockAssertions.createBooleansBlock(null, null), BlockAssertions.createDoublesBlock(1.0, 2.0));
        JavaAggregationFunctionImplementation unknownValue = this.getMinByAggregation(new Type[]{DoubleType.DOUBLE, UnknownType.UNKNOWN});
        AggregationTestUtils.assertAggregation(unknownValue, null, BlockAssertions.createDoublesBlock(1.0, 2.0), BlockAssertions.createBooleansBlock(null, null));
    }

    @Test
    public void testMaxUnknown() {
        JavaAggregationFunctionImplementation unknownKey = this.getMaxByAggregation(new Type[]{UnknownType.UNKNOWN, DoubleType.DOUBLE});
        AggregationTestUtils.assertAggregation(unknownKey, null, BlockAssertions.createBooleansBlock(null, null), BlockAssertions.createDoublesBlock(1.0, 2.0));
        JavaAggregationFunctionImplementation unknownValue = this.getMaxByAggregation(new Type[]{DoubleType.DOUBLE, UnknownType.UNKNOWN});
        AggregationTestUtils.assertAggregation(unknownValue, null, BlockAssertions.createDoublesBlock(1.0, 2.0), BlockAssertions.createBooleansBlock(null, null));
    }

    @Test
    public void testMinNull() {
        JavaAggregationFunctionImplementation function = this.getMinByAggregation(new Type[]{DoubleType.DOUBLE, DoubleType.DOUBLE});
        AggregationTestUtils.assertAggregation(function, (Object)1.0, BlockAssertions.createDoublesBlock(1.0, null), BlockAssertions.createDoublesBlock(1.0, 2.0));
        AggregationTestUtils.assertAggregation(function, (Object)10.0, BlockAssertions.createDoublesBlock(10.0, 9.0, 8.0, 11.0), BlockAssertions.createDoublesBlock(1.0, null, 2.0, null));
    }

    @Test
    public void testMaxNull() {
        JavaAggregationFunctionImplementation function = this.getMaxByAggregation(new Type[]{DoubleType.DOUBLE, DoubleType.DOUBLE});
        AggregationTestUtils.assertAggregation(function, null, BlockAssertions.createDoublesBlock(1.0, null), BlockAssertions.createDoublesBlock(1.0, 2.0));
        AggregationTestUtils.assertAggregation(function, (Object)10.0, BlockAssertions.createDoublesBlock(8.0, 9.0, 10.0, 11.0), BlockAssertions.createDoublesBlock(-2.0, null, -1.0, null));
    }

    @Test
    public void testMinDoubleDouble() {
        JavaAggregationFunctionImplementation function = this.getMinByAggregation(new Type[]{DoubleType.DOUBLE, DoubleType.DOUBLE});
        AggregationTestUtils.assertAggregation(function, null, BlockAssertions.createDoublesBlock(null, null), BlockAssertions.createDoublesBlock(null, null));
        AggregationTestUtils.assertAggregation(function, (Object)3.0, BlockAssertions.createDoublesBlock(3.0, 2.0, 5.0, 3.0), BlockAssertions.createDoublesBlock(1.0, 1.5, 2.0, 4.0));
    }

    @Test
    public void testMaxDoubleDouble() {
        JavaAggregationFunctionImplementation function = this.getMaxByAggregation(new Type[]{DoubleType.DOUBLE, DoubleType.DOUBLE});
        AggregationTestUtils.assertAggregation(function, null, BlockAssertions.createDoublesBlock(null, null), BlockAssertions.createDoublesBlock(null, null));
        AggregationTestUtils.assertAggregation(function, (Object)2.0, BlockAssertions.createDoublesBlock(3.0, 2.0, null), BlockAssertions.createDoublesBlock(1.0, 1.5, null));
    }

    @Test
    public void testMinDoubleVarchar() {
        JavaAggregationFunctionImplementation function = this.getMinByAggregation(new Type[]{VarcharType.VARCHAR, DoubleType.DOUBLE});
        AggregationTestUtils.assertAggregation(function, (Object)"z", BlockAssertions.createStringsBlock("z", "a", "x", "b"), BlockAssertions.createDoublesBlock(1.0, 2.0, 2.0, 3.0));
        AggregationTestUtils.assertAggregation(function, (Object)"a", BlockAssertions.createStringsBlock("zz", "hi", "bb", "a"), BlockAssertions.createDoublesBlock(0.0, 1.0, 2.0, -1.0));
    }

    @Test
    public void testMaxDoubleVarchar() {
        JavaAggregationFunctionImplementation function = this.getMaxByAggregation(new Type[]{VarcharType.VARCHAR, DoubleType.DOUBLE});
        AggregationTestUtils.assertAggregation(function, (Object)"a", BlockAssertions.createStringsBlock("z", "a", null), BlockAssertions.createDoublesBlock(1.0, 2.0, null));
        AggregationTestUtils.assertAggregation(function, (Object)"hi", BlockAssertions.createStringsBlock("zz", "hi", null, "a"), BlockAssertions.createDoublesBlock(0.0, 1.0, null, -1.0));
    }

    @Test
    public void testMinLongLongArray() {
        JavaAggregationFunctionImplementation function = this.getMinByAggregation(new Type[]{new ArrayType((Type)BigintType.BIGINT), BigintType.BIGINT});
        AggregationTestUtils.assertAggregation(function, (Object)ImmutableList.of((Object)8L, (Object)9L), BlockAssertions.createArrayBigintBlock((Iterable<? extends Iterable<Long>>)ImmutableList.of((Object)ImmutableList.of((Object)8L, (Object)9L), (Object)ImmutableList.of((Object)1L, (Object)2L), (Object)ImmutableList.of((Object)6L, (Object)7L), (Object)ImmutableList.of((Object)2L, (Object)3L))), BlockAssertions.createLongsBlock(1L, 2L, 2L, 3L));
        AggregationTestUtils.assertAggregation(function, (Object)ImmutableList.of((Object)2L), BlockAssertions.createArrayBigintBlock((Iterable<? extends Iterable<Long>>)ImmutableList.of((Object)ImmutableList.of((Object)8L, (Object)9L), (Object)ImmutableList.of((Object)6L, (Object)7L), (Object)ImmutableList.of((Object)2L, (Object)3L), (Object)ImmutableList.of((Object)2L))), BlockAssertions.createLongsBlock(0L, 1L, 2L, -1L));
    }

    @Test
    public void testMinLongArrayLong() {
        JavaAggregationFunctionImplementation function = this.getMinByAggregation(new Type[]{BigintType.BIGINT, new ArrayType((Type)BigintType.BIGINT)});
        AggregationTestUtils.assertAggregation(function, (Object)3L, BlockAssertions.createLongsBlock(1L, 2L, 2L, 3L), BlockAssertions.createArrayBigintBlock((Iterable<? extends Iterable<Long>>)ImmutableList.of((Object)ImmutableList.of((Object)8L, (Object)9L), (Object)ImmutableList.of((Object)1L, (Object)2L), (Object)ImmutableList.of((Object)6L, (Object)7L), (Object)ImmutableList.of((Object)1L, (Object)1L))));
        AggregationTestUtils.assertAggregation(function, (Object)-1L, BlockAssertions.createLongsBlock(0L, 1L, 2L, -1L), BlockAssertions.createArrayBigintBlock((Iterable<? extends Iterable<Long>>)ImmutableList.of((Object)ImmutableList.of((Object)8L, (Object)9L), (Object)ImmutableList.of((Object)6L, (Object)7L), (Object)ImmutableList.of((Object)-1L, (Object)-3L), (Object)ImmutableList.of((Object)-1L))));
    }

    @Test
    public void testMaxLongArrayLong() {
        JavaAggregationFunctionImplementation function = this.getMaxByAggregation(new Type[]{BigintType.BIGINT, new ArrayType((Type)BigintType.BIGINT)});
        AggregationTestUtils.assertAggregation(function, (Object)1L, BlockAssertions.createLongsBlock(1L, 2L, 2L, 3L), BlockAssertions.createArrayBigintBlock((Iterable<? extends Iterable<Long>>)ImmutableList.of((Object)ImmutableList.of((Object)8L, (Object)9L), (Object)ImmutableList.of((Object)1L, (Object)2L), (Object)ImmutableList.of((Object)6L, (Object)7L), (Object)ImmutableList.of((Object)1L, (Object)1L))));
        AggregationTestUtils.assertAggregation(function, (Object)2L, BlockAssertions.createLongsBlock(0L, 1L, 2L, -1L), BlockAssertions.createArrayBigintBlock((Iterable<? extends Iterable<Long>>)ImmutableList.of((Object)ImmutableList.of((Object)-8L, (Object)9L), (Object)ImmutableList.of((Object)-6L, (Object)7L), (Object)ImmutableList.of((Object)-1L, (Object)-3L), (Object)ImmutableList.of((Object)-1L))));
    }

    @Test
    public void testMaxLongLongArray() {
        JavaAggregationFunctionImplementation function = this.getMaxByAggregation(new Type[]{new ArrayType((Type)BigintType.BIGINT), BigintType.BIGINT});
        AggregationTestUtils.assertAggregation(function, (Object)ImmutableList.of((Object)1L, (Object)2L), BlockAssertions.createArrayBigintBlock(Arrays.asList(Arrays.asList(3L, 4L), Arrays.asList(1L, 2L), null)), BlockAssertions.createLongsBlock(1L, 2L, null));
        AggregationTestUtils.assertAggregation(function, (Object)ImmutableList.of((Object)2L, (Object)3L), BlockAssertions.createArrayBigintBlock(Arrays.asList(Arrays.asList(3L, 4L), Arrays.asList(2L, 3L), null, Arrays.asList(1L, 2L))), BlockAssertions.createLongsBlock(0L, 1L, null, -1L));
    }

    @Test
    public void testMinLongDecimalDecimal() {
        DecimalType decimalType = DecimalType.createDecimalType((int)19, (int)1);
        JavaAggregationFunctionImplementation function = this.getMinByAggregation(new Type[]{decimalType, decimalType});
        AggregationTestUtils.assertAggregation(function, (Object)SqlDecimal.of((String)"2.2"), BlockAssertions.createLongDecimalsBlock("1.1", "2.2", "3.3"), BlockAssertions.createLongDecimalsBlock("1.2", "1.0", "2.0"));
    }

    @Test
    public void testMaxLongDecimalDecimal() {
        DecimalType decimalType = DecimalType.createDecimalType((int)19, (int)1);
        JavaAggregationFunctionImplementation function = this.getMaxByAggregation(new Type[]{decimalType, decimalType});
        AggregationTestUtils.assertAggregation(function, (Object)SqlDecimal.of((String)"3.3"), BlockAssertions.createLongDecimalsBlock("1.1", "2.2", "3.3", "4.4"), BlockAssertions.createLongDecimalsBlock("1.2", "1.0", "2.0", "1.5"));
    }

    @Test
    public void testMinShortDecimalDecimal() {
        DecimalType decimalType = DecimalType.createDecimalType((int)10, (int)1);
        JavaAggregationFunctionImplementation function = this.getMinByAggregation(new Type[]{decimalType, decimalType});
        AggregationTestUtils.assertAggregation(function, (Object)SqlDecimal.of((String)"2.2"), BlockAssertions.createShortDecimalsBlock("1.1", "2.2", "3.3"), BlockAssertions.createShortDecimalsBlock("1.2", "1.0", "2.0"));
    }

    @Test
    public void testMaxShortDecimalDecimal() {
        DecimalType decimalType = DecimalType.createDecimalType((int)10, (int)1);
        JavaAggregationFunctionImplementation function = this.getMaxByAggregation(new Type[]{decimalType, decimalType});
        AggregationTestUtils.assertAggregation(function, (Object)SqlDecimal.of((String)"3.3"), BlockAssertions.createShortDecimalsBlock("1.1", "2.2", "3.3", "4.4"), BlockAssertions.createShortDecimalsBlock("1.2", "1.0", "2.0", "1.5"));
    }

    @Test
    public void testMinBooleanVarchar() {
        JavaAggregationFunctionImplementation function = this.getMinByAggregation(new Type[]{VarcharType.VARCHAR, BooleanType.BOOLEAN});
        AggregationTestUtils.assertAggregation(function, (Object)"b", BlockAssertions.createStringsBlock("a", "b", "c"), BlockAssertions.createBooleansBlock(true, false, true));
    }

    @Test
    public void testMaxBooleanVarchar() {
        JavaAggregationFunctionImplementation function = this.getMaxByAggregation(new Type[]{VarcharType.VARCHAR, BooleanType.BOOLEAN});
        AggregationTestUtils.assertAggregation(function, (Object)"c", BlockAssertions.createStringsBlock("a", "b", "c"), BlockAssertions.createBooleansBlock(false, false, true));
    }

    @Test
    public void testMinIntegerVarchar() {
        JavaAggregationFunctionImplementation function = this.getMinByAggregation(new Type[]{VarcharType.VARCHAR, IntegerType.INTEGER});
        AggregationTestUtils.assertAggregation(function, (Object)"a", BlockAssertions.createStringsBlock("a", "b", "c"), BlockAssertions.createIntsBlock(1, 2, 3));
    }

    @Test
    public void testMaxIntegerVarchar() {
        JavaAggregationFunctionImplementation function = this.getMaxByAggregation(new Type[]{VarcharType.VARCHAR, IntegerType.INTEGER});
        AggregationTestUtils.assertAggregation(function, (Object)"c", BlockAssertions.createStringsBlock("a", "b", "c"), BlockAssertions.createIntsBlock(1, 2, 3));
    }

    @Test
    public void testMinBooleanLongArray() {
        JavaAggregationFunctionImplementation function = this.getMinByAggregation(new Type[]{new ArrayType((Type)BigintType.BIGINT), BooleanType.BOOLEAN});
        AggregationTestUtils.assertAggregation(function, null, BlockAssertions.createArrayBigintBlock(Arrays.asList(Arrays.asList(3L, 4L), null, null)), BlockAssertions.createBooleansBlock(true, false, true));
    }

    @Test
    public void testMaxBooleanLongArray() {
        JavaAggregationFunctionImplementation function = this.getMaxByAggregation(new Type[]{new ArrayType((Type)BigintType.BIGINT), BooleanType.BOOLEAN});
        AggregationTestUtils.assertAggregation(function, Arrays.asList(2L, 2L), BlockAssertions.createArrayBigintBlock(Arrays.asList(Arrays.asList(3L, 4L), null, Arrays.asList(2L, 2L))), BlockAssertions.createBooleansBlock(false, false, true));
    }

    @Test
    public void testMinLongVarchar() {
        JavaAggregationFunctionImplementation function = this.getMinByAggregation(new Type[]{VarcharType.VARCHAR, BigintType.BIGINT});
        AggregationTestUtils.assertAggregation(function, (Object)"a", BlockAssertions.createStringsBlock("a", "b", "c"), BlockAssertions.createLongsBlock(1, 2, 3));
    }

    @Test
    public void testMaxLongVarchar() {
        JavaAggregationFunctionImplementation function = this.getMaxByAggregation(new Type[]{VarcharType.VARCHAR, BigintType.BIGINT});
        AggregationTestUtils.assertAggregation(function, (Object)"c", BlockAssertions.createStringsBlock("a", "b", "c"), BlockAssertions.createLongsBlock(1, 2, 3));
    }

    @Test
    public void testMinDoubleLongArray() {
        JavaAggregationFunctionImplementation function = this.getMinByAggregation(new Type[]{new ArrayType((Type)BigintType.BIGINT), DoubleType.DOUBLE});
        AggregationTestUtils.assertAggregation(function, Arrays.asList(3L, 4L), BlockAssertions.createArrayBigintBlock(Arrays.asList(Arrays.asList(3L, 4L), null, Arrays.asList(2L, 2L))), BlockAssertions.createDoublesBlock(1.0, 2.0, 3.0));
        AggregationTestUtils.assertAggregation(function, null, BlockAssertions.createArrayBigintBlock(Arrays.asList(null, null, Arrays.asList(2L, 2L))), BlockAssertions.createDoublesBlock(0.0, 1.0, 2.0));
    }

    @Test
    public void testMaxDoubleLongArray() {
        JavaAggregationFunctionImplementation function = this.getMaxByAggregation(new Type[]{new ArrayType((Type)BigintType.BIGINT), DoubleType.DOUBLE});
        AggregationTestUtils.assertAggregation(function, null, BlockAssertions.createArrayBigintBlock(Arrays.asList(Arrays.asList(3L, 4L), null, Arrays.asList(2L, 2L))), BlockAssertions.createDoublesBlock(1.0, 2.0, null));
        AggregationTestUtils.assertAggregation(function, Arrays.asList(2L, 2L), BlockAssertions.createArrayBigintBlock(Arrays.asList(Arrays.asList(3L, 4L), null, Arrays.asList(2L, 2L))), BlockAssertions.createDoublesBlock(0.0, 1.0, 2.0));
    }

    @Test
    public void testMinSliceLongArray() {
        JavaAggregationFunctionImplementation function = this.getMinByAggregation(new Type[]{new ArrayType((Type)BigintType.BIGINT), VarcharType.VARCHAR});
        AggregationTestUtils.assertAggregation(function, Arrays.asList(3L, 4L), BlockAssertions.createArrayBigintBlock(Arrays.asList(Arrays.asList(3L, 4L), null, Arrays.asList(2L, 2L))), BlockAssertions.createStringsBlock("a", "b", "c"));
        AggregationTestUtils.assertAggregation(function, null, BlockAssertions.createArrayBigintBlock(Arrays.asList(null, null, Arrays.asList(2L, 2L))), BlockAssertions.createStringsBlock("a", "b", "c"));
    }

    @Test
    public void testMaxSliceLongArray() {
        JavaAggregationFunctionImplementation function = this.getMaxByAggregation(new Type[]{new ArrayType((Type)BigintType.BIGINT), VarcharType.VARCHAR});
        AggregationTestUtils.assertAggregation(function, Arrays.asList(2L, 2L), BlockAssertions.createArrayBigintBlock(Arrays.asList(Arrays.asList(3L, 4L), null, Arrays.asList(2L, 2L))), BlockAssertions.createStringsBlock("a", "b", "c"));
        AggregationTestUtils.assertAggregation(function, null, BlockAssertions.createArrayBigintBlock(Arrays.asList(Arrays.asList(3L, 4L), null, null)), BlockAssertions.createStringsBlock("a", "b", "c"));
    }

    @Test
    public void testMinLongArrayLongArray() {
        JavaAggregationFunctionImplementation function = this.getMinByAggregation(new Type[]{new ArrayType((Type)BigintType.BIGINT), new ArrayType((Type)BigintType.BIGINT)});
        AggregationTestUtils.assertAggregation(function, Arrays.asList(1L, 2L), BlockAssertions.createArrayBigintBlock(Arrays.asList(Arrays.asList(3L, 3L), null, Arrays.asList(1L, 2L))), BlockAssertions.createArrayBigintBlock(Arrays.asList(Arrays.asList(3L, 4L), null, Arrays.asList(2L, 2L))));
    }

    @Test
    public void testMaxLongArrayLongArray() {
        JavaAggregationFunctionImplementation function = this.getMaxByAggregation(new Type[]{new ArrayType((Type)BigintType.BIGINT), new ArrayType((Type)BigintType.BIGINT)});
        AggregationTestUtils.assertAggregation(function, Arrays.asList(3L, 3L), BlockAssertions.createArrayBigintBlock(Arrays.asList(Arrays.asList(3L, 3L), null, Arrays.asList(1L, 2L))), BlockAssertions.createArrayBigintBlock(Arrays.asList(Arrays.asList(3L, 4L), null, Arrays.asList(2L, 2L))));
    }

    @Test
    public void testMinLongArraySlice() {
        JavaAggregationFunctionImplementation function = this.getMinByAggregation(new Type[]{VarcharType.VARCHAR, new ArrayType((Type)BigintType.BIGINT)});
        AggregationTestUtils.assertAggregation(function, (Object)"c", BlockAssertions.createStringsBlock("a", "b", "c"), BlockAssertions.createArrayBigintBlock(Arrays.asList(Arrays.asList(3L, 4L), null, Arrays.asList(2L, 2L))));
    }

    @Test
    public void testMaxLongArraySlice() {
        JavaAggregationFunctionImplementation function = this.getMaxByAggregation(new Type[]{VarcharType.VARCHAR, new ArrayType((Type)BigintType.BIGINT)});
        AggregationTestUtils.assertAggregation(function, (Object)"a", BlockAssertions.createStringsBlock("a", "b", "c"), BlockAssertions.createArrayBigintBlock(Arrays.asList(Arrays.asList(3L, 4L), null, Arrays.asList(2L, 2L))));
    }

    @Test
    public void testMinUnknownSlice() {
        JavaAggregationFunctionImplementation function = this.getMinByAggregation(new Type[]{VarcharType.VARCHAR, UnknownType.UNKNOWN});
        AggregationTestUtils.assertAggregation(function, null, BlockAssertions.createStringsBlock("a", "b", "c"), BlockAssertions.createArrayBigintBlock(Arrays.asList(null, null, null)));
    }

    @Test
    public void testMaxUnknownSlice() {
        JavaAggregationFunctionImplementation function = this.getMaxByAggregation(new Type[]{VarcharType.VARCHAR, UnknownType.UNKNOWN});
        AggregationTestUtils.assertAggregation(function, null, BlockAssertions.createStringsBlock("a", "b", "c"), BlockAssertions.createArrayBigintBlock(Arrays.asList(null, null, null)));
    }

    @Test
    public void testMinUnknownLongArray() {
        JavaAggregationFunctionImplementation function = this.getMinByAggregation(new Type[]{new ArrayType((Type)BigintType.BIGINT), UnknownType.UNKNOWN});
        AggregationTestUtils.assertAggregation(function, null, BlockAssertions.createArrayBigintBlock(Arrays.asList(Arrays.asList(3L, 3L), null, Arrays.asList(1L, 2L))), BlockAssertions.createArrayBigintBlock(Arrays.asList(null, null, null)));
    }

    @Test
    public void testMaxUnknownLongArray() {
        JavaAggregationFunctionImplementation function = this.getMaxByAggregation(new Type[]{new ArrayType((Type)BigintType.BIGINT), UnknownType.UNKNOWN});
        AggregationTestUtils.assertAggregation(function, null, BlockAssertions.createArrayBigintBlock(Arrays.asList(Arrays.asList(3L, 3L), null, Arrays.asList(1L, 2L))), BlockAssertions.createArrayBigintBlock(Arrays.asList(null, null, null)));
    }

    @Test
    public void testLongAndBlockPositionValueStateSerialization() {
        MapType mapType = StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)BooleanType.BOOLEAN);
        ImmutableMap fieldMap = ImmutableMap.of((Object)"Key", (Object)BigintType.BIGINT, (Object)"Value", (Object)mapType);
        AccumulatorStateFactory factory = StateCompiler.generateStateFactory(LongAndBlockPositionValueState.class, (Map)fieldMap, (DynamicClassLoader)new DynamicClassLoader(LongAndBlockPositionValueState.class.getClassLoader()));
        LongAndBlockPositionStateSerializer serializer = new LongAndBlockPositionStateSerializer((Type)BigintType.BIGINT, (Type)mapType);
        LongAndBlockPositionValueState singleState = (LongAndBlockPositionValueState)factory.createSingleState();
        LongAndBlockPositionValueState deserializedState = (LongAndBlockPositionValueState)factory.createSingleState();
        singleState.setFirst(2020L);
        singleState.setFirstNull(false);
        BlockBuilder builder = RowType.anonymous((List)ImmutableList.of((Object)BooleanType.BOOLEAN, (Object)BooleanType.BOOLEAN, (Object)BigintType.BIGINT, (Object)mapType)).createBlockBuilder(null, 1);
        serializer.serialize((KeyAndBlockPositionValueState)singleState, builder);
        Block rowBlock = builder.build();
        DictionaryBlock dictionaryBlock = (DictionaryBlock)rowBlock.getPositions(new int[]{0}, 0, 1);
        serializer.deserialize((Block)dictionaryBlock, 0, (KeyAndBlockPositionValueState)deserializedState);
        Assert.assertEquals((boolean)deserializedState.isFirstNull(), (boolean)singleState.isFirstNull());
        Assert.assertEquals((long)deserializedState.getFirst(), (long)singleState.getFirst());
    }

    private JavaAggregationFunctionImplementation getMinByAggregation(Type ... arguments) {
        return FUNCTION_AND_TYPE_MANAGER.getJavaAggregateFunctionImplementation(FUNCTION_AND_TYPE_MANAGER.lookupFunction("min_by", TypeSignatureProvider.fromTypes((Type[])arguments)));
    }

    private JavaAggregationFunctionImplementation getMaxByAggregation(Type ... arguments) {
        return FUNCTION_AND_TYPE_MANAGER.getJavaAggregateFunctionImplementation(FUNCTION_AND_TYPE_MANAGER.lookupFunction("max_by", TypeSignatureProvider.fromTypes((Type[])arguments)));
    }
}

